/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.LegacyNameGenerator;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.map.naming.ObjectNameGenerator;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.EntityMergeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityMergeSupport {
    private static final Log LOG = LogFactory.getLog(EntityMergeSupport.class);
    private static final Map<String, String> CLASS_TO_PRIMITIVE = new HashMap<String, String>();
    private final DataMap map;
    protected boolean removeMeaningfulFKs;
    protected boolean removeMeaningfulPKs;
    protected boolean usePrimitives;
    private final ObjectNameGenerator nameGenerator;
    private final List<EntityMergeListener> listeners = new ArrayList<EntityMergeListener>();

    public EntityMergeSupport(DataMap map) {
        this(map, new LegacyNameGenerator(), true);
    }

    public EntityMergeSupport(DataMap map, ObjectNameGenerator nameGenerator, boolean removeMeaningfulPKs) {
        this.map = map;
        this.nameGenerator = nameGenerator;
        this.removeMeaningfulFKs = true;
        this.removeMeaningfulPKs = removeMeaningfulPKs;
        this.addEntityMergeListener(DeleteRuleUpdater.getEntityMergeListener());
    }

    public boolean synchronizeWithDbEntities(Iterable<ObjEntity> objEntities) {
        boolean changed = false;
        for (ObjEntity nextEntity : objEntities) {
            if (!this.synchronizeWithDbEntity(nextEntity)) continue;
            changed = true;
        }
        return changed;
    }

    protected boolean removePK(DbEntity dbEntity) {
        return this.removeMeaningfulPKs;
    }

    protected boolean removeFK(DbEntity dbEntity) {
        return this.removeMeaningfulFKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronizeWithDbEntity(ObjEntity entity) {
        if (entity == null) {
            return false;
        }
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity == null) {
            return false;
        }
        boolean changed = false;
        DataMap dataMap = this.map;
        synchronized (dataMap) {
            if (this.removeFK(dbEntity)) {
                changed = this.getRidOfAttributesThatAreNowSrcAttributesForRelationships(entity);
            }
            changed |= this.addMissingAttributes(entity);
        }
        return changed |= this.addMissingRelationships(entity);
    }

    private boolean addMissingRelationships(ObjEntity entity) {
        List<DbRelationship> relationshipsToAdd = this.getRelationshipsToAdd(entity);
        if (relationshipsToAdd.isEmpty()) {
            return false;
        }
        for (DbRelationship dr : relationshipsToAdd) {
            DbEntity targetEntity = dr.getTargetEntity();
            Collection<ObjEntity> mappedObjEntities = this.map.getMappedEntities(targetEntity);
            if (!mappedObjEntities.isEmpty()) {
                for (Entity entity2 : mappedObjEntities) {
                    this.createObjRelationship(entity, dr, entity2.getName());
                }
                continue;
            }
            LOG.warn((Object)("Can't find ObjEntity for " + dr.getTargetEntityName()));
            LOG.warn((Object)("Db Relationship (" + dr + ") will have GUESSED Obj Relationship reflection. "));
            if (targetEntity == null) {
                targetEntity = new DbEntity(dr.getTargetEntityName());
            }
            this.createObjRelationship(entity, dr, this.nameGenerator.createObjEntityName(targetEntity));
        }
        return true;
    }

    private void createObjRelationship(ObjEntity entity, DbRelationship dr, String targetEntityName) {
        String relationshipName = this.nameGenerator.createObjRelationshipName(dr);
        relationshipName = DefaultUniqueNameGenerator.generate(NameCheckers.objRelationship, entity, relationshipName);
        ObjRelationship or = new ObjRelationship(relationshipName);
        or.addDbRelationship(dr);
        or.setSourceEntity(entity);
        or.setTargetEntityName(targetEntityName);
        entity.addRelationship(or);
        this.fireRelationshipAdded(or);
    }

    private boolean addMissingAttributes(ObjEntity entity) {
        boolean changed = false;
        for (DbAttribute da : this.getAttributesToAdd(entity)) {
            String primitive;
            String attrName = DefaultUniqueNameGenerator.generate(NameCheckers.objAttribute, entity, this.nameGenerator.createObjAttributeName(da));
            String type = TypesMapping.getJavaBySqlType(da.getType());
            if (this.usePrimitives && (primitive = CLASS_TO_PRIMITIVE.get(type)) != null) {
                type = primitive;
            }
            ObjAttribute oa = new ObjAttribute(attrName, type, entity);
            oa.setDbAttributePath(da.getName());
            entity.addAttribute(oa);
            this.fireAttributeAdded(oa);
            changed = true;
        }
        return changed;
    }

    private boolean getRidOfAttributesThatAreNowSrcAttributesForRelationships(ObjEntity entity) {
        boolean changed = false;
        for (DbAttribute da : this.getMeaningfulFKs(entity)) {
            ObjAttribute oa = entity.getAttributeForDbAttribute(da);
            while (oa != null) {
                String attrName = oa.getName();
                entity.removeAttribute(attrName);
                changed = true;
                oa = entity.getAttributeForDbAttribute(da);
            }
        }
        return changed;
    }

    public Collection<DbAttribute> getMeaningfulFKs(ObjEntity objEntity) {
        ArrayList<DbAttribute> fks = new ArrayList<DbAttribute>(2);
        for (ObjAttribute property : objEntity.getAttributes()) {
            DbAttribute column = property.getDbAttribute();
            if (column == null || !column.isForeignKey()) continue;
            fks.add(column);
        }
        return fks;
    }

    protected List<DbAttribute> getAttributesToAdd(ObjEntity objEntity) {
        DbEntity dbEntity = objEntity.getDbEntity();
        ArrayList<DbAttribute> missing = new ArrayList<DbAttribute>();
        Collection<DbRelationship> rels = dbEntity.getRelationships();
        Collection<DbRelationship> incomingRels = this.getIncomingRelationships(dbEntity);
        for (DbAttribute dba : dbEntity.getAttributes()) {
            DbRelationship rel;
            boolean removeMeaningfulPKs;
            if (dba.getName() == null || objEntity.getAttributeForDbAttribute(dba) != null || (removeMeaningfulPKs = this.removePK(dbEntity)) && dba.isPrimaryKey()) continue;
            boolean isFK = false;
            Iterator<DbRelationship> rit = rels.iterator();
            block1: while (!isFK && rit.hasNext()) {
                rel = rit.next();
                for (DbJoin join : rel.getJoins()) {
                    if (join.getSource() != dba) continue;
                    isFK = true;
                    continue block1;
                }
            }
            if (!removeMeaningfulPKs ? !dba.isPrimaryKey() && isFK : isFK) continue;
            rit = incomingRels.iterator();
            block3: while (!isFK && rit.hasNext()) {
                rel = rit.next();
                for (DbJoin join : rel.getJoins()) {
                    if (join.getTarget() != dba) continue;
                    isFK = true;
                    continue block3;
                }
            }
            if (!removeMeaningfulPKs ? !dba.isPrimaryKey() && isFK : isFK) continue;
            missing.add(dba);
        }
        return missing;
    }

    private Collection<DbRelationship> getIncomingRelationships(DbEntity entity) {
        ArrayList<DbRelationship> incoming = new ArrayList<DbRelationship>();
        for (DbEntity nextEntity : entity.getDataMap().getDbEntities()) {
            for (DbRelationship relationship : nextEntity.getRelationships()) {
                if (entity != relationship.getTargetEntity()) continue;
                incoming.add(relationship);
            }
        }
        return incoming;
    }

    protected List<DbRelationship> getRelationshipsToAdd(ObjEntity objEntity) {
        ArrayList<DbRelationship> missing = new ArrayList<DbRelationship>();
        for (DbRelationship dbRel : objEntity.getDbEntity().getRelationships()) {
            if (dbRel.getName() == null || objEntity.getRelationshipForDbRelationship(dbRel) != null) continue;
            missing.add(dbRel);
        }
        return missing;
    }

    public boolean isRemoveMeaningfulFKs() {
        return this.removeMeaningfulFKs;
    }

    public void setRemoveMeaningfulFKs(boolean removeMeaningfulFKs) {
        this.removeMeaningfulFKs = removeMeaningfulFKs;
    }

    public void addEntityMergeListener(EntityMergeListener listener) {
        this.listeners.add(listener);
    }

    public void removeEntityMergeListener(EntityMergeListener listener) {
        this.listeners.remove(listener);
    }

    public EntityMergeListener[] getEntityMergeListeners() {
        return this.listeners.toArray(new EntityMergeListener[this.listeners.size()]);
    }

    protected void fireAttributeAdded(ObjAttribute attr) {
        for (EntityMergeListener listener : this.listeners) {
            listener.objAttributeAdded(attr);
        }
    }

    protected void fireRelationshipAdded(ObjRelationship rel) {
        for (EntityMergeListener listener : this.listeners) {
            listener.objRelationshipAdded(rel);
        }
    }

    public ObjectNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    static {
        CLASS_TO_PRIMITIVE.put(Byte.class.getName(), "byte");
        CLASS_TO_PRIMITIVE.put(Long.class.getName(), "long");
        CLASS_TO_PRIMITIVE.put(Double.class.getName(), "double");
        CLASS_TO_PRIMITIVE.put(Boolean.class.getName(), "boolean");
        CLASS_TO_PRIMITIVE.put(Float.class.getName(), "float");
        CLASS_TO_PRIMITIVE.put(Short.class.getName(), "short");
        CLASS_TO_PRIMITIVE.put(Integer.class.getName(), "int");
    }
}

