/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.FlattenedArcKey;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;

class DataDomainFlattenedBucket {
    final DataDomainFlushAction parent;
    final Map<DbEntity, List<FlattenedArcKey>> insertArcKeys;
    final Map<DbEntity, DeleteBatchQuery> flattenedDeleteQueries;

    DataDomainFlattenedBucket(DataDomainFlushAction parent) {
        this.parent = parent;
        this.insertArcKeys = new HashMap<DbEntity, List<FlattenedArcKey>>();
        this.flattenedDeleteQueries = new HashMap<DbEntity, DeleteBatchQuery>();
    }

    boolean isEmpty() {
        return this.insertArcKeys.isEmpty() && this.flattenedDeleteQueries.isEmpty();
    }

    void addInsertArcKey(DbEntity flattenedEntity, FlattenedArcKey flattenedArcKey) {
        List<FlattenedArcKey> arcKeys = this.insertArcKeys.get(flattenedEntity);
        if (arcKeys == null) {
            arcKeys = new ArrayList<FlattenedArcKey>();
            this.insertArcKeys.put(flattenedEntity, arcKeys);
        }
        arcKeys.add(flattenedArcKey);
    }

    void addFlattenedDelete(DbEntity flattenedEntity, FlattenedArcKey flattenedDeleteInfo) {
        DataNode node;
        List flattenedSnapshots;
        DeleteBatchQuery relationDeleteQuery = this.flattenedDeleteQueries.get(flattenedEntity);
        if (relationDeleteQuery == null) {
            boolean optimisticLocking = false;
            Collection<DbAttribute> pk = flattenedEntity.getPrimaryKeys();
            List<Object> pkList = pk instanceof List ? (List<Object>)pk : new ArrayList<DbAttribute>(pk);
            relationDeleteQuery = new DeleteBatchQuery(flattenedEntity, (List<DbAttribute>)pkList, Collections.emptySet(), 50);
            relationDeleteQuery.setUsingOptimisticLocking(optimisticLocking);
            this.flattenedDeleteQueries.put(flattenedEntity, relationDeleteQuery);
        }
        if (!(flattenedSnapshots = flattenedDeleteInfo.buildJoinSnapshotsForDelete(node = this.parent.getDomain().lookupDataNode(flattenedEntity.getDataMap()))).isEmpty()) {
            Iterator snapsIt = flattenedSnapshots.iterator();
            while (snapsIt.hasNext()) {
                relationDeleteQuery.add((Map)snapsIt.next());
            }
        }
    }

    void appendInserts(Collection<Query> queries) {
        for (Map.Entry<DbEntity, List<FlattenedArcKey>> entry : this.insertArcKeys.entrySet()) {
            DbEntity dbEntity = entry.getKey();
            List<FlattenedArcKey> flattenedArcKeys = entry.getValue();
            DataNode node = this.parent.getDomain().lookupDataNode(dbEntity.getDataMap());
            InsertBatchQuery existingQuery = this.findInsertBatchQuery(queries, dbEntity);
            InsertBatchQuery newQuery = new InsertBatchQuery(dbEntity, 50);
            for (FlattenedArcKey flattenedArcKey : flattenedArcKeys) {
                BatchQueryRow existingRow;
                Map<String, Object> snapshot = flattenedArcKey.buildJoinSnapshotForInsert(node);
                if (existingQuery != null && (existingRow = this.findRowForObjectId(existingQuery.getRows(), flattenedArcKey.id1.getSourceId())) != null) {
                    List<DbAttribute> existingQueryDbAttributes = existingQuery.getDbAttributes();
                    for (int i = 0; i < existingQueryDbAttributes.size(); ++i) {
                        Object value = existingRow.getValue(i);
                        if (value == null) continue;
                        snapshot.put(existingQueryDbAttributes.get(i).getName(), value);
                    }
                }
                newQuery.add(snapshot);
            }
            if (existingQuery != null) {
                queries.remove(existingQuery);
            }
            queries.add(newQuery);
        }
    }

    void appendDeletes(Collection<Query> queries) {
        if (!this.flattenedDeleteQueries.isEmpty()) {
            queries.addAll(this.flattenedDeleteQueries.values());
        }
    }

    private InsertBatchQuery findInsertBatchQuery(Collection<Query> queries, DbEntity dbEntity) {
        for (Query query : queries) {
            InsertBatchQuery insertBatchQuery;
            if (!(query instanceof InsertBatchQuery) || !(insertBatchQuery = (InsertBatchQuery)query).getDbEntity().equals(dbEntity)) continue;
            return insertBatchQuery;
        }
        return null;
    }

    private BatchQueryRow findRowForObjectId(List<BatchQueryRow> rows, ObjectId objectId) {
        for (BatchQueryRow row : rows) {
            if (!row.getObjectId().equals(objectId)) continue;
            return row;
        }
        return null;
    }
}

