/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.translator.select.JoinStack;
import org.apache.cayenne.access.translator.select.OrderingTranslator;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;

public class DefaultSelectTranslator
extends QueryAssembler
implements SelectTranslator {
    protected static final int[] UNSUPPORTED_DISTINCT_TYPES = new int[]{2004, 2005, 2011, -4, -1, -16};
    JoinStack joinStack;
    List<ColumnDescriptor> resultColumns;
    Map<ObjAttribute, ColumnDescriptor> attributeOverrides;
    Map<ColumnDescriptor, ObjAttribute> defaultAttributesByColumn;
    boolean suppressingDistinct;
    boolean forcingDistinct;

    protected static boolean isUnsupportedForDistinct(int type) {
        for (int unsupportedDistinctType : UNSUPPORTED_DISTINCT_TYPES) {
            if (unsupportedDistinctType != type) continue;
            return true;
        }
        return false;
    }

    public DefaultSelectTranslator(Query query, DbAdapter adapter, EntityResolver entityResolver) {
        super(query, adapter, entityResolver);
    }

    protected JoinStack getJoinStack() {
        if (this.joinStack == null) {
            this.joinStack = this.createJoinStack();
        }
        return this.joinStack;
    }

    protected JoinStack createJoinStack() {
        return new JoinStack(this.getAdapter(), this.queryMetadata.getDataMap(), this);
    }

    @Override
    protected void doTranslate() {
        DataMap dataMap = this.queryMetadata.getDataMap();
        JoinStack joins = this.getJoinStack();
        QuotingStrategy strategy = this.getAdapter().getQuotingStrategy();
        this.forcingDistinct = false;
        this.resultColumns = this.buildResultColumns();
        QualifierTranslator qualifierTranslator = this.adapter.getQualifierTranslator(this);
        StringBuilder qualifierBuffer = qualifierTranslator.appendPart(new StringBuilder());
        OrderingTranslator orderingTranslator = new OrderingTranslator(this);
        StringBuilder orderingBuffer = orderingTranslator.appendPart(new StringBuilder());
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT ");
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            this.suppressingDistinct = false;
            for (ColumnDescriptor columnDescriptor : this.resultColumns) {
                if (!DefaultSelectTranslator.isUnsupportedForDistinct(columnDescriptor.getJdbcType())) continue;
                this.suppressingDistinct = true;
                break;
            }
            if (!this.suppressingDistinct) {
                queryBuf.append(this.buildDistinctStatement() + " ");
            }
        }
        ArrayList<String> selectColumnExpList = new ArrayList<String>();
        for (ColumnDescriptor column : this.resultColumns) {
            String fullName = strategy.quotedIdentifier(dataMap, column.getNamePrefix(), column.getName());
            selectColumnExpList.add(fullName);
        }
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            List<String> list = orderingTranslator.getOrderByColumnList();
            for (String orderByColumnExp : list) {
                if (selectColumnExpList.contains(orderByColumnExp)) continue;
                selectColumnExpList.add(orderByColumnExp);
            }
        }
        this.appendSelectColumns(queryBuf, selectColumnExpList);
        queryBuf.append(" FROM ");
        joins.appendRootWithQuoteSqlIdentifiers(queryBuf, this.getQueryMetadata().getDbEntity());
        joins.appendJoins(queryBuf);
        joins.appendQualifier(qualifierBuffer, qualifierBuffer.length() == 0);
        if (qualifierBuffer.length() > 0) {
            queryBuf.append(" WHERE ");
            queryBuf.append((CharSequence)qualifierBuffer);
        }
        if (orderingBuffer.length() > 0) {
            queryBuf.append(" ORDER BY ").append((CharSequence)orderingBuffer);
        }
        if (!this.isSuppressingDistinct()) {
            this.appendLimitAndOffsetClauses(queryBuf);
        }
        this.sql = queryBuf.toString();
    }

    protected String buildDistinctStatement() {
        return "DISTINCT";
    }

    protected void appendSelectColumns(StringBuilder buffer, List<String> selectColumnExpList) {
        int columnCount = selectColumnExpList.size();
        buffer.append(selectColumnExpList.get(0));
        for (int i = 1; i < columnCount; ++i) {
            buffer.append(", ");
            buffer.append(selectColumnExpList.get(i));
        }
    }

    protected void appendLimitAndOffsetClauses(StringBuilder buffer) {
    }

    @Override
    public String getCurrentAlias() {
        return this.getJoinStack().getCurrentAlias();
    }

    @Override
    public ColumnDescriptor[] getResultColumns() {
        if (this.resultColumns == null || this.resultColumns.isEmpty()) {
            return new ColumnDescriptor[0];
        }
        return this.resultColumns.toArray(new ColumnDescriptor[this.resultColumns.size()]);
    }

    @Override
    public Map<ObjAttribute, ColumnDescriptor> getAttributeOverrides() {
        if (this.attributeOverrides != null) {
            return this.attributeOverrides;
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isSuppressingDistinct() {
        return this.suppressingDistinct;
    }

    private SelectQuery<?> getSelectQuery() {
        return (SelectQuery)this.getQuery();
    }

    protected List<ColumnDescriptor> buildResultColumns() {
        this.defaultAttributesByColumn = new HashMap<ColumnDescriptor, ObjAttribute>();
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        SelectQuery<?> query = this.getSelectQuery();
        if (query.getRoot() instanceof DbEntity) {
            this.appendDbEntityColumns(columns, query);
        } else if (this.getQueryMetadata().getPageSize() > 0) {
            this.appendIdColumns(columns, query);
        } else {
            this.appendQueryColumns(columns, query);
        }
        return columns;
    }

    <T> List<ColumnDescriptor> appendDbEntityColumns(List<ColumnDescriptor> columns, SelectQuery<T> query) {
        HashSet<ColumnTracker> attributes = new HashSet<ColumnTracker>();
        DbEntity table = this.getQueryMetadata().getDbEntity();
        for (DbAttribute dba : table.getAttributes()) {
            this.appendColumn(columns, null, dba, attributes, null);
        }
        return columns;
    }

    <T> List<ColumnDescriptor> appendQueryColumns(final List<ColumnDescriptor> columns, SelectQuery<T> query) {
        Entity targetEntity;
        final HashSet<ColumnTracker> attributes = new HashSet<ColumnTracker>();
        ClassDescriptor descriptor = this.queryMetadata.getClassDescriptor();
        ObjEntity oe = descriptor.getEntity();
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                DefaultSelectTranslator.this.resetJoinStack();
                Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry pathPart = dbPathIterator.next();
                    if (pathPart == null) {
                        throw new CayenneRuntimeException("ObjAttribute has no component: " + oa.getName(), new Object[0]);
                    }
                    if (pathPart instanceof DbRelationship) {
                        DbRelationship rel = (DbRelationship)pathPart;
                        DefaultSelectTranslator.this.dbRelationshipAdded(rel, JoinType.LEFT_OUTER, null);
                        continue;
                    }
                    if (!(pathPart instanceof DbAttribute)) continue;
                    DbAttribute dbAttr = (DbAttribute)pathPart;
                    DefaultSelectTranslator.this.appendColumn(columns, oa, dbAttr, attributes, null);
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                this.visitRelationship(property);
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                this.visitRelationship(property);
                return true;
            }

            private void visitRelationship(ArcProperty property) {
                DefaultSelectTranslator.this.resetJoinStack();
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                List<DbJoin> joins = dbRel.getJoins();
                for (DbJoin join : joins) {
                    DbAttribute src = join.getSource();
                    DefaultSelectTranslator.this.appendColumn(columns, null, src, attributes, null);
                }
            }
        };
        descriptor.visitAllProperties(visitor);
        this.resetJoinStack();
        DbEntity table = this.getQueryMetadata().getDbEntity();
        for (DbAttribute dba : table.getPrimaryKeys()) {
            this.appendColumn(columns, null, dba, attributes, null);
        }
        if (query instanceof PrefetchSelectQuery) {
            for (String path : ((PrefetchSelectQuery)query).getResultPaths()) {
                DbRelationship relationship;
                ASTDbPath pathExp = (ASTDbPath)oe.translateToDbPath(ExpressionFactory.exp(path, new Object[0]));
                this.resetJoinStack();
                PathComponent<DbAttribute, DbRelationship> lastComponent = null;
                for (PathComponent<DbAttribute, DbRelationship> component : table.resolvePath(pathExp, this.getPathAliases())) {
                    if (component.getRelationship() != null) {
                        this.getJoinStack().pushJoin(component.getRelationship(), component.getJoinType(), null);
                    }
                    lastComponent = component;
                }
                if (lastComponent == null || (relationship = (DbRelationship)lastComponent.getRelationship()) == null) continue;
                String labelPrefix = pathExp.getPath();
                targetEntity = relationship.getTargetEntity();
                for (DbAttribute dbAttribute : ((DbEntity)targetEntity).getPrimaryKeys()) {
                    this.appendColumn(columns, null, dbAttribute, attributes, (String)labelPrefix + '.' + dbAttribute.getName());
                }
            }
        }
        if (query.getPrefetchTree() != null) {
            for (PrefetchTreeNode prefetch : query.getPrefetchTree().adjacentJointNodes()) {
                Expression prefetchExp = ExpressionFactory.exp(prefetch.getPath(), new Object[0]);
                ASTDbPath dbPrefetch = (ASTDbPath)oe.translateToDbPath(prefetchExp);
                this.resetJoinStack();
                DbRelationship r = null;
                for (PathComponent<DbAttribute, DbRelationship> component : table.resolvePath(dbPrefetch, this.getPathAliases())) {
                    r = component.getRelationship();
                    this.dbRelationshipAdded(r, JoinType.LEFT_OUTER, null);
                }
                if (r == null) {
                    throw new CayenneRuntimeException("Invalid joint prefetch '" + prefetch + "' for entity: " + oe.getName(), new Object[0]);
                }
                ObjRelationship targetRel = (ObjRelationship)prefetchExp.evaluate(oe);
                targetEntity = targetRel.getTargetEntity();
                String labelPrefix = dbPrefetch.getPath();
                for (ObjAttribute oa : ((ObjEntity)targetEntity).getAttributes()) {
                    Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                    while (dbPathIterator.hasNext()) {
                        CayenneMapEntry pathPart = dbPathIterator.next();
                        if (pathPart == null) {
                            throw new CayenneRuntimeException("ObjAttribute has no component: " + oa.getName(), new Object[0]);
                        }
                        if (pathPart instanceof DbRelationship) {
                            DbRelationship rel = (DbRelationship)pathPart;
                            this.dbRelationshipAdded(rel, JoinType.INNER, null);
                            continue;
                        }
                        if (!(pathPart instanceof DbAttribute)) continue;
                        DbAttribute attribute = (DbAttribute)pathPart;
                        this.appendColumn(columns, oa, attribute, attributes, labelPrefix + '.' + attribute.getName());
                    }
                }
                DbEntity dbEntity = r.getTargetEntity();
                for (DbAttribute attribute : dbEntity.getAttributes()) {
                    this.appendColumn(columns, null, attribute, attributes, labelPrefix + '.' + attribute.getName());
                }
            }
        }
        return columns;
    }

    <T> List<ColumnDescriptor> appendIdColumns(List<ColumnDescriptor> columns, SelectQuery<T> query) {
        HashSet<ColumnTracker> skipSet = new HashSet<ColumnTracker>();
        ClassDescriptor descriptor = this.queryMetadata.getClassDescriptor();
        ObjEntity oe = descriptor.getEntity();
        DbEntity dbEntity = oe.getDbEntity();
        for (ObjAttribute attribute : oe.getPrimaryKeys()) {
            DbAttribute dbAttribute = dbEntity.getAttribute(attribute.getDbAttributeName());
            this.appendColumn(columns, attribute, dbAttribute, skipSet, null);
        }
        return columns;
    }

    private void appendColumn(List<ColumnDescriptor> columns, ObjAttribute objAttribute, DbAttribute attribute, Set<ColumnTracker> skipSet, String label) {
        String alias = this.getCurrentAlias();
        if (skipSet.add(new ColumnTracker(alias, attribute))) {
            ColumnDescriptor column;
            ColumnDescriptor columnDescriptor = column = objAttribute != null ? new ColumnDescriptor(objAttribute, attribute, alias) : new ColumnDescriptor(attribute, alias);
            if (label != null) {
                column.setDataRowKey(label);
            }
            columns.add(column);
            this.defaultAttributesByColumn.put(column, objAttribute);
        } else if (objAttribute != null) {
            for (ColumnDescriptor column : columns) {
                ObjAttribute original;
                if (!attribute.getName().equals(column.getName())) continue;
                if (this.attributeOverrides == null) {
                    this.attributeOverrides = new HashMap<ObjAttribute, ColumnDescriptor>();
                }
                if ((original = this.defaultAttributesByColumn.remove(column)) != null) {
                    this.attributeOverrides.put(original, column);
                }
                this.attributeOverrides.put(objAttribute, column);
                column.setJavaClass(Void.TYPE.getName());
                break;
            }
        }
    }

    @Override
    public void resetJoinStack() {
        this.getJoinStack().resetStack();
    }

    @Override
    public void dbRelationshipAdded(DbRelationship relationship, JoinType joinType, String joinSplitAlias) {
        if (relationship.isToMany()) {
            this.forcingDistinct = true;
        }
        this.getJoinStack().pushJoin(relationship, joinType, joinSplitAlias);
    }

    @Override
    public boolean supportsTableAliases() {
        return true;
    }

    static final class ColumnTracker {
        private DbAttribute attribute;
        private String alias;

        ColumnTracker(String alias, DbAttribute attribute) {
            this.attribute = attribute;
            this.alias = alias;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ColumnTracker)) {
                return false;
            }
            ColumnTracker other = (ColumnTracker)object;
            return new EqualsBuilder().append(this.alias, other.alias).append(this.attribute, other.attribute).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(31, 5).append(this.alias).append(this.attribute).toHashCode();
        }
    }
}

