/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.Module;

public class ModuleCollection
implements Module {
    private Collection<Module> modules = new ArrayList<Module>();

    public ModuleCollection(Module ... modules) {
        this.add(modules);
    }

    public ModuleCollection add(Module ... modules) {
        if (modules != null) {
            for (Module m : modules) {
                this.addModule(m);
            }
        }
        return this;
    }

    public ModuleCollection add(Collection<Module> modules) {
        if (modules != null) {
            for (Module m : modules) {
                this.addModule(m);
            }
        }
        return this;
    }

    private void addModule(Module m) {
        if (m instanceof ModuleCollection) {
            this.add(((ModuleCollection)m).getModules());
        } else {
            this.modules.add(m);
        }
    }

    public Collection<Module> getModules() {
        return this.modules;
    }

    public void configure(Binder binder) {
        for (Module m : this.modules) {
            m.configure(binder);
        }
    }
}

