/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DriverDataSource
implements DataSource {
    private static final Log LOGGER = LogFactory.getLog(DriverDataSource.class);
    protected Driver driver;
    protected String connectionUrl;
    protected String userName;
    protected String password;

    @Deprecated
    private static Driver loadDriver(String driverClassName) {
        Class<?> driverClass;
        try {
            driverClass = Util.getJavaClass(driverClassName);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Can not load JDBC driver named '" + driverClassName + "': " + ex.getMessage(), new Object[0]);
        }
        try {
            return (Driver)driverClass.newInstance();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error instantiating driver '" + driverClassName + "': " + ex.getMessage(), new Object[0]);
        }
    }

    @Deprecated
    public DriverDataSource(String driverClassName, String connectionUrl) {
        this(driverClassName, connectionUrl, null, null);
    }

    @Deprecated
    public DriverDataSource(String driverClassName, String connectionUrl, String userName, String password) {
        this(DriverDataSource.loadDriver(driverClassName), connectionUrl, userName, password);
    }

    public DriverDataSource(Driver driver, String connectionUrl, String userName, String password) {
        if (connectionUrl == null) {
            throw new NullPointerException("Null 'connectionUrl'");
        }
        this.driver = driver;
        this.connectionUrl = connectionUrl;
        this.userName = userName;
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            this.logConnect(this.connectionUrl, userName, password);
            Connection c = null;
            if (this.driver == null) {
                c = DriverManager.getConnection(this.connectionUrl, userName, password);
            } else {
                Properties connectProperties = new Properties();
                if (userName != null) {
                    connectProperties.put("user", userName);
                }
                if (password != null) {
                    connectProperties.put("password", password);
                }
                c = this.driver.connect(this.connectionUrl, connectProperties);
            }
            if (c == null) {
                throw new SQLException("Can't establish connection: " + this.connectionUrl);
            }
            LOGGER.info((Object)"+++ Connecting: SUCCESS.");
            return c;
        }
        catch (SQLException ex) {
            LOGGER.info((Object)"*** Connecting: FAILURE.", (Throwable)ex);
            throw ex;
        }
    }

    private void logConnect(String url, String userName, String password) {
        if (LOGGER.isInfoEnabled()) {
            StringBuilder buf = new StringBuilder("Connecting to '").append(url).append("' as '").append(userName).append("'");
            LOGGER.info((Object)buf.toString());
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return -1;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    @Deprecated
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Deprecated
    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    @Deprecated
    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public String getUserName() {
        return this.userName;
    }

    @Deprecated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }
}

