/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.util.Util;

public class TypesMapping {
    public static final int NOT_DEFINED = Integer.MAX_VALUE;
    public static final String SQL_ARRAY = "ARRAY";
    public static final String SQL_BIGINT = "BIGINT";
    public static final String SQL_BINARY = "BINARY";
    public static final String SQL_BIT = "BIT";
    public static final String SQL_BLOB = "BLOB";
    public static final String SQL_BOOLEAN = "BOOLEAN";
    public static final String SQL_CLOB = "CLOB";
    public static final String SQL_NCLOB = "NCLOB";
    public static final String SQL_CHAR = "CHAR";
    public static final String SQL_NCHAR = "NCHAR";
    public static final String SQL_DATE = "DATE";
    public static final String SQL_DECIMAL = "DECIMAL";
    public static final String SQL_DOUBLE = "DOUBLE";
    public static final String SQL_FLOAT = "FLOAT";
    public static final String SQL_INTEGER = "INTEGER";
    public static final String SQL_LONGVARCHAR = "LONGVARCHAR";
    public static final String SQL_LONGNVARCHAR = "LONGNVARCHAR";
    public static final String SQL_LONGVARBINARY = "LONGVARBINARY";
    public static final String SQL_NUMERIC = "NUMERIC";
    public static final String SQL_REAL = "REAL";
    public static final String SQL_SMALLINT = "SMALLINT";
    public static final String SQL_TINYINT = "TINYINT";
    public static final String SQL_TIME = "TIME";
    public static final String SQL_TIMESTAMP = "TIMESTAMP";
    public static final String SQL_VARBINARY = "VARBINARY";
    public static final String SQL_VARCHAR = "VARCHAR";
    public static final String SQL_NVARCHAR = "NVARCHAR";
    public static final String SQL_SQLXML = "SQLXML";
    public static final String SQL_OTHER = "OTHER";
    public static final String SQL_NULL = "NULL";
    public static final String JAVA_LONG = "java.lang.Long";
    public static final String JAVA_BYTES = "byte[]";
    public static final String JAVA_BOOLEAN = "java.lang.Boolean";
    public static final String JAVA_STRING = "java.lang.String";
    public static final String JAVA_SQLDATE = "java.sql.Date";
    public static final String JAVA_UTILDATE = "java.util.Date";
    public static final String JAVA_BIGDECIMAL = "java.math.BigDecimal";
    public static final String JAVA_DOUBLE = "java.lang.Double";
    public static final String JAVA_FLOAT = "java.lang.Float";
    public static final String JAVA_INTEGER = "java.lang.Integer";
    public static final String JAVA_SHORT = "java.lang.Short";
    public static final String JAVA_BYTE = "java.lang.Byte";
    public static final String JAVA_TIME = "java.sql.Time";
    public static final String JAVA_TIMESTAMP = "java.sql.Timestamp";
    public static final String JAVA_BLOB = "java.sql.Blob";
    private static final Map<String, Integer> SQL_STRING_TYPE = new HashMap<String, Integer>();
    private static final Map<Integer, String> SQL_ENUM_TYPE = new HashMap<Integer, String>();
    private static final Map<Integer, String> SQL_ENUM_JAVA = new HashMap<Integer, String>();
    private static final Map<String, Integer> JAVA_SQL_ENUM = new HashMap<String, Integer>();
    protected Map<Integer, List<TypeInfo>> databaseTypes = new HashMap<Integer, List<TypeInfo>>();

    public static boolean supportsLength(int type) {
        return JdbcAdapter.supportsLength(type);
    }

    public static boolean isCharacter(int type) {
        return type == 1 || type == -15 || type == 12 || type == -9 || type == 2005 || type == 2011 || type == -1 || type == -16;
    }

    public static boolean isBinary(int type) {
        return type == -2 || type == 2004 || type == -3 || type == -4;
    }

    public static boolean isNumeric(int type) {
        return type == -5 || type == -7 || type == 3 || type == 8 || type == 6 || type == 4 || type == 2 || type == 7 || type == 5 || type == -6;
    }

    public static boolean isDecimal(int type) {
        return type == 3 || type == 8 || type == 6 || type == 7 || type == 2;
    }

    public static String[] getDatabaseTypes() {
        Set<String> types = SQL_STRING_TYPE.keySet();
        return types.toArray(new String[types.size()]);
    }

    protected static String pickDataType(int jdbcType, TypeInfo[] alts) {
        String uppercase;
        int len = alts.length;
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            return alts[0].name;
        }
        String jdbcName = TypesMapping.getSqlNameByType(jdbcType).toUpperCase();
        for (TypeInfo alt : alts) {
            if (!jdbcName.equalsIgnoreCase(alt.name)) continue;
            return alt.name;
        }
        long maxPrec = 0L;
        for (TypeInfo alt : alts) {
            if (maxPrec >= alt.precision) continue;
            maxPrec = alt.precision;
        }
        ArrayList<TypeInfo> list = new ArrayList<TypeInfo>();
        for (TypeInfo alt : alts) {
            if (maxPrec != alt.precision) continue;
            list.add(alt);
        }
        int slen = list.size();
        if (slen == 1) {
            return ((TypeInfo)list.get((int)0)).name;
        }
        for (TypeInfo aList : list) {
            uppercase = aList.name.toUpperCase();
            if (!uppercase.startsWith(jdbcName) && !uppercase.endsWith(jdbcName)) continue;
            return aList.name;
        }
        for (TypeInfo aList : list) {
            uppercase = aList.name.toUpperCase();
            if (!uppercase.contains(jdbcName)) continue;
            return aList.name;
        }
        return ((TypeInfo)list.get((int)0)).name;
    }

    public static int getSqlTypeByName(String typeName) {
        Integer tmp = SQL_STRING_TYPE.get(typeName);
        return tmp == null ? Integer.MAX_VALUE : tmp;
    }

    public static String getSqlNameByType(int type) {
        return SQL_ENUM_TYPE.get(type);
    }

    public static int getSqlTypeByJava(String className) {
        Class<?> aClass;
        if (className == null) {
            return Integer.MAX_VALUE;
        }
        Integer type = JAVA_SQL_ENUM.get(className);
        if (type != null) {
            return type;
        }
        try {
            aClass = Util.getJavaClass(className);
        }
        catch (Throwable th) {
            return Integer.MAX_VALUE;
        }
        return TypesMapping.getSqlTypeByJava(aClass);
    }

    public static int getSqlTypeByJava(Class<?> javaClass) {
        if (javaClass == null) {
            return Integer.MAX_VALUE;
        }
        for (Class<?> aClass = javaClass; aClass != null; aClass = aClass.getSuperclass()) {
            String name = aClass.isArray() ? aClass.getComponentType().getName() + "[]" : aClass.getName();
            Integer type = JAVA_SQL_ENUM.get(name);
            if (type == null) continue;
            return ((Number)type).intValue();
        }
        if (javaClass.isArray()) {
            Class<?> elementType = javaClass.getComponentType();
            if (Character.class.isAssignableFrom(elementType) || Character.TYPE.isAssignableFrom(elementType)) {
                return 12;
            }
            if (Byte.class.isAssignableFrom(elementType) || Byte.TYPE.isAssignableFrom(elementType)) {
                return -3;
            }
        }
        if (Calendar.class.isAssignableFrom(javaClass)) {
            return 93;
        }
        if (BigInteger.class.isAssignableFrom(javaClass)) {
            return -5;
        }
        if (Serializable.class.isAssignableFrom(javaClass)) {
            return -3;
        }
        return Integer.MAX_VALUE;
    }

    public static String getJavaBySqlType(int type) {
        return SQL_ENUM_JAVA.get(type);
    }

    public TypesMapping(DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getTypeInfo();){
            while (rs.next()) {
                TypeInfo info = new TypeInfo();
                info.name = rs.getString("TYPE_NAME");
                info.jdbcType = rs.getInt("DATA_TYPE");
                info.precision = rs.getLong("PRECISION");
                Integer key = info.jdbcType;
                List<TypeInfo> infos = this.databaseTypes.get(key);
                if (infos == null) {
                    infos = new ArrayList<TypeInfo>();
                    this.databaseTypes.put(key, infos);
                }
                infos.add(info);
            }
        }
        this.swapTypes(93, 91);
        this.swapTypes(2005, -1);
        this.swapTypes(2004, -4);
        this.swapTypes(2011, -16);
    }

    private void swapTypes(int type1, int type2) {
        List<TypeInfo> type1Info = this.databaseTypes.get(type1);
        List<TypeInfo> type2Info = this.databaseTypes.get(type2);
        if (type1Info != null && type2Info == null) {
            this.databaseTypes.put(type2, type1Info);
        }
        if (type2Info != null && type1Info == null) {
            this.databaseTypes.put(type1, type2Info);
        }
    }

    static {
        SQL_STRING_TYPE.put(SQL_BIGINT, -5);
        SQL_STRING_TYPE.put(SQL_BINARY, -2);
        SQL_STRING_TYPE.put(SQL_BIT, -7);
        SQL_STRING_TYPE.put(SQL_BLOB, 2004);
        SQL_STRING_TYPE.put(SQL_BOOLEAN, 16);
        SQL_STRING_TYPE.put(SQL_CLOB, 2005);
        SQL_STRING_TYPE.put(SQL_NCLOB, 2011);
        SQL_STRING_TYPE.put(SQL_CHAR, 1);
        SQL_STRING_TYPE.put(SQL_NCHAR, -15);
        SQL_STRING_TYPE.put(SQL_DATE, 91);
        SQL_STRING_TYPE.put(SQL_DECIMAL, 3);
        SQL_STRING_TYPE.put(SQL_DOUBLE, 8);
        SQL_STRING_TYPE.put(SQL_FLOAT, 6);
        SQL_STRING_TYPE.put(SQL_INTEGER, 4);
        SQL_STRING_TYPE.put(SQL_LONGVARCHAR, -1);
        SQL_STRING_TYPE.put(SQL_LONGNVARCHAR, -16);
        SQL_STRING_TYPE.put(SQL_LONGVARBINARY, -4);
        SQL_STRING_TYPE.put(SQL_NUMERIC, 2);
        SQL_STRING_TYPE.put(SQL_REAL, 7);
        SQL_STRING_TYPE.put(SQL_SMALLINT, 5);
        SQL_STRING_TYPE.put(SQL_TINYINT, -6);
        SQL_STRING_TYPE.put(SQL_TIME, 92);
        SQL_STRING_TYPE.put(SQL_TIMESTAMP, 93);
        SQL_STRING_TYPE.put(SQL_VARBINARY, -3);
        SQL_STRING_TYPE.put(SQL_VARCHAR, 12);
        SQL_STRING_TYPE.put(SQL_NVARCHAR, -9);
        SQL_STRING_TYPE.put(SQL_OTHER, 1111);
        SQL_STRING_TYPE.put(SQL_NULL, 0);
        SQL_ENUM_TYPE.put(2003, SQL_ARRAY);
        SQL_ENUM_TYPE.put(-5, SQL_BIGINT);
        SQL_ENUM_TYPE.put(-2, SQL_BINARY);
        SQL_ENUM_TYPE.put(-7, SQL_BIT);
        SQL_ENUM_TYPE.put(16, SQL_BOOLEAN);
        SQL_ENUM_TYPE.put(2004, SQL_BLOB);
        SQL_ENUM_TYPE.put(2005, SQL_CLOB);
        SQL_ENUM_TYPE.put(2011, SQL_NCLOB);
        SQL_ENUM_TYPE.put(1, SQL_CHAR);
        SQL_ENUM_TYPE.put(-15, SQL_NCHAR);
        SQL_ENUM_TYPE.put(91, SQL_DATE);
        SQL_ENUM_TYPE.put(3, SQL_DECIMAL);
        SQL_ENUM_TYPE.put(8, SQL_DOUBLE);
        SQL_ENUM_TYPE.put(6, SQL_FLOAT);
        SQL_ENUM_TYPE.put(4, SQL_INTEGER);
        SQL_ENUM_TYPE.put(-1, SQL_LONGVARCHAR);
        SQL_ENUM_TYPE.put(-16, SQL_LONGNVARCHAR);
        SQL_ENUM_TYPE.put(-4, SQL_LONGVARBINARY);
        SQL_ENUM_TYPE.put(2, SQL_NUMERIC);
        SQL_ENUM_TYPE.put(7, SQL_REAL);
        SQL_ENUM_TYPE.put(5, SQL_SMALLINT);
        SQL_ENUM_TYPE.put(-6, SQL_TINYINT);
        SQL_ENUM_TYPE.put(92, SQL_TIME);
        SQL_ENUM_TYPE.put(93, SQL_TIMESTAMP);
        SQL_ENUM_TYPE.put(-3, SQL_VARBINARY);
        SQL_ENUM_TYPE.put(12, SQL_VARCHAR);
        SQL_ENUM_TYPE.put(-9, SQL_NVARCHAR);
        SQL_ENUM_TYPE.put(2009, SQL_SQLXML);
        SQL_ENUM_TYPE.put(1111, SQL_OTHER);
        SQL_ENUM_TYPE.put(0, SQL_NULL);
        SQL_ENUM_JAVA.put(-5, JAVA_LONG);
        SQL_ENUM_JAVA.put(-2, JAVA_BYTES);
        SQL_ENUM_JAVA.put(-7, JAVA_BOOLEAN);
        SQL_ENUM_JAVA.put(16, JAVA_BOOLEAN);
        SQL_ENUM_JAVA.put(2004, JAVA_BYTES);
        SQL_ENUM_JAVA.put(2005, JAVA_STRING);
        SQL_ENUM_JAVA.put(2011, JAVA_STRING);
        SQL_ENUM_JAVA.put(1, JAVA_STRING);
        SQL_ENUM_JAVA.put(-15, JAVA_STRING);
        SQL_ENUM_JAVA.put(91, JAVA_UTILDATE);
        SQL_ENUM_JAVA.put(3, JAVA_BIGDECIMAL);
        SQL_ENUM_JAVA.put(8, JAVA_DOUBLE);
        SQL_ENUM_JAVA.put(6, JAVA_FLOAT);
        SQL_ENUM_JAVA.put(4, JAVA_INTEGER);
        SQL_ENUM_JAVA.put(-1, JAVA_STRING);
        SQL_ENUM_JAVA.put(-16, JAVA_STRING);
        SQL_ENUM_JAVA.put(-4, JAVA_BYTES);
        SQL_ENUM_JAVA.put(2, JAVA_BIGDECIMAL);
        SQL_ENUM_JAVA.put(7, JAVA_FLOAT);
        SQL_ENUM_JAVA.put(5, JAVA_SHORT);
        SQL_ENUM_JAVA.put(-6, JAVA_SHORT);
        SQL_ENUM_JAVA.put(92, JAVA_UTILDATE);
        SQL_ENUM_JAVA.put(93, JAVA_UTILDATE);
        SQL_ENUM_JAVA.put(-3, JAVA_BYTES);
        SQL_ENUM_JAVA.put(12, JAVA_STRING);
        SQL_ENUM_JAVA.put(-9, JAVA_STRING);
        SQL_ENUM_JAVA.put(2009, JAVA_STRING);
        JAVA_SQL_ENUM.put(JAVA_LONG, -5);
        JAVA_SQL_ENUM.put(JAVA_BYTES, -2);
        JAVA_SQL_ENUM.put(JAVA_BOOLEAN, -7);
        JAVA_SQL_ENUM.put(JAVA_STRING, 12);
        JAVA_SQL_ENUM.put(JAVA_SQLDATE, 91);
        JAVA_SQL_ENUM.put(JAVA_UTILDATE, 91);
        JAVA_SQL_ENUM.put(JAVA_TIMESTAMP, 93);
        JAVA_SQL_ENUM.put(JAVA_BIGDECIMAL, 3);
        JAVA_SQL_ENUM.put(JAVA_DOUBLE, 8);
        JAVA_SQL_ENUM.put(JAVA_FLOAT, 6);
        JAVA_SQL_ENUM.put(JAVA_INTEGER, 4);
        JAVA_SQL_ENUM.put(JAVA_SHORT, 5);
        JAVA_SQL_ENUM.put(JAVA_BYTE, 5);
        JAVA_SQL_ENUM.put(JAVA_TIME, 92);
        JAVA_SQL_ENUM.put(JAVA_TIMESTAMP, 93);
        JAVA_SQL_ENUM.put("byte", -6);
        JAVA_SQL_ENUM.put("int", 4);
        JAVA_SQL_ENUM.put("short", 5);
        JAVA_SQL_ENUM.put("char", 1);
        JAVA_SQL_ENUM.put("double", 8);
        JAVA_SQL_ENUM.put("long", -5);
        JAVA_SQL_ENUM.put("float", 6);
        JAVA_SQL_ENUM.put("boolean", -7);
    }

    static class TypeInfo {
        String name;
        int jdbcType;
        long precision;

        TypeInfo() {
        }

        public String toString() {
            return "[   TypeInfo: " + this.name + "\n    JDBC Type: " + TypesMapping.getSqlNameByType(this.jdbcType) + "\n    Precision: " + this.precision + "\n]";
        }
    }
}

