/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.reflect.PropertyUtils;

public class Property<E> {
    private final String name;

    public Property(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Property && ((Property)obj).getName().equals(this.getName());
    }

    public Property<Object> dot(String property) {
        return new Property<Object>(this.getName() + "." + property);
    }

    public <T> Property<T> dot(Property<T> property) {
        return new Property<E>(this.getName() + "." + property.getName());
    }

    public Property<E> outer() {
        return this.isOuter() ? this : new Property<E>(this.name + "+");
    }

    private boolean isOuter() {
        return this.name.endsWith("+");
    }

    public Expression isNull() {
        return ExpressionFactory.matchExp(this.getName(), null);
    }

    public Expression isNotNull() {
        return ExpressionFactory.matchExp(this.getName(), null).notExp();
    }

    public Expression isTrue() {
        return ExpressionFactory.matchExp(this.getName(), Boolean.TRUE);
    }

    public Expression isFalse() {
        return ExpressionFactory.matchExp(this.getName(), Boolean.FALSE);
    }

    public Expression eq(E value) {
        return ExpressionFactory.matchExp(this.getName(), value);
    }

    public Expression eq(Property<?> value) {
        return ExpressionFactory.matchExp(this.getName(), new ASTObjPath(value.getName()));
    }

    public Expression ne(E value) {
        return ExpressionFactory.noMatchExp(this.getName(), value);
    }

    public Expression ne(Property<?> value) {
        return ExpressionFactory.noMatchExp(this.getName(), new ASTObjPath(value.getName()));
    }

    public Expression like(String pattern) {
        return ExpressionFactory.likeExp(this.getName(), pattern);
    }

    public Expression like(String pattern, char escapeChar) {
        return ExpressionFactory.likeExp(this.getName(), pattern, escapeChar);
    }

    public Expression likeIgnoreCase(String pattern) {
        return ExpressionFactory.likeIgnoreCaseExp(this.getName(), pattern);
    }

    public Expression nlike(String value) {
        return ExpressionFactory.notLikeExp(this.getName(), value);
    }

    public Expression nlikeIgnoreCase(String value) {
        return ExpressionFactory.notLikeIgnoreCaseExp(this.getName(), value);
    }

    public Expression contains(String substring) {
        return ExpressionFactory.containsExp(this.getName(), substring);
    }

    public Expression startsWith(String value) {
        return ExpressionFactory.startsWithExp(this.getName(), value);
    }

    public Expression endsWith(String value) {
        return ExpressionFactory.endsWithExp(this.getName(), value);
    }

    public Expression containsIgnoreCase(String value) {
        return ExpressionFactory.containsIgnoreCaseExp(this.getName(), value);
    }

    public Expression startsWithIgnoreCase(String value) {
        return ExpressionFactory.startsWithIgnoreCaseExp(this.getName(), value);
    }

    public Expression endsWithIgnoreCase(String value) {
        return ExpressionFactory.endsWithIgnoreCaseExp(this.getName(), value);
    }

    public Expression between(E lower, E upper) {
        return ExpressionFactory.betweenExp(this.getName(), lower, upper);
    }

    public Expression in(E firstValue, E ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getName(), values);
    }

    public Expression nin(E firstValue, E ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getName(), values);
    }

    public Expression in(Collection<E> values) {
        return ExpressionFactory.inExp(this.getName(), values);
    }

    public Expression nin(Collection<E> values) {
        return ExpressionFactory.notInExp(this.getName(), values);
    }

    public Expression gt(E value) {
        return ExpressionFactory.greaterExp(this.getName(), value);
    }

    public Expression gt(Property<?> value) {
        return ExpressionFactory.greaterExp(this.getName(), new ASTObjPath(value.getName()));
    }

    public Expression gte(E value) {
        return ExpressionFactory.greaterOrEqualExp(this.getName(), value);
    }

    public Expression gte(Property<?> value) {
        return ExpressionFactory.greaterOrEqualExp(this.getName(), new ASTObjPath(value.getName()));
    }

    public Expression lt(E value) {
        return ExpressionFactory.lessExp(this.getName(), value);
    }

    public Expression lt(Property<?> value) {
        return ExpressionFactory.lessExp(this.getName(), new ASTObjPath(value.getName()));
    }

    public Expression lte(E value) {
        return ExpressionFactory.lessOrEqualExp(this.getName(), value);
    }

    public Expression lte(Property<?> value) {
        return ExpressionFactory.lessOrEqualExp(this.getName(), new ASTObjPath(value.getName()));
    }

    public Ordering asc() {
        return new Ordering(this.getName(), SortOrder.ASCENDING);
    }

    public List<Ordering> ascs() {
        ArrayList<Ordering> result = new ArrayList<Ordering>(1);
        result.add(this.asc());
        return result;
    }

    public Ordering ascInsensitive() {
        return new Ordering(this.getName(), SortOrder.ASCENDING_INSENSITIVE);
    }

    public List<Ordering> ascInsensitives() {
        ArrayList<Ordering> result = new ArrayList<Ordering>(1);
        result.add(this.ascInsensitive());
        return result;
    }

    public Ordering desc() {
        return new Ordering(this.getName(), SortOrder.DESCENDING);
    }

    public List<Ordering> descs() {
        ArrayList<Ordering> result = new ArrayList<Ordering>(1);
        result.add(this.desc());
        return result;
    }

    public Ordering descInsensitive() {
        return new Ordering(this.getName(), SortOrder.DESCENDING_INSENSITIVE);
    }

    public List<Ordering> descInsensitives() {
        ArrayList<Ordering> result = new ArrayList<Ordering>(1);
        result.add(this.descInsensitive());
        return result;
    }

    public PrefetchTreeNode joint() {
        return PrefetchTreeNode.withPath(this.name, 1);
    }

    public PrefetchTreeNode disjoint() {
        return PrefetchTreeNode.withPath(this.name, 2);
    }

    public PrefetchTreeNode disjointById() {
        return PrefetchTreeNode.withPath(this.name, 3);
    }

    public E getFrom(Object bean) {
        return (E)PropertyUtils.getProperty(bean, this.getName());
    }

    public List<E> getFromAll(Collection<?> beans) {
        ArrayList<E> result = new ArrayList<E>(beans.size());
        for (Object bean : beans) {
            result.add(this.getFrom(bean));
        }
        return result;
    }

    public void setIn(Object bean, E value) {
        PropertyUtils.setProperty(bean, this.getName(), value);
    }

    public void setInAll(Collection<?> beans, E value) {
        for (Object bean : beans) {
            this.setIn(bean, value);
        }
    }
}

