/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQuery;

public class SelectById<T>
extends IndirectQuery
implements Select<T> {
    private static final long serialVersionUID = -6589464349051607583L;
    Class<?> entityType;
    String entityName;
    Object singleId;
    Map<String, ?> mapId;
    boolean fetchingDataRows;
    QueryCacheStrategy cacheStrategy;
    String[] cacheGroups;
    PrefetchTreeNode prefetches;

    public static <T> SelectById<T> query(Class<T> entityType, Object id) {
        SelectById<T> q = new SelectById<T>();
        q.entityType = entityType;
        q.singleId = id;
        q.fetchingDataRows = false;
        return q;
    }

    public static <T> SelectById<T> query(Class<T> entityType, Map<String, ?> id) {
        SelectById<T> q = new SelectById<T>();
        q.entityType = entityType;
        q.mapId = id;
        q.fetchingDataRows = false;
        return q;
    }

    public static <T> SelectById<T> query(Class<T> entityType, ObjectId id) {
        SelectById.checkObjectId(id);
        SelectById<T> q = new SelectById<T>();
        q.entityName = id.getEntityName();
        q.mapId = id.getIdSnapshot();
        q.fetchingDataRows = false;
        return q;
    }

    public static SelectById<DataRow> dataRowQuery(Class<?> entityType, Object id) {
        SelectById<DataRow> q = new SelectById<DataRow>();
        q.entityType = entityType;
        q.singleId = id;
        q.fetchingDataRows = true;
        return q;
    }

    public static SelectById<DataRow> dataRowQuery(Class<?> entityType, Map<String, Object> id) {
        SelectById<DataRow> q = new SelectById<DataRow>();
        q.entityType = entityType;
        q.mapId = id;
        q.fetchingDataRows = true;
        return q;
    }

    public static SelectById<DataRow> dataRowQuery(ObjectId id) {
        SelectById.checkObjectId(id);
        SelectById<DataRow> q = new SelectById<DataRow>();
        q.entityName = id.getEntityName();
        q.mapId = id.getIdSnapshot();
        q.fetchingDataRows = true;
        return q;
    }

    private static void checkObjectId(ObjectId id) {
        if (id.isTemporary() && !id.isReplacementIdAttached()) {
            throw new CayenneRuntimeException("Can't build a query for temporary id: " + id, new Object[0]);
        }
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this);
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }

    public SelectById<T> localCache(String ... cacheGroups) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroups);
    }

    public SelectById<T> sharedCache(String ... cacheGroups) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroups);
    }

    @Deprecated
    public SelectById<T> useLocalCache(String ... cacheGroups) {
        return this.localCache(cacheGroups);
    }

    @Deprecated
    public SelectById<T> useSharedCache(String ... cacheGroups) {
        return this.sharedCache(cacheGroups);
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public SelectById<T> cacheStrategy(QueryCacheStrategy strategy, String ... cacheGroups) {
        if (this.cacheStrategy != strategy) {
            this.cacheStrategy = strategy;
            this.replacementQuery = null;
        }
        return this.cacheGroups(cacheGroups);
    }

    public String[] getCacheGroups() {
        return this.cacheGroups;
    }

    public SelectById<T> cacheGroups(String ... cacheGroups) {
        this.cacheGroups = cacheGroups != null && cacheGroups.length > 0 ? cacheGroups : null;
        this.replacementQuery = null;
        return this;
    }

    public SelectById<T> cacheGroups(Collection<String> cacheGroups) {
        if (cacheGroups == null) {
            return this.cacheGroups(new String[]{null});
        }
        String[] array = new String[cacheGroups.size()];
        return this.cacheGroups(cacheGroups.toArray(array));
    }

    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }

    public SelectById<T> prefetch(PrefetchTreeNode prefetch) {
        if (prefetch == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.merge(prefetch);
        return this;
    }

    public SelectById<T> prefetch(String path, int semantics) {
        if (path == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.addPath(path).setSemantics(semantics);
        return this;
    }

    public PrefetchTreeNode getPrefetches() {
        return this.prefetches;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        ObjEntity entity = this.resolveEntity(resolver);
        Map<String, ?> id = this.resolveId(entity);
        SelectQuery query = new SelectQuery();
        query.setRoot(entity);
        query.setFetchingDataRows(this.fetchingDataRows);
        query.setQualifier(ExpressionFactory.matchAllDbExp(id, 3));
        query.setCacheGroups(this.cacheGroups);
        query.setCacheStrategy(this.cacheStrategy);
        query.setPrefetchTree(this.prefetches);
        return query;
    }

    protected Map<String, ?> resolveId(ObjEntity entity) {
        if (this.singleId == null && this.mapId == null) {
            throw new CayenneRuntimeException("Misconfigured query. Either singleId or mapId must be set", new Object[0]);
        }
        if (this.mapId != null) {
            return this.mapId;
        }
        Collection<String> pkAttributes = entity.getPrimaryKeyNames();
        if (pkAttributes.size() != 1) {
            throw new CayenneRuntimeException("PK contains " + pkAttributes.size() + " columns, expected 1.", new Object[0]);
        }
        String pk = pkAttributes.iterator().next();
        return Collections.singletonMap(pk, this.singleId);
    }

    protected ObjEntity resolveEntity(EntityResolver resolver) {
        if (this.entityName == null && this.entityType == null) {
            throw new CayenneRuntimeException("Misconfigured query. Either entityName or entityType must be set", new Object[0]);
        }
        return this.entityName != null ? resolver.getObjEntity(this.entityName) : resolver.getObjEntity(this.entityType);
    }
}

