/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class SQLTemplateResourceManager
extends ResourceLoader
implements ResourceManager {
    protected Map<String, Template> templateCache;

    public void initialize(RuntimeServices rs) throws Exception {
        this.rsvc = rs;
        this.templateCache = new LRUMap(100);
    }

    public void clearCache() {
        this.templateCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        Map<String, Template> map = this.templateCache;
        synchronized (map) {
            Template resource = this.templateCache.get(resourceName);
            if (resource == null) {
                resource = new Template();
                resource.setRuntimeServices(this.rsvc);
                resource.setResourceLoader((ResourceLoader)this);
                resource.setName(resourceName);
                resource.setEncoding(encoding);
                resource.process();
                this.templateCache.put(resourceName, resource);
            }
            return resource;
        }
    }

    public String getLoaderNameForResource(String resourceName) {
        return ((Object)((Object)this)).getClass().getName();
    }

    public long getLastModified(Resource resource) {
        return -1L;
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        return new ByteArrayInputStream(source.getBytes());
    }

    public void init(ExtendedProperties configuration) {
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }
}

