/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MySQLPkGenerator
extends JdbcPkGenerator {
    private static final Log logger = LogFactory.getLog(MySQLPkGenerator.class);

    MySQLPkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        SQLException exception = null;
        long pk = -1L;
        Transaction transaction = BaseTransaction.getThreadTransaction();
        if (transaction != null && transaction.isExternal()) {
            logger.warn((Object)"Using MysqlPkGenerator with external transaction manager may lead to inconsistent state.");
        }
        BaseTransaction.bindThreadTransaction(null);
        try (Connection con = node.getDataSource().getConnection();){
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
            try (Statement st = con.createStatement();){
                try {
                    pk = this.getLongPrimaryKey(st, entity.getName());
                    con.commit();
                }
                catch (SQLException pkEx) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    exception = this.processSQLException(pkEx, null);
                }
                finally {
                    try {
                        String unlockString = "UNLOCK TABLES";
                        this.adapter.getJdbcEventLogger().logQuery(unlockString, Collections.EMPTY_LIST);
                        st.execute(unlockString);
                    }
                    catch (SQLException unlockEx) {
                        exception = this.processSQLException(unlockEx, exception);
                    }
                }
            }
        }
        catch (SQLException otherEx) {
            exception = this.processSQLException(otherEx, null);
        }
        finally {
            BaseTransaction.bindThreadTransaction(transaction);
        }
        if (exception != null) {
            throw exception;
        }
        return pk;
    }

    protected SQLException processSQLException(SQLException exception, SQLException parent) {
        if (parent == null) {
            return exception;
        }
        parent.setNextException(exception);
        return parent;
    }

    @Override
    protected String dropAutoPkString() {
        return "DROP TABLE IF EXISTS AUTO_PK_SUPPORT";
    }

    @Override
    protected String pkTableCreateString() {
        return "CREATE TABLE IF NOT EXISTS AUTO_PK_SUPPORT (TABLE_NAME CHAR(100) NOT NULL, NEXT_ID BIGINT NOT NULL, UNIQUE (TABLE_NAME)) ENGINE=InnoDB";
    }

    protected long getLongPrimaryKey(Statement statement, String entityName) throws SQLException {
        long pk;
        String lockString = "LOCK TABLES AUTO_PK_SUPPORT WRITE";
        this.adapter.getJdbcEventLogger().logQuery(lockString, Collections.EMPTY_LIST);
        statement.execute(lockString);
        String selectString = super.pkSelectString(entityName);
        this.adapter.getJdbcEventLogger().logQuery(selectString, Collections.EMPTY_LIST);
        try (ResultSet rs = statement.executeQuery(selectString);){
            if (!rs.next()) {
                throw new SQLException("No rows for '" + entityName + "'");
            }
            pk = rs.getLong(1);
            if (rs.next()) {
                throw new SQLException("More than one row for '" + entityName + "'");
            }
        }
        String updateString = super.pkUpdateString(entityName) + " AND NEXT_ID = " + pk;
        this.adapter.getJdbcEventLogger().logQuery(updateString, Collections.EMPTY_LIST);
        int updated = statement.executeUpdate(updateString);
        if (updated != 1) {
            throw new SQLException("Error updating PK count '" + entityName + "': " + updated);
        }
        return pk;
    }
}

