/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.TraversalHelper;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.util.ConversionUtil;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.collections.Transformer;

public abstract class Expression
implements Serializable,
XMLSerializable {
    private static final long serialVersionUID = 5268695167038124596L;
    public static final Object PRUNED_NODE = new Object();
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EQUAL_TO = 3;
    public static final int NOT_EQUAL_TO = 4;
    public static final int LESS_THAN = 5;
    public static final int GREATER_THAN = 6;
    public static final int LESS_THAN_EQUAL_TO = 7;
    public static final int GREATER_THAN_EQUAL_TO = 8;
    public static final int BETWEEN = 9;
    public static final int IN = 10;
    public static final int LIKE = 11;
    public static final int LIKE_IGNORE_CASE = 12;
    public static final int ADD = 16;
    public static final int SUBTRACT = 17;
    public static final int MULTIPLY = 18;
    public static final int DIVIDE = 19;
    public static final int NEGATIVE = 20;
    public static final int TRUE = 21;
    public static final int FALSE = 22;
    public static final int OBJ_PATH = 26;
    public static final int DB_PATH = 27;
    public static final int LIST = 28;
    public static final int NOT_BETWEEN = 35;
    public static final int NOT_IN = 36;
    public static final int NOT_LIKE = 37;
    public static final int NOT_LIKE_IGNORE_CASE = 38;
    public static final int BITWISE_NOT = 39;
    public static final int BITWISE_AND = 40;
    public static final int BITWISE_OR = 41;
    public static final int BITWISE_XOR = 42;
    public static final int BITWISE_LEFT_SHIFT = 43;
    public static final int BITWISE_RIGHT_SHIFT = 44;
    public static final int FUNCTION_CALL = 45;
    public static final int ASTERISK = 46;
    protected int type;

    @Deprecated
    public static Expression fromString(String expressionString) {
        return ExpressionFactory.exp(expressionString, new Object[0]);
    }

    public abstract Map<String, String> getPathAliases();

    public String expName() {
        switch (this.type) {
            case 0: {
                return "AND";
            }
            case 1: {
                return "OR";
            }
            case 2: {
                return "NOT";
            }
            case 3: {
                return "=";
            }
            case 4: {
                return "<>";
            }
            case 5: {
                return "<";
            }
            case 7: {
                return "<=";
            }
            case 6: {
                return ">";
            }
            case 8: {
                return ">=";
            }
            case 9: {
                return "BETWEEN";
            }
            case 10: {
                return "IN";
            }
            case 11: {
                return "LIKE";
            }
            case 12: {
                return "LIKE_IGNORE_CASE";
            }
            case 26: {
                return "OBJ_PATH";
            }
            case 27: {
                return "DB_PATH";
            }
            case 28: {
                return "LIST";
            }
            case 35: {
                return "NOT BETWEEN";
            }
            case 36: {
                return "NOT IN";
            }
            case 37: {
                return "NOT LIKE";
            }
            case 38: {
                return "NOT LIKE IGNORE CASE";
            }
            case 45: {
                return "FUNCTION_CALL";
            }
        }
        return "other";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Expression)) {
            return false;
        }
        Expression e = (Expression)object;
        if (e.getType() != this.getType() || e.getOperandCount() != this.getOperandCount()) {
            return false;
        }
        int len = e.getOperandCount();
        for (int i = 0; i < len; ++i) {
            if (Util.nullSafeEquals(e.getOperand(i), this.getOperand(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append(this.getType());
        int opCount = this.getOperandCount();
        for (int i = 0; i < opCount; ++i) {
            builder.append(this.getOperand(i));
        }
        return builder.toHashCode();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Expression paramsArray(Object ... parameters) {
        Expression clone = this.deepCopy();
        clone.inPlaceParamsArray(parameters);
        return clone;
    }

    void inPlaceParamsArray(Object ... parameters) {
        InPlaceParamReplacer replacer = new InPlaceParamReplacer(parameters == null ? new Object[]{} : parameters);
        this.traverse(replacer);
        replacer.onFinish();
    }

    public Expression params(Map<String, ?> parameters) {
        return this.transform(new NamedParamTransformer(parameters, true));
    }

    public Expression params(Map<String, ?> parameters, boolean pruneMissing) {
        return this.transform(new NamedParamTransformer(parameters, pruneMissing));
    }

    @Deprecated
    public Expression expWithParameters(Map<String, ?> parameters) {
        return this.expWithParameters(parameters, true);
    }

    @Deprecated
    public Expression expWithParameters(Map<String, ?> parameters, boolean pruneMissing) {
        return this.params(parameters, pruneMissing);
    }

    public Expression joinExp(int type, Expression exp) {
        return this.joinExp(type, exp, new Expression[0]);
    }

    public Expression joinExp(int type, Expression exp, Expression ... expressions) {
        Expression join = ExpressionFactory.expressionOfType(type);
        join.setOperand(0, this);
        join.setOperand(1, exp);
        for (int i = 0; i < expressions.length; ++i) {
            Expression expressionInArray = expressions[i];
            join.setOperand(2 + i, expressionInArray);
        }
        join.flattenTree();
        return join;
    }

    public Expression andExp(Expression exp) {
        return this.joinExp(0, exp);
    }

    public Expression andExp(Expression exp, Expression ... expressions) {
        return this.joinExp(0, exp, expressions);
    }

    public Expression orExp(Expression exp) {
        return this.joinExp(1, exp);
    }

    public Expression orExp(Expression exp, Expression ... expressions) {
        return this.joinExp(1, exp, expressions);
    }

    public abstract Expression notExp();

    public abstract int getOperandCount();

    public abstract Object getOperand(int var1);

    public abstract void setOperand(int var1, Object var2);

    public abstract Object evaluate(Object var1);

    public boolean match(Object o) {
        return ConversionUtil.toBoolean(this.evaluate(o));
    }

    public <T> T first(List<T> objects) {
        for (T o : objects) {
            if (!this.match(o)) continue;
            return o;
        }
        return null;
    }

    public <T> List<T> filterObjects(Collection<T> objects) {
        if (objects == null || objects.size() == 0) {
            return new LinkedList();
        }
        return (List)this.filter(objects, new LinkedList());
    }

    public <T> Collection<?> filter(Collection<T> source, Collection<T> target) {
        for (T o : source) {
            if (!this.match(o)) continue;
            target.add(o);
        }
        return target;
    }

    public Expression deepCopy() {
        return this.transform(null);
    }

    public abstract Expression shallowCopy();

    protected abstract boolean pruneNodeForPrunedChild(Object var1);

    protected abstract void flattenTree();

    public void traverse(TraversalHandler visitor) {
        if (visitor == null) {
            throw new NullPointerException("Null Visitor.");
        }
        this.traverse(null, visitor);
    }

    protected void traverse(Expression parentExp, TraversalHandler visitor) {
        visitor.startNode(this, parentExp);
        int count = this.getOperandCount();
        for (int i = 0; i < count; ++i) {
            Object child = this.getOperand(i);
            if (child instanceof Expression && !(child instanceof ASTScalar)) {
                Expression childExp = (Expression)child;
                childExp.traverse(this, visitor);
            } else {
                visitor.objectNode(child, this);
            }
            visitor.finishedChild(this, i, i < count - 1);
        }
        visitor.endNode(this, parentExp);
    }

    public Expression transform(Transformer transformer) {
        Object transformed = this.transformExpression(transformer);
        if (transformed == PRUNED_NODE || transformed == null) {
            return null;
        }
        if (transformed instanceof Expression) {
            return (Expression)transformed;
        }
        throw new ExpressionException("Invalid transformed expression: " + transformed, new Object[0]);
    }

    protected Object transformExpression(Transformer transformer) {
        Expression copy = this.shallowCopy();
        int count = this.getOperandCount();
        int j = 0;
        for (int i = 0; i < count; ++i) {
            boolean prune;
            Object operand = this.getOperand(i);
            Object transformedChild = operand instanceof Expression ? ((Expression)operand).transformExpression(transformer) : (transformer != null ? transformer.transform(operand) : operand);
            boolean bl = prune = transformer != null && transformedChild == PRUNED_NODE;
            if (!prune) {
                copy.setOperand(j, transformedChild);
                ++j;
            }
            if (!prune || !this.pruneNodeForPrunedChild(operand)) continue;
            return PRUNED_NODE;
        }
        return transformer != null ? (Expression)transformer.transform((Object)copy) : copy;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<![CDATA[");
        try {
            this.appendAsString(encoder.getPrintWriter());
        }
        catch (IOException e) {
            throw new CayenneRuntimeException("Unexpected IO exception appending to PrintWriter", (Throwable)e, new Object[0]);
        }
        encoder.print("]]>");
    }

    @Deprecated
    public abstract void encodeAsString(PrintWriter var1);

    public abstract void appendAsString(Appendable var1) throws IOException;

    @Deprecated
    public abstract void encodeAsEJBQL(PrintWriter var1, String var2);

    public void appendAsEJBQL(Appendable out, String rootId) throws IOException {
        this.appendAsEJBQL(null, out, rootId);
    }

    public abstract void appendAsEJBQL(List<Object> var1, Appendable var2, String var3) throws IOException;

    public String toString() {
        StringBuilder out = new StringBuilder();
        try {
            this.appendAsString(out);
        }
        catch (IOException e) {
            throw new CayenneRuntimeException("Unexpected IO exception appending to StringBuilder", (Throwable)e, new Object[0]);
        }
        return out.toString();
    }

    public String toEJBQL(List<Object> parameterAccumulator, String rootId) {
        StringBuilder out = new StringBuilder();
        try {
            this.appendAsEJBQL(parameterAccumulator, out, rootId);
        }
        catch (IOException e) {
            throw new CayenneRuntimeException("Unexpected IO exception appending to StringBuilder", (Throwable)e, new Object[0]);
        }
        return out.toString();
    }

    public String toEJBQL(String rootId) {
        return this.toEJBQL(null, rootId);
    }

    final class InPlaceParamReplacer
    extends TraversalHelper {
        private Object[] parameters;
        private int i;
        private Map<String, Object> seen;

        InPlaceParamReplacer(Object[] parameters) {
            this.parameters = parameters;
        }

        void onFinish() {
            if (this.i < this.parameters.length) {
                throw new ExpressionException("Too many parameters to bind expression. Expected: " + this.i + ", actual: " + this.parameters.length, new Object[0]);
            }
        }

        @Override
        public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
            Object child = node.getOperand(childIndex);
            if (child instanceof ExpressionParameter) {
                node.setOperand(childIndex, this.nextValue(((ExpressionParameter)child).getName()));
            } else if (child instanceof Object[]) {
                Object[] array = (Object[])child;
                for (int i = 0; i < array.length; ++i) {
                    if (!(array[i] instanceof ExpressionParameter)) continue;
                    array[i] = this.nextValue(((ExpressionParameter)array[i]).getName());
                }
            }
        }

        private Object nextValue(String name) {
            Object p;
            if (this.seen == null) {
                this.seen = new HashMap<String, Object>();
            }
            if (this.seen.containsKey(name)) {
                p = this.seen.get(name);
            } else {
                if (this.i >= this.parameters.length) {
                    throw new ExpressionException("Too few parameters to bind expression: " + this.parameters.length, new Object[0]);
                }
                p = this.parameters[this.i++];
                this.seen.put(name, p);
            }
            return p != null ? ExpressionFactory.wrapPathOperand(p) : new ASTScalar(null);
        }
    }

    final class NamedParamTransformer
    implements Transformer {
        private Map<String, ?> parameters;
        private boolean pruneMissing;

        NamedParamTransformer(Map<String, ?> parameters, boolean pruneMissing) {
            this.parameters = parameters;
            this.pruneMissing = pruneMissing;
        }

        public Object transform(Object object) {
            if (!(object instanceof ExpressionParameter)) {
                if (object instanceof Object[]) {
                    Object[] source = (Object[])object;
                    int len = source.length;
                    Object[] target = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        target[i] = this.transform(source[i]);
                    }
                    return target;
                }
                return object;
            }
            String name = ((ExpressionParameter)object).getName();
            if (!this.parameters.containsKey(name)) {
                if (this.pruneMissing) {
                    return PRUNED_NODE;
                }
                throw new ExpressionException("Missing required parameter: $" + name, new Object[0]);
            }
            Object value = this.parameters.get(name);
            return value != null ? ExpressionFactory.wrapPathOperand(value) : new ASTScalar(null);
        }
    }
}

