/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.XMLEncoder;

public class SelectQueryDescriptor
extends QueryDescriptor {
    private static final long serialVersionUID = -8798258795351950215L;
    protected Expression qualifier;
    protected List<Ordering> orderings = new ArrayList<Ordering>();
    protected List<String> prefetches = new ArrayList<String>();

    public SelectQueryDescriptor() {
        super("SelectQuery");
    }

    public void setDistinct(boolean value) {
        this.setProperty("cayenne.SelectQuery.distinct", String.valueOf(value));
    }

    public boolean isDistinct() {
        String distinct = this.getProperty("cayenne.SelectQuery.distinct");
        return distinct != null ? Boolean.valueOf(distinct) : false;
    }

    public Expression getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public List<Ordering> getOrderings() {
        return this.orderings;
    }

    public void setOrderings(List<Ordering> orderings) {
        this.orderings = orderings;
    }

    public void addOrdering(Ordering ordering) {
        this.orderings.add(ordering);
    }

    public void removeOrdering(Ordering ordering) {
        this.orderings.remove(ordering);
    }

    public List<String> getPrefetches() {
        return this.prefetches;
    }

    public void setPrefetches(List<String> prefetches) {
        this.prefetches = prefetches;
    }

    public void addPrefetch(String prefetchPath) {
        this.prefetches.add(prefetchPath);
    }

    public void removePrefetch(String prefetchPath) {
        this.prefetches.remove(prefetchPath);
    }

    @Override
    public SelectQuery<?> buildQuery() {
        List<String> prefetches;
        SelectQuery selectQuery = new SelectQuery();
        selectQuery.setRoot(this.getRoot());
        selectQuery.setName(this.getName());
        selectQuery.setDataMap(this.dataMap);
        selectQuery.setQualifier(this.getQualifier());
        List<Ordering> orderings = this.getOrderings();
        if (orderings != null && !orderings.isEmpty()) {
            selectQuery.addOrderings(orderings);
        }
        if ((prefetches = this.getPrefetches()) != null && !prefetches.isEmpty()) {
            for (String prefetch : prefetches) {
                selectQuery.addPrefetch(prefetch);
            }
        }
        selectQuery.initWithProperties(this.getProperties());
        return selectQuery;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" type=\"");
        encoder.print(this.type);
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        }
        if (rootType != null) {
            encoder.print("\" root=\"");
            encoder.print(rootType);
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        encoder.println("\">");
        encoder.indent(1);
        this.encodeProperties(encoder);
        if (this.qualifier != null) {
            encoder.print("<qualifier>");
            this.qualifier.encodeAsXML(encoder);
            encoder.println("</qualifier>");
        }
        if (this.orderings != null && !this.orderings.isEmpty()) {
            for (Ordering ordering : this.orderings) {
                ordering.encodeAsXML(encoder);
            }
        }
        PrefetchTreeNode prefetchTree = new PrefetchTreeNode();
        for (String prefetchPath : this.prefetches) {
            PrefetchTreeNode node = prefetchTree.addPath(prefetchPath);
            node.setSemantics(0);
            node.setPhantom(false);
        }
        prefetchTree.encodeAsXML(encoder);
        encoder.indent(-1);
        encoder.println("</query>");
    }
}

