/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.query.AbstractMappedQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQuery;

public class MappedSelect<T>
extends AbstractMappedQuery
implements Select<T> {
    protected Class<T> resultClass;
    protected Integer fetchLimit;
    protected Integer fetchOffset;
    protected Integer statementFetchSize;
    protected Integer pageSize;
    protected boolean forceNoCache;

    public static <T> MappedSelect<T> query(String queryName, Class<T> rootClass) {
        return new MappedSelect<T>(queryName, rootClass);
    }

    public static MappedSelect<?> query(String queryName) {
        return new MappedSelect(queryName);
    }

    protected MappedSelect(String queryName) {
        super(queryName);
    }

    protected MappedSelect(String queryName, Class<T> resultClass) {
        super(queryName);
        this.resultClass = resultClass;
    }

    public MappedSelect<T> limit(int fetchLimit) {
        this.fetchLimit = fetchLimit;
        this.replacementQuery = null;
        return this;
    }

    public MappedSelect<T> offset(int fetchOffset) {
        this.fetchOffset = fetchOffset;
        this.replacementQuery = null;
        return this;
    }

    public MappedSelect<T> statementFetchSize(int statementFetchSize) {
        this.statementFetchSize = statementFetchSize;
        this.replacementQuery = null;
        return this;
    }

    public MappedSelect<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        this.replacementQuery = null;
        return this;
    }

    public MappedSelect<T> forceNoCache() {
        this.forceNoCache = true;
        this.replacementQuery = null;
        return this;
    }

    @Override
    public MappedSelect<T> params(Map<String, ?> parameters) {
        return (MappedSelect)super.params(parameters);
    }

    @Override
    public MappedSelect<T> param(String name, Object value) {
        return (MappedSelect)super.param(name, value);
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        QueryDescriptor descriptor = resolver.getQueryDescriptor(this.queryName);
        Query query = super.createReplacementQuery(resolver);
        QueryCacheStrategy cacheStrategyOverride = null;
        if (this.forceNoCache) {
            QueryCacheStrategy cacheStrategy = query.getMetaData(resolver).getCacheStrategy();
            if (QueryCacheStrategy.LOCAL_CACHE == cacheStrategy) {
                cacheStrategyOverride = QueryCacheStrategy.LOCAL_CACHE_REFRESH;
            } else if (QueryCacheStrategy.SHARED_CACHE == cacheStrategy) {
                cacheStrategyOverride = QueryCacheStrategy.SHARED_CACHE_REFRESH;
            }
        }
        switch (descriptor.getType()) {
            case "SelectQuery": {
                SelectQuery selectQuery = (SelectQuery)query;
                if (this.fetchLimit != null) {
                    selectQuery.setFetchLimit(this.fetchLimit);
                }
                if (this.fetchOffset != null) {
                    selectQuery.setFetchOffset(this.fetchOffset);
                }
                if (this.statementFetchSize != null) {
                    selectQuery.setStatementFetchSize(this.statementFetchSize);
                }
                if (this.pageSize != null) {
                    selectQuery.setPageSize(this.pageSize);
                }
                if (cacheStrategyOverride == null) break;
                selectQuery.setCacheStrategy(cacheStrategyOverride);
                break;
            }
            case "SQLTemplate": {
                SQLTemplate sqlTemplate = (SQLTemplate)query;
                if (this.fetchLimit != null) {
                    sqlTemplate.setFetchLimit(this.fetchLimit);
                }
                if (this.fetchOffset != null) {
                    sqlTemplate.setFetchOffset(this.fetchOffset);
                }
                if (this.statementFetchSize != null) {
                    sqlTemplate.setStatementFetchSize(this.statementFetchSize);
                }
                if (this.pageSize != null) {
                    sqlTemplate.setPageSize(this.pageSize);
                }
                if (cacheStrategyOverride == null) break;
                sqlTemplate.setCacheStrategy(cacheStrategyOverride);
                break;
            }
            case "EJBQLQuery": {
                EJBQLQuery ejbqlQuery = (EJBQLQuery)query;
                if (this.fetchLimit != null) {
                    ejbqlQuery.setFetchLimit(this.fetchLimit);
                }
                if (this.fetchOffset != null) {
                    ejbqlQuery.setFetchOffset(this.fetchOffset);
                }
                if (this.statementFetchSize != null) {
                    ejbqlQuery.setStatementFetchSize(this.statementFetchSize);
                }
                if (this.pageSize != null) {
                    ejbqlQuery.setPageSize(this.pageSize);
                }
                if (cacheStrategyOverride == null) break;
                ejbqlQuery.setCacheStrategy(cacheStrategyOverride);
                break;
            }
            case "ProcedureQuery": {
                ProcedureQuery procedureQuery = (ProcedureQuery)query;
                if (this.fetchLimit != null) {
                    procedureQuery.setFetchLimit(this.fetchLimit);
                }
                if (this.fetchOffset != null) {
                    procedureQuery.setFetchOffset(this.fetchOffset);
                }
                if (this.statementFetchSize != null) {
                    procedureQuery.setStatementFetchSize(this.statementFetchSize);
                }
                if (this.pageSize != null) {
                    procedureQuery.setPageSize(this.pageSize);
                }
                if (cacheStrategyOverride == null) break;
                procedureQuery.setCacheStrategy(cacheStrategyOverride);
                break;
            }
            default: {
                throw new CayenneRuntimeException("Unknown query type: " + descriptor.getType(), new Object[0]);
            }
        }
        return query;
    }
}

