/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;

public class ObjectSelect<T>
extends FluentSelect<T, ObjectSelect<T>> {
    private static final long serialVersionUID = -156124021150949227L;
    protected boolean fetchingDataRows;

    public static <T> ObjectSelect<T> query(Class<T> entityType) {
        return (ObjectSelect)new ObjectSelect<T>().entityType(entityType);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression) {
        return (ObjectSelect)((ObjectSelect)new ObjectSelect<T>().entityType(entityType)).where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression, List<Ordering> orderings) {
        return (ObjectSelect)((ObjectSelect)((ObjectSelect)new ObjectSelect<T>().entityType(entityType)).where(expression)).orderBy(orderings);
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType) {
        return ObjectSelect.query(entityType).fetchDataRows();
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType, Expression expression) {
        return (ObjectSelect)ObjectSelect.query(entityType).fetchDataRows().where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> resultType, String entityName) {
        return (ObjectSelect)new ObjectSelect<T>().entityName(entityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName) {
        return (ObjectSelect)new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName, Expression expression) {
        return (ObjectSelect)((ObjectSelect)new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName)).where(expression);
    }

    protected static <E> ColumnSelect<E> columnQuery(Class<?> entityType, Property<E> column) {
        return ((ColumnSelect)new ColumnSelect().entityType(entityType)).column(column);
    }

    protected static ColumnSelect<Object[]> columnQuery(Class<?> entityType, Property<?> firstColumn, Property<?> ... otherColumns) {
        return ((ColumnSelect)new ColumnSelect().entityType(entityType)).columns(firstColumn, otherColumns);
    }

    protected ObjectSelect() {
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        SelectQuery replacement = (SelectQuery)super.createReplacementQuery(resolver);
        replacement.setFetchingDataRows(this.fetchingDataRows);
        return replacement;
    }

    public ObjectSelect<DataRow> fetchDataRows() {
        this.fetchingDataRows = true;
        return this;
    }

    public ColumnSelect<Object[]> columns(Property<?> firstProperty, Property<?> ... properties) {
        return new ColumnSelect(this).columns(firstProperty, properties);
    }

    public <E> ColumnSelect<E> column(Property<E> property) {
        return new ColumnSelect(this).column(property);
    }

    public ColumnSelect<Long> count() {
        return this.column(Property.COUNT);
    }

    public ColumnSelect<Long> count(Property<?> property) {
        return this.column(property.count());
    }

    public <E> ColumnSelect<E> min(Property<E> property) {
        return this.column(property.min());
    }

    public <E> ColumnSelect<E> max(Property<E> property) {
        return this.column(property.max());
    }

    public <E> ColumnSelect<E> avg(Property<E> property) {
        return this.column(property.avg());
    }

    public <E extends Number> ColumnSelect<E> sum(Property<E> property) {
        return this.column(property.sum());
    }

    public long selectCount(ObjectContext context) {
        return (Long)this.count().selectOne(context);
    }

    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }
}

