/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Field;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.util.Util;

public class FieldAccessor
implements Accessor {
    protected String propertyName;
    protected Field field;
    protected Object nullValue;

    public FieldAccessor(Class<?> objectClass, String propertyName, Class<?> propertyType) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        this.propertyName = propertyName;
        this.field = this.prepareField(objectClass, propertyName, propertyType);
        this.nullValue = PropertyUtils.defaultNullValueForType(this.field.getType());
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Object getValue(Object object) throws PropertyException {
        try {
            return this.field.get(object);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading field: " + this.field.getName(), (Accessor)this, object, th, new Object[0]);
        }
    }

    @Override
    public void setValue(Object object, Object newValue) throws PropertyException {
        if (newValue == null) {
            newValue = this.nullValue;
        }
        try {
            this.field.set(object, newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error writing field: " + this.field.getName(), (Accessor)this, object, th, new Object[0]);
        }
    }

    protected Field prepareField(Class<?> beanClass, String propertyName, Class<?> propertyType) {
        Field field;
        try {
            field = this.lookupFieldInHierarchy(beanClass, propertyName);
        }
        catch (SecurityException e) {
            throw new CayenneRuntimeException("Error accessing field '" + propertyName + "' in class: " + beanClass.getName(), (Throwable)e, new Object[0]);
        }
        catch (NoSuchFieldException e) {
            throw new CayenneRuntimeException("No field '" + propertyName + "' is defined in class: " + beanClass.getName(), (Throwable)e, new Object[0]);
        }
        if (!Util.isAccessible(field)) {
            field.setAccessible(true);
        }
        if (propertyType != null && !field.getType().isAssignableFrom(propertyType) && !PropertyUtils.normalizeType(field.getType()).isAssignableFrom(PropertyUtils.normalizeType(propertyType))) {
            throw new CayenneRuntimeException("Expected property type '" + propertyType.getName() + "', got '" + field.getType().getName() + "'. Property: '" + beanClass.getName() + "'.'" + propertyName + "'", new Object[0]);
        }
        return field;
    }

    protected Field lookupFieldInHierarchy(Class<?> beanClass, String fieldName) throws SecurityException, NoSuchFieldException {
        try {
            return beanClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = beanClass.getSuperclass();
            if (superClass == null || superClass.getName().equals(Object.class.getName())) {
                throw e;
            }
            return this.lookupFieldInHierarchy(superClass, fieldName);
        }
    }
}

