/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.ConnectionAwareResultIterator;
import org.apache.cayenne.access.jdbc.DistinctResultIterator;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.LimitResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;

public class SelectAction
extends BaseSQLAction {
    protected SelectQuery<?> query;
    protected QueryMetadata queryMetadata;

    private static void bind(DbAdapter adapter, PreparedStatement statement, DbAttributeBinding[] bindings) throws SQLException, Exception {
        for (DbAttributeBinding b : bindings) {
            if (b.isExcluded()) continue;
            if (b.getAttribute() == null) {
                statement.setObject(b.getStatementPosition(), b.getValue());
                continue;
            }
            adapter.bindParameter(statement, b);
        }
    }

    public SelectAction(SelectQuery<?> query, DataNode dataNode) {
        super(dataNode);
        this.query = query;
        this.queryMetadata = query.getMetaData(dataNode.getEntityResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        List<?> resultRows;
        ResultSet rs;
        long t1 = System.currentTimeMillis();
        JdbcEventLogger logger = this.dataNode.getJdbcEventLogger();
        SelectTranslator translator = this.dataNode.selectTranslator(this.query);
        String sql = translator.getSql();
        ParameterBinding[] bindings = translator.getBindings();
        logger.logQuery(sql, bindings);
        PreparedStatement statement = connection.prepareStatement(sql);
        SelectAction.bind(this.dataNode.getAdapter(), statement, (DbAttributeBinding[])bindings);
        int fetchSize = this.queryMetadata.getStatementFetchSize();
        if (fetchSize != 0) {
            statement.setFetchSize(fetchSize);
        }
        try {
            rs = statement.executeQuery();
        }
        catch (Exception ex) {
            statement.close();
            throw ex;
        }
        RowDescriptor descriptor = new RowDescriptorBuilder().setColumns(translator.getResultColumns()).getDescriptor(this.dataNode.getAdapter().getExtendedTypes());
        RowReader<?> rowReader = this.dataNode.rowReader(descriptor, this.queryMetadata, translator.getAttributeOverrides());
        ResultIterator<?> it = new JDBCResultIterator(statement, rs, rowReader);
        it = this.forIteratedResult(it, observer, connection, t1, sql);
        it = this.forSuppressedDistinct(it, translator);
        it = this.forFetchLimit(it, translator);
        if (observer.isIteratedResult()) {
            try {
                observer.nextRows(this.query, it);
            }
            catch (Exception ex) {
                it.close();
                throw ex;
            }
        }
        try {
            resultRows = it.allRows();
        }
        finally {
            it.close();
        }
        this.dataNode.getJdbcEventLogger().logSelectCount(resultRows.size(), System.currentTimeMillis() - t1, sql);
        observer.nextRows(this.query, resultRows);
    }

    private <T> ResultIterator<T> forIteratedResult(ResultIterator<T> iterator, OperationObserver observer, Connection connection, final long queryStartedAt, final String sql) {
        if (!observer.isIteratedResult()) {
            return iterator;
        }
        return new ConnectionAwareResultIterator<T>(iterator, connection){

            @Override
            protected void doClose() {
                SelectAction.this.dataNode.getJdbcEventLogger().logSelectCount(this.rowCounter, System.currentTimeMillis() - queryStartedAt, sql);
                super.doClose();
            }
        };
    }

    private <T> ResultIterator<T> forFetchLimit(ResultIterator<T> iterator, SelectTranslator translator) {
        int offset;
        int fetchLimit = this.query.getFetchLimit();
        int n = offset = translator.isSuppressingDistinct() ? this.query.getFetchOffset() : this.getInMemoryOffset(this.query.getFetchOffset());
        if (fetchLimit > 0 || offset > 0) {
            return new LimitResultIterator<T>(iterator, offset, fetchLimit);
        }
        return iterator;
    }

    private <T> ResultIterator<T> forSuppressedDistinct(ResultIterator<T> iterator, SelectTranslator translator) {
        if (!translator.isSuppressingDistinct() || this.queryMetadata.isSuppressingDistinct()) {
            return iterator;
        }
        final boolean[] compareFullRows = new boolean[]{translator.hasJoins()};
        final PrefetchTreeNode rootPrefetch = this.queryMetadata.getPrefetchTree();
        if (!compareFullRows[0] && rootPrefetch != null) {
            rootPrefetch.traverse(new PrefetchProcessor(){

                @Override
                public void finishPrefetch(PrefetchTreeNode node) {
                }

                @Override
                public boolean startDisjointPrefetch(PrefetchTreeNode node) {
                    return rootPrefetch == node;
                }

                @Override
                public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
                    return rootPrefetch == node;
                }

                @Override
                public boolean startUnknownPrefetch(PrefetchTreeNode node) {
                    return rootPrefetch == node;
                }

                @Override
                public boolean startJointPrefetch(PrefetchTreeNode node) {
                    if (rootPrefetch != node) {
                        compareFullRows[0] = true;
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean startPhantomPrefetch(PrefetchTreeNode node) {
                    return true;
                }
            });
        }
        return new DistinctResultIterator<T>(iterator, this.queryMetadata.getDbEntity(), compareFullRows[0]);
    }
}

