/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.Slf4jJdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;

public class CompactSlf4jJdbcEventLogger
extends Slf4jJdbcEventLogger {
    private static final String UNION = "UNION";
    private static final String SELECT = "SELECT";
    private static final String FROM = "FROM";
    private static final char SPACE = ' ';

    public CompactSlf4jJdbcEventLogger(@Inject RuntimeProperties runtimeProperties) {
        super(runtimeProperties);
    }

    @Override
    public void logQuery(String sql, ParameterBinding[] bindings) {
        if (!this.isLoggable()) {
            return;
        }
        String str = sql.toUpperCase().contains(UNION) ? this.processUnionSql(sql) : this.trimSqlSelectColumns(sql);
        super.logQuery(str, bindings);
    }

    protected String processUnionSql(String sql) {
        String modified = Pattern.compile(UNION.toLowerCase(), 2).matcher(sql).replaceAll(UNION);
        String[] queries = modified.split(UNION);
        return Arrays.stream(queries).map(this::trimSqlSelectColumns).collect(Collectors.joining(" UNION"));
    }

    protected String trimSqlSelectColumns(String sql) {
        int fromIndex;
        int selectIndex = sql.toUpperCase().indexOf(SELECT);
        if (selectIndex == -1) {
            return sql;
        }
        String columns = sql.substring(selectIndex += SELECT.length(), fromIndex = sql.toUpperCase().indexOf(FROM));
        String[] columnsArray = columns.split(",");
        if (columnsArray.length <= 3) {
            return sql;
        }
        columns = "(" + columnsArray.length + " columns)";
        return new StringBuilder(sql.substring(0, selectIndex)).append(' ').append(columns).append(' ').append(sql, fromIndex, sql.length()).toString();
    }

    @Override
    protected void appendParameters(StringBuilder buffer, String label, ParameterBinding[] bindings) {
        int bindingLength = bindings.length;
        if (bindingLength == 0) {
            return;
        }
        this.buildBinding(buffer, label, this.collectBindings(bindings));
    }

    private Map<String, List<String>> collectBindings(ParameterBinding[] bindings) {
        HashMap<String, List<String>> bindingsMap = new HashMap<String, List<String>>();
        String key = null;
        for (ParameterBinding b : bindings) {
            DbAttribute attribute;
            if (b.isExcluded()) continue;
            if (b instanceof DbAttributeBinding && (attribute = ((DbAttributeBinding)b).getAttribute()) != null) {
                key = attribute.getName();
            }
            String value = b.getExtendedType() != null ? b.getExtendedType().toString(b.getValue()) : (b.getValue() == null ? "NULL" : b.getValue().getClass().getName() + "@" + System.identityHashCode(b.getValue()));
            List objects = bindingsMap.computeIfAbsent(key, k -> new ArrayList());
            objects.add(value);
        }
        return bindingsMap;
    }

    private void buildBinding(StringBuilder buffer, String label, Map<String, List<String>> bindingsMap) {
        int j = 1;
        boolean hasIncluded = false;
        for (String k : bindingsMap.keySet()) {
            if (!hasIncluded) {
                hasIncluded = true;
                buffer.append("[").append(label).append(": ");
            } else {
                buffer.append(", ");
            }
            buffer.append(j).append("->").append(k).append(": ");
            List<String> bindingsList = bindingsMap.get(k);
            if (bindingsList.size() == 1) {
                buffer.append(bindingsList.get(0));
            } else {
                buffer.append("{");
                boolean wasAdded = false;
                for (String val : bindingsList) {
                    if (wasAdded) {
                        buffer.append(", ");
                    } else {
                        wasAdded = true;
                    }
                    buffer.append((Object)val);
                }
                buffer.append("}");
            }
            ++j;
        }
        if (hasIncluded) {
            buffer.append("]");
        }
    }

    @Override
    public void logBeginTransaction(String transactionLabel) {
    }

    @Override
    public void logCommitTransaction(String transactionLabel) {
    }
}

