/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class DataMap
implements Serializable,
ConfigurationNode,
XMLSerializable,
MappingNamespace,
DbEntityListener,
ObjEntityListener,
Comparable<DataMap> {
    private static final long serialVersionUID = 4851901426473991657L;
    public static final String CLIENT_SUPPORTED_PROPERTY = "clientSupported";
    public static final String DEFAULT_CLIENT_PACKAGE_PROPERTY = "defaultClientPackage";
    public static final String DEFAULT_CLIENT_SUPERCLASS_PROPERTY = "defaultClientSuperclass";
    public static final String DEFAULT_CATALOG_PROPERTY = "defaultCatalog";
    public static final String DEFAULT_SCHEMA_PROPERTY = "defaultSchema";
    public static final String DEFAULT_PACKAGE_PROPERTY = "defaultPackage";
    public static final String DEFAULT_SUPERCLASS_PROPERTY = "defaultSuperclass";
    public static final String DEFAULT_LOCK_TYPE_PROPERTY = "defaultLockType";
    public static final String DEFAULT_QUOTE_SQL_IDENTIFIERS_PROPERTY = "quoteSqlIdentifiers";
    public static final String SCHEMA_XSD = "http://cayenne.apache.org/schema/10/modelMap";
    public static final String SCHEMA_XSD_LOCATION = "https://cayenne.apache.org/schema/10/modelMap.xsd";
    protected String name;
    protected String location;
    protected MappingNamespace namespace;
    protected Boolean quotingSQLIdentifiers;
    protected String defaultCatalog;
    protected String defaultSchema;
    protected String defaultPackage;
    protected String defaultSuperclass;
    protected int defaultLockType;
    protected boolean clientSupported;
    protected String defaultClientPackage;
    protected String defaultClientSuperclass;
    private Map<String, Embeddable> embeddablesMap = new HashMap<String, Embeddable>();
    private Map<String, ObjEntity> objEntityMap = new HashMap<String, ObjEntity>();
    private Map<String, DbEntity> dbEntityMap = new HashMap<String, DbEntity>();
    private Map<String, Procedure> procedureMap = new HashMap<String, Procedure>();
    private Map<String, QueryDescriptor> queryDescriptorMap = new HashMap<String, QueryDescriptor>();
    private Map<String, SQLResult> results = new HashMap<String, SQLResult>();
    protected transient Resource configurationSource;
    protected DataChannelDescriptor dataChannelDescriptor;

    public DataMap() {
        this(null);
    }

    public DataMap(String mapName) {
        this(mapName, Collections.emptyMap());
    }

    public DataMap(String mapName, Map<String, Object> properties) {
        this.setName(mapName);
        this.initWithProperties(properties);
    }

    public DataChannelDescriptor getDataChannelDescriptor() {
        return this.dataChannelDescriptor;
    }

    public void setDataChannelDescriptor(DataChannelDescriptor dataChannelDescriptor) {
        this.dataChannelDescriptor = dataChannelDescriptor;
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitDataMap(this);
    }

    @Override
    public int compareTo(DataMap o) {
        String o1 = this.getName();
        String o2 = o.getName();
        if (o1 == null) {
            return o2 != null ? -1 : 0;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public boolean isQuotingSQLIdentifiers() {
        return this.quotingSQLIdentifiers;
    }

    public void setQuotingSQLIdentifiers(boolean quotingSqlIdentifiers) {
        this.quotingSQLIdentifiers = quotingSqlIdentifiers;
    }

    public void initWithProperties(Map<String, Object> properties) {
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        Object lockType = properties.get(DEFAULT_LOCK_TYPE_PROPERTY);
        Object packageName = properties.get(DEFAULT_PACKAGE_PROPERTY);
        Object catalog = properties.get(DEFAULT_CATALOG_PROPERTY);
        Object schema = properties.get(DEFAULT_SCHEMA_PROPERTY);
        Object superclass = properties.get(DEFAULT_SUPERCLASS_PROPERTY);
        Object clientEntities = properties.get(CLIENT_SUPPORTED_PROPERTY);
        Object clientPackageName = properties.get(DEFAULT_CLIENT_PACKAGE_PROPERTY);
        Object clientSuperclass = properties.get(DEFAULT_CLIENT_SUPERCLASS_PROPERTY);
        Object quoteSqlIdentifier = properties.get(DEFAULT_QUOTE_SQL_IDENTIFIERS_PROPERTY);
        this.defaultLockType = "optimistic".equals(lockType) ? 1 : 0;
        this.defaultPackage = packageName != null ? packageName.toString() : null;
        this.quotingSQLIdentifiers = quoteSqlIdentifier != null && "true".equalsIgnoreCase(quoteSqlIdentifier.toString());
        this.defaultSchema = schema != null ? schema.toString() : null;
        this.defaultCatalog = catalog != null ? catalog.toString() : null;
        this.defaultSuperclass = superclass != null ? superclass.toString() : null;
        this.clientSupported = clientEntities != null && "true".equalsIgnoreCase(clientEntities.toString());
        this.defaultClientPackage = clientPackageName != null ? clientPackageName.toString() : null;
        this.defaultClientSuperclass = clientSuperclass != null ? clientSuperclass.toString() : null;
    }

    public DataMap getClientDataMap(EntityResolver serverResolver) {
        if (!this.isClientSupported()) {
            return null;
        }
        DataMap clientMap = new DataMap(this.getName());
        for (ObjEntity entity : this.getObjEntities()) {
            if (!entity.isClientAllowed()) continue;
            clientMap.addObjEntity(entity.getClientEntity());
        }
        for (QueryDescriptor q : this.getQueryDescriptors()) {
            clientMap.addQueryDescriptor(q);
        }
        return clientMap;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("data-map").attribute("xmlns", SCHEMA_XSD).attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", true).attribute("xsi:schemaLocation", "http://cayenne.apache.org/schema/10/modelMap https://cayenne.apache.org/schema/10/modelMap.xsd", true).projectVersion().property(DEFAULT_LOCK_TYPE_PROPERTY, this.defaultLockType).property(DEFAULT_PACKAGE_PROPERTY, this.defaultPackage).property(DEFAULT_CATALOG_PROPERTY, this.defaultCatalog).property(DEFAULT_SCHEMA_PROPERTY, this.defaultSchema).property(DEFAULT_SUPERCLASS_PROPERTY, this.defaultSuperclass).property(DEFAULT_QUOTE_SQL_IDENTIFIERS_PROPERTY, this.quotingSQLIdentifiers).property(CLIENT_SUPPORTED_PROPERTY, this.clientSupported).property(DEFAULT_CLIENT_PACKAGE_PROPERTY, this.defaultClientPackage).property(DEFAULT_CLIENT_SUPERCLASS_PROPERTY, this.defaultClientSuperclass).nested(new TreeMap<String, Embeddable>(this.getEmbeddableMap()), delegate).nested(new TreeMap<String, Procedure>(this.getProcedureMap()), delegate).nested(new TreeMap<String, DbEntity>(this.getDbEntityMap()), delegate).nested(new TreeMap<String, ObjEntity>(this.getObjEntityMap()), delegate);
        this.encodeDbRelationshipsAsXML(encoder, delegate);
        this.encodeObjRelationshipsAsXML(encoder, delegate);
        encoder.nested(this.getQueryDescriptors(), delegate);
        delegate.visitDataMap(this);
        encoder.end();
    }

    private void encodeDbRelationshipsAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        for (Entity entity : new TreeMap<String, DbEntity>(this.getDbEntityMap()).values()) {
            entity.getRelationships().stream().filter(r -> !r.isRuntime()).forEach(r -> r.encodeAsXML(encoder, delegate));
        }
    }

    private void encodeObjRelationshipsAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        for (ObjEntity entity : new TreeMap<String, ObjEntity>(this.getObjEntityMap()).values()) {
            entity.getDeclaredRelationships().stream().filter(r -> !r.isRuntime()).forEach(r -> r.encodeAsXML(encoder, delegate));
        }
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.getName()).toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void mergeWithDataMap(DataMap map) {
        for (DbEntity dbEntity : new ArrayList<DbEntity>(map.getDbEntities())) {
            this.removeDbEntity(dbEntity.getName());
            this.addDbEntity(dbEntity);
        }
        for (ObjEntity objEntity : new ArrayList<ObjEntity>(map.getObjEntities())) {
            this.removeObjEntity(objEntity.getName());
            this.addObjEntity(objEntity);
        }
        for (QueryDescriptor queryDescriptor : new ArrayList<QueryDescriptor>(map.getQueryDescriptors())) {
            this.removeQueryDescriptor(queryDescriptor.getName());
            this.addQueryDescriptor(queryDescriptor);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Map<String, ObjEntity> getObjEntityMap() {
        return Collections.unmodifiableMap(this.objEntityMap);
    }

    public Map<String, DbEntity> getDbEntityMap() {
        return Collections.unmodifiableMap(this.dbEntityMap);
    }

    @Override
    public QueryDescriptor getQueryDescriptor(String queryName) {
        QueryDescriptor queryDescriptor = this.queryDescriptorMap.get(queryName);
        if (queryDescriptor != null) {
            return queryDescriptor;
        }
        return this.namespace != null ? this.namespace.getQueryDescriptor(queryName) : null;
    }

    public void addQueryDescriptor(QueryDescriptor queryDescriptor) {
        if (queryDescriptor == null) {
            throw new NullPointerException("Can't add null query.");
        }
        if (queryDescriptor.getName() == null) {
            throw new NullPointerException("Query name can't be null.");
        }
        QueryDescriptor existingQueryDescriptor = this.queryDescriptorMap.get(queryDescriptor.getName());
        if (existingQueryDescriptor != null) {
            if (existingQueryDescriptor == queryDescriptor) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override entity '" + queryDescriptor.getName());
        }
        this.queryDescriptorMap.put(queryDescriptor.getName(), queryDescriptor);
    }

    public void removeQueryDescriptor(String queryName) {
        this.queryDescriptorMap.remove(queryName);
    }

    public void clearEmbeddables() {
        this.embeddablesMap.clear();
    }

    public void clearResultSets() {
        this.results.clear();
    }

    public void clearQueries() {
        this.queryDescriptorMap.clear();
    }

    public void clearObjEntities() {
        this.objEntityMap.clear();
    }

    public void clearDbEntities() {
        this.dbEntityMap.clear();
    }

    public void clearProcedures() {
        this.procedureMap.clear();
    }

    public Map<String, QueryDescriptor> getQueryDescriptorMap() {
        return Collections.unmodifiableMap(this.queryDescriptorMap);
    }

    @Override
    public Collection<QueryDescriptor> getQueryDescriptors() {
        return Collections.unmodifiableCollection(this.queryDescriptorMap.values());
    }

    public void addEmbeddable(Embeddable embeddable) {
        if (embeddable == null) {
            throw new NullPointerException("Null embeddable");
        }
        if (embeddable.getClassName() == null) {
            throw new NullPointerException("Attempt to add Embeddable with no class name.");
        }
        Embeddable existing = this.embeddablesMap.get(embeddable.getClassName());
        if (existing != null) {
            if (existing == embeddable) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override embeddable '" + embeddable.getClassName());
        }
        this.embeddablesMap.put(embeddable.getClassName(), embeddable);
        embeddable.setDataMap(this);
    }

    public void addResult(SQLResult result) {
        if (result == null) {
            throw new NullPointerException("Null result");
        }
        if (result.getName() == null) {
            throw new NullPointerException("Attempt to add resultSetMapping with no name.");
        }
        SQLResult existing = this.results.get(result.getName());
        if (existing != null) {
            if (existing == result) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override resultSetMapping '" + result.getName());
        }
        this.results.put(result.getName(), result);
    }

    public void addObjEntity(ObjEntity entity) {
        if (entity.getName() == null) {
            throw new NullPointerException("Attempt to add ObjEntity with no name.");
        }
        ObjEntity existingEntity = this.objEntityMap.get(entity.getName());
        if (existingEntity != null) {
            if (existingEntity == entity) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override entity '" + entity.getName());
        }
        this.objEntityMap.put(entity.getName(), entity);
        entity.setDataMap(this);
    }

    public void addDbEntity(DbEntity entity) {
        if (entity.getName() == null) {
            throw new NullPointerException("Attempt to add DbEntity with no name.");
        }
        DbEntity existingEntity = this.dbEntityMap.get(entity.getName());
        if (existingEntity != null) {
            if (existingEntity == entity) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override db entity '" + entity.getName() + "' in DataMap '" + this.getName() + "'");
        }
        this.dbEntityMap.put(entity.getName(), entity);
        entity.setDataMap(this);
    }

    @Override
    public Collection<ObjEntity> getObjEntities() {
        return Collections.unmodifiableCollection(this.objEntityMap.values());
    }

    public Map<String, Embeddable> getEmbeddableMap() {
        return Collections.unmodifiableMap(this.embeddablesMap);
    }

    @Override
    public Collection<Embeddable> getEmbeddables() {
        return Collections.unmodifiableCollection(this.embeddablesMap.values());
    }

    public Map<String, SQLResult> getResultsMap() {
        return Collections.unmodifiableMap(this.results);
    }

    @Override
    public Collection<SQLResult> getResults() {
        return Collections.unmodifiableCollection(this.results.values());
    }

    @Override
    public Embeddable getEmbeddable(String className) {
        Embeddable e = this.embeddablesMap.get(className);
        if (e != null) {
            return e;
        }
        return this.namespace != null ? this.namespace.getEmbeddable(className) : null;
    }

    @Override
    public SQLResult getResult(String name) {
        SQLResult rsMapping = this.results.get(name);
        if (rsMapping != null) {
            return rsMapping;
        }
        return this.namespace != null ? this.namespace.getResult(name) : null;
    }

    @Override
    public Collection<DbEntity> getDbEntities() {
        return Collections.unmodifiableCollection(this.dbEntityMap.values());
    }

    @Override
    public DbEntity getDbEntity(String dbEntityName) {
        DbEntity entity = this.dbEntityMap.get(dbEntityName);
        if (entity != null) {
            return entity;
        }
        return this.namespace != null ? this.namespace.getDbEntity(dbEntityName) : null;
    }

    public ObjEntity getObjEntityForJavaClass(String javaClassName) {
        if (javaClassName == null) {
            return null;
        }
        for (ObjEntity entity : this.getObjEntities()) {
            if (!javaClassName.equals(entity.getClassName())) continue;
            return entity;
        }
        return null;
    }

    @Override
    public ObjEntity getObjEntity(String objEntityName) {
        ObjEntity entity = this.objEntityMap.get(objEntityName);
        if (entity != null) {
            return entity;
        }
        return this.namespace != null ? this.namespace.getObjEntity(objEntityName) : null;
    }

    public Collection<ObjEntity> getMappedEntities(DbEntity dbEntity) {
        Collection<ObjEntity> allEntities;
        if (dbEntity == null) {
            return Collections.emptyList();
        }
        Collection<ObjEntity> collection = allEntities = this.namespace != null ? this.namespace.getObjEntities() : this.getObjEntities();
        if (allEntities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ObjEntity> result = new ArrayList<ObjEntity>();
        for (ObjEntity entity : allEntities) {
            if (entity.getDbEntity() != dbEntity) continue;
            result.add(entity);
        }
        return result;
    }

    public void removeEmbeddable(String className) {
        this.embeddablesMap.remove(className);
    }

    public void removeResult(String name) {
        this.results.remove(name);
    }

    public void removeDbEntity(String dbEntityName) {
        this.removeDbEntity(dbEntityName, false);
    }

    public void removeDbEntity(String dbEntityName, boolean clearDependencies) {
        DbEntity dbEntityToDelete = this.dbEntityMap.remove(dbEntityName);
        if (dbEntityToDelete != null && clearDependencies) {
            for (DbEntity dbEnt : this.getDbEntities()) {
                for (Relationship relationship : new ArrayList<DbRelationship>(dbEnt.getRelationships())) {
                    if (!dbEntityName.equals(relationship.getTargetEntityName())) continue;
                    dbEnt.removeRelationship(relationship.getName());
                }
            }
            for (ObjEntity objEnt : this.getObjEntities()) {
                if (dbEntityToDelete.getName().equals(objEnt.getDbEntityName())) {
                    objEnt.clearDbMapping();
                    continue;
                }
                block3: for (ObjRelationship objRelationship : objEnt.getRelationships()) {
                    for (DbRelationship dbRel : objRelationship.getDbRelationships()) {
                        if (dbRel.getTargetEntity() != dbEntityToDelete) continue;
                        objRelationship.clearDbRelationships();
                        continue block3;
                    }
                }
            }
            MappingNamespace ns = this.getNamespace();
            if (ns instanceof EntityResolver) {
                ((EntityResolver)ns).refreshMappingCache();
            }
        }
    }

    public void removeObjEntity(String objEntityName) {
        this.removeObjEntity(objEntityName, false);
    }

    public void removeObjEntity(String objEntityName, boolean clearDependencies) {
        ObjEntity entity = this.objEntityMap.remove(objEntityName);
        if (entity != null && clearDependencies) {
            for (ObjEntity ent : this.getObjEntities()) {
                for (Relationship relationship : new ArrayList<ObjRelationship>(ent.getRelationships())) {
                    if (!objEntityName.equals(relationship.getSourceEntity().getName()) && !objEntityName.equals(relationship.getTargetEntityName())) continue;
                    ent.removeRelationship(relationship.getName());
                }
            }
            MappingNamespace ns = this.getNamespace();
            if (ns instanceof EntityResolver) {
                ((EntityResolver)ns).refreshMappingCache();
            }
        }
    }

    @Override
    public Collection<Procedure> getProcedures() {
        return Collections.unmodifiableCollection(this.procedureMap.values());
    }

    @Override
    public Procedure getProcedure(String procedureName) {
        Procedure procedure = this.procedureMap.get(procedureName);
        if (procedure != null) {
            return procedure;
        }
        return this.namespace != null ? this.namespace.getProcedure(procedureName) : null;
    }

    public void addProcedure(Procedure procedure) {
        if (procedure.getName() == null) {
            throw new NullPointerException("Attempt to add procedure with no name.");
        }
        Procedure existingProcedure = this.procedureMap.get(procedure.getName());
        if (existingProcedure != null) {
            if (existingProcedure == procedure) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override procedure '" + procedure.getName());
        }
        this.procedureMap.put(procedure.getName(), procedure);
        procedure.setDataMap(this);
    }

    public void removeProcedure(String name) {
        this.procedureMap.remove(name);
    }

    public Map<String, Procedure> getProcedureMap() {
        return Collections.unmodifiableMap(this.procedureMap);
    }

    public MappingNamespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(MappingNamespace namespace) {
        this.namespace = namespace;
    }

    public int getDefaultLockType() {
        return this.defaultLockType;
    }

    public void setDefaultLockType(int defaultLockType) {
        this.defaultLockType = defaultLockType;
    }

    public boolean isClientSupported() {
        return this.clientSupported;
    }

    public void setClientSupported(boolean clientSupport) {
        this.clientSupported = clientSupport;
    }

    public String getDefaultClientPackage() {
        return this.defaultClientPackage;
    }

    public void setDefaultClientPackage(String defaultClientPackage) {
        this.defaultClientPackage = defaultClientPackage;
    }

    public String getDefaultClientSuperclass() {
        return this.defaultClientSuperclass;
    }

    public void setDefaultClientSuperclass(String defaultClientSuperclass) {
        this.defaultClientSuperclass = defaultClientSuperclass;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getDefaultSuperclass() {
        return this.defaultSuperclass;
    }

    public void setDefaultSuperclass(String defaultSuperclass) {
        this.defaultSuperclass = defaultSuperclass;
    }

    @Override
    public void dbEntityChanged(EntityEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof DbEntity) {
            DbEntity dbEntity = (DbEntity)entity;
            dbEntity.dbEntityChanged(e);
            if (e.isNameChange()) {
                this.dbEntityMap.remove(e.getOldName());
                this.dbEntityMap.put(e.getNewName(), dbEntity);
                MappingNamespace ns = this.getNamespace();
                if (ns instanceof EntityResolver) {
                    ((EntityResolver)ns).refreshMappingCache();
                }
            }
        }
    }

    @Override
    public void dbEntityAdded(EntityEvent e) {
    }

    @Override
    public void dbEntityRemoved(EntityEvent e) {
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof ObjEntity) {
            ObjEntity objEntity = (ObjEntity)entity;
            objEntity.objEntityChanged(e);
            if (e.isNameChange()) {
                this.objEntityMap.remove(e.getOldName());
                this.objEntityMap.put(e.getNewName(), objEntity);
                MappingNamespace ns = this.getNamespace();
                if (ns instanceof EntityResolver) {
                    ((EntityResolver)ns).refreshMappingCache();
                }
            }
        }
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
    }

    public Resource getConfigurationSource() {
        return this.configurationSource;
    }

    public void setConfigurationSource(Resource configurationSource) {
        this.configurationSource = configurationSource;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    @Override
    public EntityInheritanceTree getInheritanceTree(String entityName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjEntity getObjEntity(Class<?> entityClass) {
        if (entityClass == null) {
            return null;
        }
        String className = entityClass.getName();
        for (ObjEntity e : this.objEntityMap.values()) {
            if (!className.equals(e.getClassName())) continue;
            return e;
        }
        return null;
    }

    @Override
    public ObjEntity getObjEntity(Persistent object) {
        ObjectId id = object.getObjectId();
        if (id != null) {
            return this.getObjEntity(id.getEntityName());
        }
        return this.getObjEntity(object.getClass());
    }

    public void clear() {
        this.clearDbEntities();
        this.clearEmbeddables();
        this.clearObjEntities();
        this.clearProcedures();
        this.clearQueries();
        this.clearResultSets();
    }

    public String getNameWithDefaultPackage(String name) {
        return DataMap.getNameWithPackage(this.defaultPackage, name);
    }

    public static String getNameWithPackage(String pack, String name) {
        if (Util.isEmptyString(pack)) {
            return name;
        }
        return pack + (pack.endsWith(".") ? "" : ".") + name;
    }

    public String getNameWithDefaultClientPackage(String name) {
        return DataMap.getNameWithPackage(this.defaultClientPackage, name);
    }

    public Map<String, ObjEntity> getSubclassesForObjEntity(ObjEntity superEntity) {
        HashMap<String, ObjEntity> subObjectEntities = new HashMap<String, ObjEntity>(5);
        for (ObjEntity objectEntity : this.objEntityMap.values()) {
            if (!superEntity.getName().equals(objectEntity.getSuperEntityName())) continue;
            subObjectEntities.put(objectEntity.getName(), objectEntity);
        }
        return subObjectEntities;
    }
}

