/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLExpressionVisitor;
import org.apache.cayenne.ejbql.parser.CompiledExpression;
import org.apache.cayenne.ejbql.parser.EJBQLFromItem;
import org.apache.cayenne.ejbql.parser.EJBQLIdentifier;
import org.apache.cayenne.ejbql.parser.EJBQLJoin;
import org.apache.cayenne.ejbql.parser.EJBQLPath;
import org.apache.cayenne.ejbql.parser.EJBQLSelectClause;
import org.apache.cayenne.ejbql.parser.EJBQLSelectExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class Compiler {
    private boolean appendingResultColumns;
    private String rootId;
    private EntityResolver resolver;
    private Map<String, ClassDescriptor> descriptorsById;
    private Map<String, ObjRelationship> incomingById;
    private Collection<EJBQLPath> paths;
    private EJBQLExpressionVisitor fromItemVisitor;
    private EJBQLExpressionVisitor joinVisitor;
    private EJBQLExpressionVisitor pathVisitor;
    private EJBQLExpressionVisitor rootDescriptorVisitor;
    private List<Object> resultComponents;
    private PrefetchTreeNode prefetchTree = null;

    Compiler(EntityResolver resolver) {
        this.resolver = resolver;
        this.descriptorsById = new HashMap<String, ClassDescriptor>();
        this.incomingById = new HashMap<String, ObjRelationship>();
        this.rootDescriptorVisitor = new SelectExpressionVisitor();
        this.fromItemVisitor = new FromItemVisitor();
        this.joinVisitor = new JoinVisitor();
        this.pathVisitor = new PathVisitor();
    }

    CompiledExpression compile(String source, EJBQLExpression parsed) {
        parsed.visit(new CompilationVisitor());
        HashMap<EJBQLPath, Integer> pathsInSelect = new HashMap<EJBQLPath, Integer>();
        for (int i = 0; i < parsed.getChildrenCount(); ++i) {
            if (!(parsed.getChild(i) instanceof EJBQLSelectClause)) continue;
            EJBQLExpression parsedTemp = parsed.getChild(i);
            boolean stop = false;
            while (parsedTemp.getChildrenCount() > 0 && !stop) {
                EJBQLExpression newParsedTemp = null;
                for (int j = 0; j < parsedTemp.getChildrenCount(); ++j) {
                    if (parsedTemp.getChild(j) instanceof EJBQLSelectExpression) {
                        for (int k = 0; k < parsedTemp.getChild(j).getChildrenCount(); ++k) {
                            if (!(parsedTemp.getChild(j).getChild(k) instanceof EJBQLPath)) continue;
                            pathsInSelect.put((EJBQLPath)parsedTemp.getChild(j).getChild(k), j);
                        }
                        continue;
                    }
                    if (parsedTemp.getChild(j).getChildrenCount() == 0) {
                        stop = true;
                        continue;
                    }
                    newParsedTemp = parsedTemp.getChild(j);
                }
                if (!stop && newParsedTemp != null) {
                    parsedTemp = newParsedTemp;
                    continue;
                }
                stop = true;
            }
        }
        if (this.paths != null) {
            for (EJBQLPath path : this.paths) {
                String id = Compiler.normalizeIdPath(path.getId());
                ClassDescriptor descriptor = this.descriptorsById.get(id);
                if (descriptor == null) {
                    throw new EJBQLException("Unmapped id variable: " + id, new Object[0]);
                }
                StringBuilder buffer = new StringBuilder(id);
                ObjRelationship incoming = null;
                String pathRelationshipString = "";
                for (int i = 1; i < path.getChildrenCount(); ++i) {
                    String pathChunk = path.getChild(i).getText();
                    if (pathChunk.endsWith("+")) {
                        pathChunk = pathChunk.substring(0, pathChunk.length() - 1);
                    }
                    buffer.append('.').append(pathChunk);
                    PropertyDescriptor property = descriptor.getProperty(pathChunk);
                    if (!(property instanceof ArcProperty)) continue;
                    incoming = ((ArcProperty)property).getRelationship();
                    descriptor = ((ArcProperty)property).getTargetDescriptor();
                    pathRelationshipString = buffer.substring(0, buffer.length());
                    this.descriptorsById.put(pathRelationshipString, descriptor);
                    this.incomingById.put(pathRelationshipString, incoming);
                }
                if (pathsInSelect.size() <= 0 || incoming == null || pathRelationshipString.length() <= 0 || !pathRelationshipString.equals(buffer.toString())) continue;
                EJBQLIdentifier ident = new EJBQLIdentifier(0);
                ident.text = pathRelationshipString;
                Integer integer = (Integer)pathsInSelect.get(path);
                if (integer == null) continue;
                this.resultComponents.remove(integer);
                this.resultComponents.add(integer, ident);
                this.rootId = pathRelationshipString;
            }
        }
        CompiledExpression compiled = new CompiledExpression();
        compiled.setExpression(parsed);
        compiled.setSource(source);
        compiled.setRootId(this.rootId);
        compiled.setDescriptorsById(this.descriptorsById);
        compiled.setIncomingById(this.incomingById);
        compiled.setPrefetchTree(this.prefetchTree);
        if (this.resultComponents != null) {
            SQLResult mapping = new SQLResult();
            for (int i = 0; i < this.resultComponents.size(); ++i) {
                Object nextMapping = this.resultComponents.get(i);
                if (nextMapping instanceof String) {
                    mapping.addColumnResult((String)nextMapping);
                    continue;
                }
                if (!(nextMapping instanceof EJBQLExpression)) continue;
                EntityResult compileEntityResult = this.compileEntityResult((EJBQLExpression)nextMapping, i);
                if (this.prefetchTree != null) {
                    for (PrefetchTreeNode prefetch : this.prefetchTree.getChildren()) {
                        if (!((EJBQLExpression)nextMapping).getText().equals(prefetch.getEjbqlPathEntityId())) continue;
                        EJBQLIdentifier ident = new EJBQLIdentifier(0);
                        ident.text = prefetch.getEjbqlPathEntityId() + "." + prefetch.getPath();
                        compileEntityResult = this.compileEntityResultWithPrefetch(compileEntityResult, ident);
                    }
                }
                mapping.addEntityResult(compileEntityResult);
            }
            compiled.setResult(mapping);
        }
        return compiled;
    }

    private EntityResult compileEntityResultWithPrefetch(final EntityResult compiledResult, EJBQLExpression prefetchExpression) {
        String id = prefetchExpression.getText().toLowerCase();
        ClassDescriptor descriptor = this.descriptorsById.get(id);
        if (descriptor == null) {
            descriptor = this.descriptorsById.get(prefetchExpression.getText());
        }
        final String prefix = prefetchExpression.getText().substring(prefetchExpression.getText().indexOf(".") + 1);
        final HashSet<String> visited = new HashSet<String>();
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                if (visited.add(oa.getDbAttributePath())) {
                    compiledResult.addObjectField(oa.getEntity().getName(), "fetch." + prefix + "." + oa.getName(), prefix + "." + oa.getDbAttributeName());
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                for (DbJoin join : dbRel.getJoins()) {
                    DbAttribute src = join.getSource();
                    if (!src.isForeignKey() || !visited.add(src.getName())) continue;
                    compiledResult.addDbField("fetch." + prefix + "." + src.getName(), prefix + "." + src.getName());
                }
                return true;
            }
        };
        descriptor.visitAllProperties(visitor);
        for (String pkName : descriptor.getEntity().getPrimaryKeyNames()) {
            if (!visited.add(pkName)) continue;
            compiledResult.addDbField("fetch." + prefix + "." + pkName, prefix + "." + pkName);
        }
        for (ObjAttribute column : descriptor.getDiscriminatorColumns()) {
            if (!visited.add(column.getName())) continue;
            compiledResult.addDbField("fetch." + prefix + "." + column.getDbAttributePath(), prefix + "." + column.getDbAttributePath());
        }
        return compiledResult;
    }

    private EntityResult compileEntityResult(EJBQLExpression expression, int position) {
        String id = expression.getText().toLowerCase();
        ClassDescriptor descriptor = this.descriptorsById.get(id);
        if (descriptor == null) {
            descriptor = this.descriptorsById.get(expression.getText());
        }
        if (descriptor == null) {
            throw new EJBQLException("the entity variable '" + id + "' does not refer to any entity in the FROM clause", new Object[0]);
        }
        final EntityResult entityResult = new EntityResult(descriptor.getObjectClass());
        final String prefix = "ec" + position + "_";
        final int[] index = new int[]{0};
        final HashSet<String> visited = new HashSet<String>();
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                if (visited.add(oa.getDbAttributePath())) {
                    int n = index[0];
                    index[0] = n + 1;
                    entityResult.addObjectField(oa.getEntity().getName(), oa.getName(), prefix + n);
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                for (DbJoin join : dbRel.getJoins()) {
                    DbAttribute src = join.getSource();
                    if (!src.isForeignKey() || !visited.add(src.getName())) continue;
                    int n = index[0];
                    index[0] = n + 1;
                    entityResult.addDbField(src.getName(), prefix + n);
                }
                return true;
            }
        };
        descriptor.visitAllProperties(visitor);
        for (String pkName : descriptor.getEntity().getPrimaryKeyNames()) {
            if (!visited.add(pkName)) continue;
            int n = index[0];
            index[0] = n + 1;
            entityResult.addDbField(pkName, prefix + n);
        }
        for (ObjAttribute column : descriptor.getDiscriminatorColumns()) {
            if (!visited.add(column.getName())) continue;
            int n = index[0];
            index[0] = n + 1;
            entityResult.addDbField(column.getDbAttributePath(), prefix + n);
        }
        return entityResult;
    }

    private void addPath(EJBQLPath path) {
        if (this.paths == null) {
            this.paths = new ArrayList<EJBQLPath>();
        }
        this.paths.add(path);
    }

    static String normalizeIdPath(String idPath) {
        int pathSeparator = idPath.indexOf(46);
        return pathSeparator < 0 ? idPath.toLowerCase() : idPath.substring(0, pathSeparator).toLowerCase() + idPath.substring(pathSeparator);
    }

    class SelectExpressionVisitor
    extends EJBQLBaseVisitor {
        SelectExpressionVisitor() {
        }

        @Override
        public boolean visitIdentifier(EJBQLExpression expression) {
            if (Compiler.this.appendingResultColumns) {
                Compiler.this.rootId = Compiler.normalizeIdPath(expression.getText());
                this.addEntityResult(expression);
            }
            return false;
        }

        @Override
        public boolean visitAggregate(EJBQLExpression expression) {
            this.addResultSetColumn();
            expression.getChild(0).getChild(0).visit(Compiler.this.pathVisitor);
            return false;
        }

        @Override
        public boolean visitDbPath(EJBQLExpression expression, int finishedChildIndex) {
            Compiler.this.addPath((EJBQLPath)expression);
            this.addResultSetColumn();
            return false;
        }

        @Override
        public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
            Compiler.this.addPath((EJBQLPath)expression);
            this.addResultSetColumn();
            return false;
        }

        private void addEntityResult(EJBQLExpression expression) {
            if (Compiler.this.appendingResultColumns) {
                if (Compiler.this.resultComponents == null) {
                    Compiler.this.resultComponents = new ArrayList();
                }
                Compiler.this.resultComponents.add(expression);
            }
        }

        private void addResultSetColumn() {
            if (Compiler.this.appendingResultColumns) {
                if (Compiler.this.resultComponents == null) {
                    Compiler.this.resultComponents = new ArrayList();
                }
                String column = "sc" + Compiler.this.resultComponents.size();
                Compiler.this.resultComponents.add(column);
            }
        }
    }

    class PathVisitor
    extends EJBQLBaseVisitor {
        PathVisitor() {
        }

        @Override
        public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
            Compiler.this.addPath((EJBQLPath)expression);
            return false;
        }
    }

    class JoinVisitor
    extends EJBQLBaseVisitor {
        private String id;
        private ObjRelationship incoming;
        private ClassDescriptor descriptor;

        JoinVisitor() {
        }

        @Override
        public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
            if (finishedChildIndex + 1 < expression.getChildrenCount()) {
                this.id = Compiler.normalizeIdPath(((EJBQLPath)expression).getId());
                this.descriptor = (ClassDescriptor)Compiler.this.descriptorsById.get(this.id);
                if (this.descriptor == null) {
                    throw new EJBQLException("Unmapped id variable: " + this.id, new Object[0]);
                }
            }
            return true;
        }

        @Override
        public boolean visitIdentificationVariable(EJBQLExpression expression) {
            PropertyDescriptor property = this.descriptor.getProperty(expression.getText());
            if (!(property instanceof ArcProperty)) {
                throw new EJBQLException("Incorrect relationship path: " + expression.getText(), new Object[0]);
            }
            this.incoming = ((ArcProperty)property).getRelationship();
            this.descriptor = ((ArcProperty)property).getTargetDescriptor();
            return true;
        }

        @Override
        public boolean visitIdentifier(EJBQLExpression expression) {
            if (this.incoming != null) {
                String aliasId = expression.getText().toLowerCase();
                ClassDescriptor old = Compiler.this.descriptorsById.put(aliasId, this.descriptor);
                if (old != null && old != this.descriptor) {
                    throw new EJBQLException("Duplicate identification variable definition: " + aliasId + ", it is already used for " + old.getEntity().getName(), new Object[0]);
                }
                Compiler.this.incomingById.put(aliasId, this.incoming);
                this.id = null;
                this.descriptor = null;
                this.incoming = null;
            }
            return true;
        }
    }

    class FromItemVisitor
    extends EJBQLBaseVisitor {
        private String entityName;

        FromItemVisitor() {
        }

        @Override
        public boolean visitFromItem(EJBQLFromItem expression, int finishedChildIndex) {
            if (finishedChildIndex + 1 == expression.getChildrenCount()) {
                ClassDescriptor descriptor = Compiler.this.resolver.getClassDescriptor(this.entityName);
                if (descriptor == null) {
                    throw new EJBQLException("Unmapped abstract schema name: " + this.entityName, new Object[0]);
                }
                String id = Compiler.normalizeIdPath(expression.getId());
                ClassDescriptor old = Compiler.this.descriptorsById.put(id, descriptor);
                if (old != null && old != descriptor) {
                    throw new EJBQLException("Duplicate identification variable definition: " + id + ", it is already used for " + old.getEntity().getName(), new Object[0]);
                }
                if (Compiler.this.rootId == null) {
                    Compiler.this.rootId = id;
                }
                this.entityName = null;
            }
            return true;
        }

        @Override
        public boolean visitIdentificationVariable(EJBQLExpression expression) {
            this.entityName = expression.getText();
            return true;
        }
    }

    class CompilationVisitor
    extends EJBQLBaseVisitor {
        CompilationVisitor() {
        }

        @Override
        public boolean visitSelect(EJBQLExpression expression) {
            Compiler.this.appendingResultColumns = true;
            return true;
        }

        @Override
        public boolean visitFrom(EJBQLExpression expression, int finishedChildIndex) {
            Compiler.this.appendingResultColumns = false;
            return true;
        }

        @Override
        public boolean visitSelectExpression(EJBQLExpression expression) {
            expression.visit(Compiler.this.rootDescriptorVisitor);
            return false;
        }

        @Override
        public boolean visitFromItem(EJBQLFromItem expression, int finishedChildIndex) {
            expression.visit(Compiler.this.fromItemVisitor);
            return false;
        }

        @Override
        public boolean visitInnerFetchJoin(EJBQLJoin join) {
            this.prepareFetchJoin(join);
            join.visit(Compiler.this.joinVisitor);
            return false;
        }

        @Override
        public boolean visitInnerJoin(EJBQLJoin join) {
            join.visit(Compiler.this.joinVisitor);
            return false;
        }

        @Override
        public boolean visitOuterFetchJoin(EJBQLJoin join) {
            this.prepareFetchJoin(join);
            join.visit(Compiler.this.joinVisitor);
            return false;
        }

        @Override
        public boolean visitOuterJoin(EJBQLJoin join) {
            join.visit(Compiler.this.joinVisitor);
            return false;
        }

        @Override
        public boolean visitWhere(EJBQLExpression expression) {
            expression.visit(Compiler.this.pathVisitor);
            return true;
        }

        @Override
        public boolean visitOrderBy(EJBQLExpression expression) {
            expression.visit(Compiler.this.pathVisitor);
            return false;
        }

        @Override
        public boolean visitSubselect(EJBQLExpression expression) {
            return super.visitSubselect(expression);
        }

        private void prepareFetchJoin(EJBQLJoin join) {
            if (Compiler.this.prefetchTree == null) {
                Compiler.this.prefetchTree = new PrefetchTreeNode();
            }
            EJBQLPath fetchJoin = (EJBQLPath)join.getChild(0);
            Compiler.this.addPath(fetchJoin);
            PrefetchTreeNode node = Compiler.this.prefetchTree.addPath(fetchJoin.getRelativePath());
            node.setSemantics(1);
            node.setPhantom(false);
            node.setEjbqlPathEntityId(fetchJoin.getChild(0).getText());
        }
    }
}

