/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowStoreFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.NoopEventBridge;

public class DefaultDataRowStoreFactory
implements DataRowStoreFactory {
    EventBridge eventBridge;
    EventManager eventManager;
    RuntimeProperties properties;
    boolean isNoopEventBridge;

    public DefaultDataRowStoreFactory(@Inject EventBridge eventBridge, @Inject EventManager eventManager, @Inject RuntimeProperties properties) {
        this.eventBridge = eventBridge;
        this.eventManager = eventManager;
        this.properties = properties;
        this.isNoopEventBridge = eventBridge instanceof NoopEventBridge;
    }

    @Override
    public DataRowStore createDataRowStore(String name) throws DIRuntimeException {
        DataRowStore store = new DataRowStore(name, this.properties, this.eventManager);
        this.setUpEventBridge(store);
        return store;
    }

    private void setUpEventBridge(DataRowStore store) {
        if (this.isNoopEventBridge) {
            return;
        }
        try {
            store.setEventBridge(this.eventBridge);
            store.startListeners();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error initializing DataRowStore.", (Throwable)ex, new Object[0]);
        }
    }
}

