/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.service;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.remote.service.BaseRemoteService;
import org.apache.cayenne.remote.service.ServerSession;

public abstract class HttpRemoteService
extends BaseRemoteService {
    static final String SESSION_ATTRIBUTE = HttpRemoteService.class.getName() + ".ServerSession";
    private Map<String, WeakReference<DataChannel>> sharedChannels = new HashMap<String, WeakReference<DataChannel>>();

    public HttpRemoteService(ObjectContextFactory contextFactory, Map<String, String> eventBridgeProperties) {
        super(contextFactory, eventBridgeProperties);
    }

    protected abstract HttpSession getSession(boolean var1);

    @Override
    protected ServerSession getServerSession() {
        HttpSession httpSession = this.getSession(true);
        return (ServerSession)httpSession.getAttribute(SESSION_ATTRIBUTE);
    }

    @Override
    protected ServerSession createServerSession() {
        HttpSession httpSession = this.getSession(true);
        DataChannel channel = this.createChannel();
        RemoteSession remoteSession = this.createRemoteSession(httpSession.getId(), null, false);
        ServerSession serverSession = new ServerSession(remoteSession, channel);
        httpSession.setAttribute(SESSION_ATTRIBUTE, (Object)serverSession);
        return serverSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServerSession createServerSession(String name) {
        DataChannel channel;
        if (name == null) {
            throw new IllegalArgumentException("Name is null for shared session.");
        }
        HttpSession httpSession = this.getSession(true);
        Map<String, WeakReference<DataChannel>> map = this.sharedChannels;
        synchronized (map) {
            channel = this.getSharedChannel(name);
            if (channel == null) {
                channel = this.createChannel();
                this.saveSharedChannel(name, channel);
                this.logger.debug("Starting a new shared channel: " + name);
            } else {
                this.logger.debug("Joining existing shared channel: " + name);
            }
        }
        RemoteSession remoteSession = this.createRemoteSession(httpSession.getId(), name, true);
        ServerSession serverSession = new ServerSession(remoteSession, channel);
        httpSession.setAttribute(SESSION_ATTRIBUTE, (Object)serverSession);
        return serverSession;
    }

    protected DataChannel getSharedChannel(String name) {
        WeakReference<DataChannel> ref = this.sharedChannels.get(name);
        return ref != null ? (DataChannel)ref.get() : null;
    }

    protected void saveSharedChannel(String name, DataChannel channel) {
        this.sharedChannels.put(name, new WeakReference<DataChannel>(channel));
    }
}

