/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DbEntityClassDescriptor;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.NodeIdChangeOperation;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.ToManyMapProperty;

abstract class DataDomainSyncBucket {
    final Map<ClassDescriptor, List<Persistent>> objectsByDescriptor = new HashMap<ClassDescriptor, List<Persistent>>();
    final DataDomainFlushAction parent;
    List<DbEntity> dbEntities;
    Map<DbEntity, Collection<DbEntityClassDescriptor>> descriptorsByDbEntity;

    DataDomainSyncBucket(DataDomainFlushAction parent) {
        this.parent = parent;
    }

    boolean isEmpty() {
        return this.objectsByDescriptor.isEmpty();
    }

    abstract void appendQueriesInternal(Collection<Query> var1);

    void appendQueries(Collection<Query> queries) {
        if (!this.objectsByDescriptor.isEmpty()) {
            this.groupObjEntitiesBySpannedDbEntities();
            this.appendQueriesInternal(queries);
        }
    }

    void checkReadOnly(ObjEntity entity) throws CayenneRuntimeException {
        if (entity == null) {
            throw new NullPointerException("Entity must not be null.");
        }
        if (entity.isReadOnly()) {
            throw new CayenneRuntimeException("Attempt to modify object(s) mapped to a read-only entity: '%s'. Can't commit changes.", entity.getName());
        }
    }

    private void groupObjEntitiesBySpannedDbEntities() {
        this.dbEntities = new ArrayList<DbEntity>(this.objectsByDescriptor.size());
        this.descriptorsByDbEntity = new HashMap<DbEntity, Collection<DbEntityClassDescriptor>>(this.objectsByDescriptor.size() * 2);
        for (ClassDescriptor descriptor : this.objectsByDescriptor.keySet()) {
            this.addSpannedDbEntities(descriptor);
        }
    }

    void addSpannedDbEntities(ClassDescriptor descriptor) {
        this.addDescriptor(descriptor, new DbEntityClassDescriptor(descriptor));
        for (ObjAttribute objAttribute : descriptor.getEntity().getAttributes()) {
            if (!objAttribute.isFlattened()) continue;
            this.addDescriptor(descriptor, new DbEntityClassDescriptor(descriptor, objAttribute));
        }
    }

    void addDescriptor(ClassDescriptor descriptor, DbEntityClassDescriptor dbEntityDescriptor) {
        DbEntity dbEntity = dbEntityDescriptor.getDbEntity();
        Collection<DbEntityClassDescriptor> descriptors = this.descriptorsByDbEntity.get(dbEntity);
        if (descriptors == null) {
            descriptors = new ArrayList<DbEntityClassDescriptor>(1);
            this.dbEntities.add(dbEntity);
            this.descriptorsByDbEntity.put(dbEntity, descriptors);
        }
        if (!this.containsClassDescriptor(descriptors, descriptor)) {
            descriptors.add(dbEntityDescriptor);
        }
    }

    private boolean containsClassDescriptor(Collection<DbEntityClassDescriptor> descriptors, ClassDescriptor classDescriptor) {
        for (DbEntityClassDescriptor descriptor : descriptors) {
            if (!classDescriptor.equals(descriptor.getClassDescriptor())) continue;
            return true;
        }
        return false;
    }

    void addDirtyObject(Persistent object, ClassDescriptor descriptor) {
        this.objectsByDescriptor.computeIfAbsent(descriptor, k -> new ArrayList()).add(object);
    }

    void postprocess() {
        if (!this.objectsByDescriptor.isEmpty()) {
            CompoundDiff result = this.parent.getResultDiff();
            Map<ObjectId, DataRow> modifiedSnapshots = this.parent.getResultModifiedSnapshots();
            Collection<ObjectId> deletedIds = this.parent.getResultDeletedIds();
            for (Map.Entry<ClassDescriptor, List<Persistent>> entry : this.objectsByDescriptor.entrySet()) {
                ClassDescriptor descriptor = entry.getKey();
                for (Persistent object : entry.getValue()) {
                    ObjectId finalId;
                    ObjectId id = object.getObjectId();
                    if (id.isReplacementIdAttached()) {
                        Map<String, Object> replacement = id.getReplacementIdMap();
                        for (AttributeProperty property : descriptor.getIdProperties()) {
                            Object value = replacement.get(property.getAttribute().getDbAttributeName());
                            if (value == null) continue;
                            property.writePropertyDirectly(object, null, value);
                        }
                        ObjectId replacementId = id.createReplacementId();
                        result.add(new NodeIdChangeOperation((Object)id, replacementId));
                        if (!id.isTemporary()) {
                            deletedIds.add(id);
                        }
                        finalId = replacementId;
                    } else {
                        if (id.isTemporary()) {
                            throw new CayenneRuntimeException("Temporary ID hasn't been replaced on commit: %s", object);
                        }
                        finalId = id;
                    }
                    DataRow dataRow = this.parent.getContext().currentSnapshot(object);
                    if (object instanceof DataObject) {
                        DataObject dataObject = (DataObject)object;
                        dataRow.setReplacesVersion(dataObject.getSnapshotVersion());
                        dataObject.setSnapshotVersion(dataRow.getVersion());
                    }
                    modifiedSnapshots.put(finalId, dataRow);
                    for (ArcProperty arc : descriptor.getMapArcProperties()) {
                        ToManyMapProperty reverseArc = (ToManyMapProperty)arc.getComplimentaryReverseArc();
                        Object source = arc.readProperty(object);
                        if (source == null || reverseArc.isFault(source)) continue;
                        this.remapTarget(reverseArc, source, object);
                    }
                }
            }
        }
    }

    private void remapTarget(ToManyMapProperty property, Object source, Object target) throws PropertyException {
        Object newKey;
        Map map = (Map)property.readProperty(source);
        Object currentValue = map.get(newKey = property.getMapKey(target));
        if (currentValue == target) {
            return;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (e.getValue() != target) continue;
            it.remove();
            break;
        }
        map.put(newKey, target);
    }

    static final class PropagatedValueFactory
    implements Supplier {
        ObjectId masterID;
        String masterKey;

        PropagatedValueFactory(ObjectId masterID, String masterKey) {
            this.masterID = masterID;
            this.masterKey = masterKey;
        }

        public Object get() {
            Object value = this.masterID.getIdSnapshot().get(this.masterKey);
            if (value == null) {
                throw new CayenneRuntimeException("Can't extract a master key. Missing key (%s), master ID (%s)", this.masterKey, this.masterID);
            }
            return value;
        }
    }
}

