/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collection;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQuery;

public abstract class FluentSelect<T>
extends IndirectQuery
implements Select<T> {
    protected Class<?> entityType;
    protected String entityName;
    protected String dbEntityName;
    protected Expression where;
    protected Collection<Ordering> orderings;
    protected PrefetchTreeNode prefetches;
    protected int limit;
    protected int offset;
    protected int pageSize;
    protected int statementFetchSize;
    protected QueryCacheStrategy cacheStrategy;
    protected String cacheGroup;

    protected FluentSelect() {
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        SelectQuery replacement = new SelectQuery();
        if (this.entityType != null) {
            replacement.setRoot(this.entityType);
        } else if (this.entityName != null) {
            ObjEntity entity = resolver.getObjEntity(this.entityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized ObjEntity name: %s", this.entityName);
            }
            replacement.setRoot(entity);
        } else if (this.dbEntityName != null) {
            DbEntity entity = resolver.getDbEntity(this.dbEntityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized DbEntity name: %s", this.dbEntityName);
            }
            replacement.setRoot(entity);
        } else {
            throw new CayenneRuntimeException("Undefined root entity of the query", new Object[0]);
        }
        replacement.setQualifier(this.where);
        replacement.addOrderings(this.orderings);
        replacement.setPrefetchTree(this.prefetches);
        replacement.setCacheStrategy(this.cacheStrategy);
        replacement.setCacheGroup(this.cacheGroup);
        replacement.setFetchLimit(this.limit);
        replacement.setFetchOffset(this.offset);
        replacement.setPageSize(this.pageSize);
        replacement.setStatementFetchSize(this.statementFetchSize);
        return replacement;
    }

    public String getCacheGroup() {
        return this.cacheGroup;
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public Expression getWhere() {
        return this.where;
    }

    public Collection<Ordering> getOrderings() {
        return this.orderings;
    }

    public PrefetchTreeNode getPrefetches() {
        return this.prefetches;
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }
}

