/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import org.apache.cayenne.access.types.ExtendedType;

public class DateType
implements ExtendedType<Date> {
    private final Calendar calendar;
    private final boolean useCalendar;

    public DateType() {
        this(false);
    }

    public DateType(boolean useCalendar) {
        this.useCalendar = useCalendar;
        this.calendar = this.useCalendar ? Calendar.getInstance() : null;
    }

    @Override
    public String getClassName() {
        return Date.class.getName();
    }

    @Override
    public Date materializeObject(ResultSet rs, int index, int type) throws Exception {
        return this.useCalendar ? rs.getDate(index, this.calendar) : rs.getDate(index);
    }

    @Override
    public Date materializeObject(CallableStatement rs, int index, int type) throws Exception {
        return this.useCalendar ? rs.getDate(index, this.calendar) : rs.getDate(index);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Date value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (this.useCalendar) {
            statement.setDate(pos, value, this.calendar);
        } else {
            statement.setDate(pos, value);
        }
    }

    @Override
    public String toString(Date value) {
        if (value == null) {
            return "NULL";
        }
        return '\'' + value.toString() + '\'';
    }
}

