/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.lang.reflect.Array;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeDecorator;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.util.IDUtil;

class ByteOrCharArrayFactory
implements ExtendedTypeFactory {
    private ExtendedTypeMap map;

    ByteOrCharArrayFactory(ExtendedTypeMap map) {
        this.map = map;
    }

    @Override
    public ExtendedType getType(Class<?> objectClass) {
        if (objectClass.isArray()) {
            Class<?> elementType = objectClass.getComponentType();
            if (Character.class.isAssignableFrom(elementType)) {
                ExtendedType stringType = this.map.getExplictlyRegisteredType("java.lang.String");
                return new CharacterArrayType(stringType);
            }
            if (Character.TYPE.isAssignableFrom(elementType)) {
                ExtendedType stringType = this.map.getExplictlyRegisteredType("java.lang.String");
                return new CharArrayType(stringType);
            }
            if (Byte.class.isAssignableFrom(elementType)) {
                ExtendedType bytesType = this.map.getExplictlyRegisteredType("byte[]");
                return new ByteWrapperArrayType(bytesType);
            }
        } else if (Character.class.isAssignableFrom(objectClass)) {
            ExtendedType stringType = this.map.getExplictlyRegisteredType("java.lang.String");
            return new CharacterType(stringType);
        }
        return null;
    }

    final class ByteWrapperArrayType
    extends ExtendedTypeDecorator<Byte[], byte[]> {
        ByteWrapperArrayType(ExtendedType<byte[]> byteArrayType) {
            super(byteArrayType);
        }

        @Override
        public String getClassName() {
            return "java.lang.Byte[]";
        }

        @Override
        byte[] fromJavaObject(Byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            byte[] buffer = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                buffer[i] = bytes[i] != null ? bytes[i] : (byte)0;
            }
            return buffer;
        }

        @Override
        Byte[] toJavaObject(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            Byte[] byteWrappers = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                byteWrappers[i] = bytes[i];
            }
            return byteWrappers;
        }

        @Override
        public String toString(Byte[] value) {
            if (value == null) {
                return "NULL";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("<");
            int len = value.length;
            boolean trimming = false;
            if (len > 30) {
                len = 30;
                trimming = true;
            }
            for (int i = 0; i < len; ++i) {
                IDUtil.appendFormattedByte(buffer, value[i]);
            }
            if (trimming) {
                buffer.append("...");
            }
            buffer.append('>');
            return buffer.toString();
        }
    }

    final class CharacterArrayType
    extends ExtendedTypeDecorator<Character[], String> {
        CharacterArrayType(ExtendedType<String> stringType) {
            super(stringType);
        }

        @Override
        public String getClassName() {
            return "java.lang.Character[]";
        }

        @Override
        String fromJavaObject(Character[] object) {
            if (object == null) {
                return null;
            }
            StringBuilder buffer = new StringBuilder(object.length);
            for (Character aChar : object) {
                buffer.append(aChar != null ? aChar.charValue() : (char)'\u0000');
            }
            return buffer.toString();
        }

        @Override
        Character[] toJavaObject(String object) {
            if (object == null) {
                return null;
            }
            Character[] chars = new Character[object.length()];
            for (int i = 0; i < object.length(); ++i) {
                chars[i] = Character.valueOf(object.charAt(i));
            }
            return chars;
        }

        @Override
        public String toString(Character[] value) {
            if (value == null) {
                return "NULL";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("<");
            int len = Array.getLength(value);
            boolean trimming = false;
            if (len > 30) {
                len = 30;
                trimming = true;
            }
            for (int i = 0; i < len; ++i) {
                buffer.append(Array.get(value, i));
            }
            if (trimming) {
                buffer.append("...");
            }
            buffer.append('>');
            return buffer.toString();
        }
    }

    final class CharArrayType
    extends ExtendedTypeDecorator<char[], String> {
        CharArrayType(ExtendedType<String> stringType) {
            super(stringType);
        }

        @Override
        public String getClassName() {
            return "char[]";
        }

        @Override
        String fromJavaObject(char[] object) {
            return object != null ? new String(object) : null;
        }

        @Override
        char[] toJavaObject(String object) {
            return object != null ? object.toCharArray() : null;
        }

        @Override
        public String toString(char[] value) {
            if (value == null) {
                return "NULL";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("<");
            int len = Array.getLength(value);
            boolean trimming = false;
            if (len > 30) {
                len = 30;
                trimming = true;
            }
            for (int i = 0; i < len; ++i) {
                buffer.append(Array.get(value, i));
            }
            if (trimming) {
                buffer.append("...");
            }
            buffer.append('>');
            return buffer.toString();
        }
    }

    final class CharacterType
    extends ExtendedTypeDecorator<Character, String> {
        CharacterType(ExtendedType<String> stringType) {
            super(stringType);
        }

        @Override
        public String getClassName() {
            return "java.lang.Character";
        }

        @Override
        String fromJavaObject(Character object) {
            return object != null ? String.valueOf(object.charValue()) : null;
        }

        @Override
        Character toJavaObject(String string) {
            if (string == null) {
                return null;
            }
            return string.length() > 0 ? Character.valueOf(string.charAt(0)) : null;
        }
    }
}

