/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import java.sql.Connection;
import java.util.function.Supplier;
import org.apache.cayenne.tx.TransactionPropagation;

public class TransactionDescriptor {
    public static final int ISOLATION_DEFAULT = -1;
    private int isolation;
    private TransactionPropagation propagation;
    private Supplier<Connection> connectionSupplier;

    private TransactionDescriptor() {
    }

    @Deprecated
    public TransactionDescriptor(int isolation, TransactionPropagation propagation) {
        this.isolation = isolation;
        this.propagation = propagation;
    }

    @Deprecated
    public TransactionDescriptor(int isolation) {
        this(isolation, TransactionPropagation.NESTED);
    }

    @Deprecated
    public TransactionDescriptor(TransactionPropagation propagation) {
        this(-1, propagation);
    }

    public int getIsolation() {
        return this.isolation;
    }

    public TransactionPropagation getPropagation() {
        return this.propagation;
    }

    public Supplier<Connection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TransactionDescriptor transactionDescriptor = new TransactionDescriptor();

        private Builder() {
        }

        public Builder isolation(int isolation) {
            this.transactionDescriptor.isolation = isolation;
            return this;
        }

        public Builder connection(Connection connection) {
            this.transactionDescriptor.connectionSupplier = () -> connection;
            return this;
        }

        public Builder connectionSupplier(Supplier<Connection> connectionSupplier) {
            this.transactionDescriptor.connectionSupplier = connectionSupplier;
            return this;
        }

        public Builder propagation(TransactionPropagation propagation) {
            this.transactionDescriptor.propagation = propagation;
            return this;
        }

        public TransactionDescriptor build() {
            return this.transactionDescriptor;
        }
    }
}

