/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.translator.procedure.ProcedureTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;

public class ProcedureAction
extends BaseSQLAction {
    protected ProcedureQuery query;
    protected int processedResultSets;

    public ProcedureAction(ProcedureQuery query, DataNode dataNode) {
        super(dataNode);
        this.query = query;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        this.processedResultSets = 0;
        transl = this.createTranslator(connection);
        statement = (CallableStatement)transl.createStatement();
        var5_5 = null;
        try {
            this.initStatement(statement);
            statement.execute();
            this.readProcedureOutParameters(statement, observer);
            while (true) lbl-1000:
            // 7 sources

            {
                if (statement.getMoreResults()) {
                    rs = statement.getResultSet();
                    var7_10 = null;
                    try {
                        descriptor = this.describeResultSet(rs, this.processedResultSets++);
                        this.readResultSet(rs, descriptor, this.query, observer);
                    }
                    catch (Throwable var8_13) {
                        var7_10 = var8_13;
                        throw var8_13;
                    }
                    finally {
                        if (rs == null) ** GOTO lbl-1000
                        if (var7_10 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable var8_12) {
                                var7_10.addSuppressed(var8_12);
                            }
                        }
                        rs.close();
                    }
                    continue;
                }
                updateCount = statement.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
                this.dataNode.getJdbcEventLogger().logUpdateCount(updateCount);
                observer.nextCount(this.query, updateCount);
            }
        }
        catch (Throwable var6_9) {
            var5_5 = var6_9;
            throw var6_9;
        }
        finally {
            if (statement != null) {
                if (var5_5 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable var6_8) {
                        var5_5.addSuppressed(var6_8);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    protected ProcedureTranslator createTranslator(Connection connection) {
        ProcedureTranslator translator = new ProcedureTranslator();
        translator.setAdapter(this.dataNode.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.dataNode.getEntityResolver());
        translator.setConnection(connection);
        translator.setJdbcEventLogger(this.dataNode.getJdbcEventLogger());
        return translator;
    }

    protected RowDescriptor describeResultSet(ResultSet resultSet, int setIndex) throws SQLException {
        if (setIndex < 0) {
            throw new IllegalArgumentException("Expected a non-negative result set index. Got: " + setIndex);
        }
        RowDescriptorBuilder builder = new RowDescriptorBuilder();
        List<ColumnDescriptor[]> descriptors = this.query.getResultDescriptors();
        if (descriptors.isEmpty()) {
            builder.setResultSet(resultSet);
        } else {
            if (setIndex >= descriptors.size() || descriptors.get(setIndex) == null) {
                throw new CayenneRuntimeException("No descriptor for result set at index '%d' configured.", setIndex);
            }
            ColumnDescriptor[] columns = descriptors.get(setIndex);
            builder.setColumns(columns);
        }
        switch (this.query.getColumnNamesCapitalization()) {
            case LOWER: {
                builder.useLowercaseColumnNames();
                break;
            }
            case UPPER: {
                builder.useUppercaseColumnNames();
            }
        }
        return builder.getDescriptor(this.dataNode.getAdapter().getExtendedTypes());
    }

    protected Procedure getProcedure() {
        return this.query.getMetaData(this.dataNode.getEntityResolver()).getProcedure();
    }

    protected void readProcedureOutParameters(CallableStatement statement, OperationObserver delegate) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        HashMap result = null;
        List<ProcedureParameter> parameters = this.getProcedure().getCallParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            ProcedureParameter parameter = parameters.get(i);
            if (!parameter.isOutParam()) continue;
            if (result == null) {
                result = new DataRow(2);
            }
            ColumnDescriptor descriptor = new ColumnDescriptor(parameter);
            ExtendedType type = this.dataNode.getAdapter().getExtendedTypes().getRegisteredType(descriptor.getJavaClass());
            Object val = type.materializeObject(statement, i + 1, descriptor.getJdbcType());
            result.put(descriptor.getDataRowKey(), val);
        }
        if (result != null && !result.isEmpty()) {
            this.dataNode.getJdbcEventLogger().logSelectCount(1, System.currentTimeMillis() - t1);
            delegate.nextRows((Query)this.query, Collections.singletonList(result));
        }
    }

    protected void initStatement(CallableStatement statement) throws Exception {
        int queryTimeout;
        QueryMetadata queryMetadata = this.query.getMetaData(this.dataNode.getEntityResolver());
        int statementFetchSize = queryMetadata.getStatementFetchSize();
        if (statementFetchSize != 0) {
            statement.setFetchSize(statementFetchSize);
        }
        if ((queryTimeout = queryMetadata.getQueryTimeout()) != -1) {
            statement.setQueryTimeout(queryTimeout);
        }
    }
}

