/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import java.util.function.Supplier;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.DistinctNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FromNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.GroupByNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.HavingNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.OrderByNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SelectNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SelectResultNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TopNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.WhereNode;

public class SelectBuilder
implements NodeBuilder {
    private static final int SELECT_NODE = 0;
    private static final int FROM_NODE = 1;
    private static final int WHERE_NODE = 2;
    private static final int GROUPBY_NODE = 3;
    private static final int HAVING_NODE = 4;
    private static final int UNION_NODE = 5;
    private static final int ORDERBY_NODE = 6;
    private static final int LIMIT_NODE = 7;
    private Node root;
    private Node[] nodes = new Node[8];

    SelectBuilder(NodeBuilder ... selectExpressions) {
        this.root = new SelectNode();
        for (NodeBuilder exp : selectExpressions) {
            this.node(0, SelectResultNode::new).addChild(exp.build());
        }
    }

    public SelectBuilder distinct() {
        this.root.addChild(new DistinctNode());
        return this;
    }

    public SelectBuilder top(int count) {
        this.root.addChild(new TopNode(count));
        return this;
    }

    public SelectBuilder result(NodeBuilder selectExpression) {
        this.node(0, SelectResultNode::new).addChild(selectExpression.build());
        return this;
    }

    public SelectBuilder from(NodeBuilder table) {
        this.node(1, FromNode::new).addChild(table.build());
        return this;
    }

    public SelectBuilder from(NodeBuilder ... tables) {
        for (NodeBuilder next : tables) {
            this.node(1, FromNode::new).addChild(next.build());
        }
        return this;
    }

    public SelectBuilder where(NodeBuilder ... params) {
        for (NodeBuilder next : params) {
            this.node(2, WhereNode::new).addChild(next.build());
        }
        return this;
    }

    public SelectBuilder where(Node node) {
        this.node(2, WhereNode::new).addChild(node);
        return this;
    }

    public SelectBuilder orderBy(NodeBuilder ... params) {
        for (NodeBuilder next : params) {
            this.node(6, OrderByNode::new).addChild(next.build());
        }
        return this;
    }

    public SelectBuilder orderBy(NodeBuilder param) {
        this.node(6, OrderByNode::new).addChild(param.build());
        return this;
    }

    public SelectBuilder groupBy(NodeBuilder ... params) {
        for (NodeBuilder next : params) {
            this.node(3, GroupByNode::new).addChild(next.build());
        }
        return this;
    }

    public SelectBuilder groupBy(Node node) {
        this.node(3, GroupByNode::new).addChild(node);
        return this;
    }

    public SelectBuilder having(NodeBuilder ... params) {
        for (NodeBuilder next : params) {
            this.node(4, HavingNode::new).addChild(next.build());
        }
        return this;
    }

    public SelectBuilder having(Node node) {
        this.node(4, HavingNode::new).addChild(node);
        return this;
    }

    public SelectBuilder limitOffset(int limit, int offset) {
        this.nodes[7] = new LimitOffsetNode(limit, offset);
        return this;
    }

    @Override
    public Node build() {
        for (Node next : this.nodes) {
            if (next == null) continue;
            this.root.addChild(next);
        }
        return this.root;
    }

    public Node getRoot() {
        return this.root;
    }

    private Node node(int idx, Supplier<Node> nodeSupplier) {
        if (this.nodes[idx] == null) {
            this.nodes[idx] = nodeSupplier.get();
        }
        return this.nodes[idx];
    }
}

