/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.OrderingNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTAggregateFunctionCall;
import org.apache.cayenne.query.Ordering;

class OrderingStage
implements TranslationStage {
    OrderingStage() {
    }

    @Override
    public void perform(TranslatorContext context) {
        if (context.getQuery().getOrderings() == null) {
            return;
        }
        QualifierTranslator qualifierTranslator = context.getQualifierTranslator();
        for (Ordering ordering : context.getQuery().getOrderings()) {
            this.processOrdering(qualifierTranslator, context, ordering);
        }
    }

    private void processOrdering(QualifierTranslator qualifierTranslator, TranslatorContext context, Ordering ordering) {
        Expression exp = ordering.getSortSpec();
        Node translatedNode = qualifierTranslator.translate(exp);
        NodeBuilder nodeBuilder = SQLBuilder.node(translatedNode);
        if (ordering.isCaseInsensitive()) {
            nodeBuilder = SQLBuilder.function("UPPER", nodeBuilder);
        }
        if (this.shouldAddToResult(context, exp)) {
            context.addResultNode((Node)nodeBuilder.build().deepCopy());
        }
        OrderingNodeBuilder orderingNodeBuilder = SQLBuilder.order(nodeBuilder);
        if (ordering.isDescending()) {
            orderingNodeBuilder.desc();
        }
        context.getSelectBuilder().orderBy((NodeBuilder)orderingNodeBuilder);
    }

    private boolean shouldAddToResult(TranslatorContext context, Expression exp) {
        if (context.isDistinctSuppression()) {
            return false;
        }
        return !(exp instanceof ASTAggregateFunctionCall);
    }
}

