/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.sqlbuilder.sqltree.SimpleNodeTreeVisitor;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.parser.ASTAggregateFunctionCall;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.DbAttribute;

class ResultNodeDescriptor {
    private final Node node;
    private final boolean inDataRow;
    private final boolean isAggregate;
    private final Property<?> property;
    private String dataRowKey;
    private DbAttribute dbAttribute;
    private String javaType;

    ResultNodeDescriptor(Node node, boolean inDataRow, Property<?> property, String dataRowKey) {
        this.node = node;
        this.inDataRow = inDataRow;
        this.property = property;
        this.dataRowKey = dataRowKey;
        this.isAggregate = property != null && property.getExpression() instanceof ASTAggregateFunctionCall;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isInDataRow() {
        return this.inDataRow;
    }

    public Property<?> getProperty() {
        return this.property;
    }

    public Node getNode() {
        return this.node;
    }

    public String getDataRowKey() {
        if (this.dataRowKey != null) {
            return this.dataRowKey;
        }
        if (this.property != null) {
            return this.property.getAlias();
        }
        if (this.getDbAttribute() != null) {
            return this.getDbAttribute().getName();
        }
        return null;
    }

    public void setDataRowKey(String dataRowKey) {
        this.dataRowKey = dataRowKey;
    }

    public ResultNodeDescriptor setJavaType(String javaType) {
        this.javaType = javaType;
        return this;
    }

    public ResultNodeDescriptor setDbAttribute(DbAttribute dbAttribute) {
        this.dbAttribute = dbAttribute;
        return this;
    }

    public String getJavaType() {
        if (this.javaType != null) {
            return this.javaType;
        }
        if (this.property != null) {
            return this.property.getType().getCanonicalName();
        }
        if (this.getDbAttribute() != null) {
            return TypesMapping.getJavaBySqlType(this.getDbAttribute().getType());
        }
        return null;
    }

    public int getJdbcType() {
        if (this.getDbAttribute() != null) {
            return this.getDbAttribute().getType();
        }
        if (this.getProperty() != null) {
            return TypesMapping.getSqlTypeByJava(this.getProperty().getType());
        }
        return Integer.MAX_VALUE;
    }

    public DbAttribute getDbAttribute() {
        if (this.dbAttribute != null) {
            return this.dbAttribute;
        }
        final DbAttribute[] dbAttribute = new DbAttribute[]{null};
        this.node.visit(new SimpleNodeTreeVisitor(){

            @Override
            public boolean onNodeStart(Node node) {
                if (node.getType() == NodeType.COLUMN) {
                    dbAttribute[0] = ((ColumnNode)node).getAttribute();
                    return false;
                }
                return true;
            }
        });
        this.dbAttribute = dbAttribute[0];
        return this.dbAttribute;
    }
}

