/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.HashMap;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.ParseException;

class ExpressionUtils {
    ExpressionUtils() {
    }

    static void parsePath(ASTPath pathExp, Object path) throws ParseException {
        if (path != null && path.toString().contains("#")) {
            CharSequence[] pathSegments = path.toString().split("\\.");
            HashMap<String, String> aliasMap = new HashMap<String, String>();
            for (int i = 0; i < pathSegments.length; ++i) {
                if (!pathSegments[i].contains("#")) continue;
                String[] splitedSegment = ((String)pathSegments[i]).split("#");
                splitedSegment[0] = splitedSegment[0] + (splitedSegment[1].endsWith("+") ? "+" : "");
                String string = splitedSegment[1] = splitedSegment[1].endsWith("+") ? splitedSegment[1].substring(0, splitedSegment[1].length() - 1) : splitedSegment[1];
                if (aliasMap.putIfAbsent(splitedSegment[1], splitedSegment[0]) != null && !((String)aliasMap.get(splitedSegment[1])).equals(splitedSegment[0])) {
                    throw new ParseException("Can't add the same alias to different path segments.");
                }
                pathSegments[i] = splitedSegment[1];
            }
            pathExp.setPath(String.join((CharSequence)".", pathSegments));
            pathExp.setPathAliases(aliasMap);
        } else {
            pathExp.setPath(path);
        }
    }
}

