/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.util.List;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryMetadataProxy;

public class NestedQueryCache
implements QueryCache {
    private static final String NAMESPACE_PREXIX = "#nested-";
    private static volatile int currentId;
    protected QueryCache delegate;
    protected String namespace;

    private static final int nextInt() {
        if (currentId == Integer.MAX_VALUE) {
            currentId = 0;
        }
        return currentId++;
    }

    public NestedQueryCache(QueryCache delegate) {
        this.delegate = delegate;
        this.namespace = NAMESPACE_PREXIX + NestedQueryCache.nextInt() + ":";
    }

    public QueryCache getDelegate() {
        return this.delegate;
    }

    @Override
    @Deprecated
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        return this.delegate.get(this.qualifiedMetadata(metadata), factory);
    }

    @Override
    public List get(QueryMetadata metadata) {
        return this.delegate.get(this.qualifiedMetadata(metadata));
    }

    @Override
    public void put(QueryMetadata metadata, List results) {
        this.delegate.put(this.qualifiedMetadata(metadata), results);
    }

    @Override
    public void remove(String key) {
        this.delegate.remove(this.qualifiedKey(key));
    }

    @Override
    public void removeGroup(String groupKey) {
        this.delegate.removeGroup(groupKey);
    }

    @Override
    public void removeGroup(String groupKey, Class<?> keyType, Class<?> valueType) {
        this.delegate.removeGroup(groupKey, keyType, valueType);
    }

    private String qualifiedKey(String key) {
        return key != null ? this.namespace + key : null;
    }

    private QueryMetadata qualifiedMetadata(QueryMetadata md) {
        return new QueryMetadataProxy(md){

            @Override
            public String getCacheKey() {
                return NestedQueryCache.this.qualifiedKey(this.mdDelegate.getCacheKey());
            }
        };
    }
}

