/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;

public abstract class AbstractWebServicesService {
    private Session fSession;

    protected void setSession(Session session) {
        this.fSession = session;
    }

    protected Session getSession() {
        return this.fSession;
    }

    protected CmisBaseException convertException(CmisException ex) {
        if (ex == null || ex.getFaultInfo() == null) {
            return new CmisRuntimeException("CmisException has no fault!");
        }
        String msg = ex.getFaultInfo().getMessage();
        BigInteger code = ex.getFaultInfo().getCode();
        switch (ex.getFaultInfo().getType()) {
            case CONSTRAINT: {
                return new CmisConstraintException(msg, code);
            }
            case CONTENT_ALREADY_EXISTS: {
                return new CmisContentAlreadyExistsException(msg, code);
            }
            case FILTER_NOT_VALID: {
                return new CmisFilterNotValidException(msg, code);
            }
            case INVALID_ARGUMENT: {
                return new CmisInvalidArgumentException(msg, code);
            }
            case NAME_CONSTRAINT_VIOLATION: {
                return new CmisNameConstraintViolationException(msg, code);
            }
            case NOT_SUPPORTED: {
                return new CmisNotSupportedException(msg, code);
            }
            case OBJECT_NOT_FOUND: {
                return new CmisObjectNotFoundException(msg, code);
            }
            case PERMISSION_DENIED: {
                return new CmisPermissionDeniedException(msg, code);
            }
            case RUNTIME: {
                return new CmisRuntimeException(msg, code);
            }
            case STORAGE: {
                return new CmisStorageException(msg, code);
            }
            case STREAM_NOT_SUPPORTED: {
                return new CmisStreamNotSupportedException(msg, code);
            }
            case UPDATE_CONFLICT: {
                return new CmisUpdateConflictException(msg, code);
            }
            case VERSIONING: {
                return new CmisVersioningException(msg, code);
            }
        }
        return new CmisRuntimeException("Unknown exception[" + ex.getFaultInfo().getType().value() + "]: " + msg);
    }
}

