/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.bindings.cache.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.runtime.CmisBindingHelper;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.QueryStatementImpl;
import org.apache.chemistry.opencmis.client.runtime.cache.Cache;
import org.apache.chemistry.opencmis.client.runtime.cache.CacheImpl;
import org.apache.chemistry.opencmis.client.runtime.repository.ObjectFactoryImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.client.runtime.util.TreeImpl;
import org.apache.chemistry.opencmis.client.util.OperationContextUtils;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.ExtendedAclService;
import org.apache.chemistry.opencmis.commons.spi.ExtendedHolder;
import org.apache.chemistry.opencmis.commons.spi.ExtendedRepositoryService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

public class SessionImpl
implements Session {
    private static final OperationContext DEFAULT_CONTEXT = new OperationContextImpl(null, false, true, false, IncludeRelationships.NONE, null, true, null, true, 100);
    private static final Set<Updatability> CREATE_UPDATABILITY = EnumSet.noneOf(Updatability.class);
    private static final Set<Updatability> CREATE_AND_CHECKOUT_UPDATABILITY = EnumSet.noneOf(Updatability.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private transient LinkedHashMap<String, ObjectType> objectTypeCache;
    private OperationContext defaultContext = DEFAULT_CONTEXT;
    private Map<String, String> parameters;
    private CmisBinding binding;
    private Locale locale;
    private final ObjectFactory objectFactory;
    private final AuthenticationProvider authenticationProvider;
    private Cache cache;
    private final boolean cachePathOmit;
    private TypeDefinitionCache typeDefCache;
    private RepositoryInfo repositoryInfo;
    private static final long serialVersionUID = 1L;

    public SessionImpl(Map<String, String> parameters, ObjectFactory objectFactory, AuthenticationProvider authenticationProvider, Cache cache, TypeDefinitionCache typeDefCache) {
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters provided!");
        }
        this.parameters = parameters;
        this.locale = this.determineLocale(parameters);
        this.objectFactory = objectFactory == null ? this.createObjectFactory() : objectFactory;
        this.authenticationProvider = authenticationProvider;
        this.cache = cache == null ? this.createCache() : cache;
        this.typeDefCache = typeDefCache;
        this.cachePathOmit = Boolean.parseBoolean(parameters.get("org.apache.chemistry.opencmis.cache.path.omit"));
    }

    private Locale determineLocale(Map<String, String> parameters) {
        Locale result = null;
        String language = parameters.get("org.apache.chemistry.opencmis.locale.iso639");
        String country = parameters.get("org.apache.chemistry.opencmis.locale.iso3166");
        String variant = parameters.get("org.apache.chemistry.opencmis.locale.variant");
        result = variant != null ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : (language != null ? new Locale(language) : Locale.getDefault()));
        return result;
    }

    private ObjectFactory createObjectFactory() {
        try {
            String classname = this.parameters.get("org.apache.chemistry.opencmis.objectfactory.classname");
            Class objectFactoryClass = classname == null ? ObjectFactoryImpl.class : ClassLoaderUtil.loadClass((String)classname);
            Object of = objectFactoryClass.newInstance();
            if (!(of instanceof ObjectFactory)) {
                throw new InstantiationException("Class does not implement ObjectFactory!");
            }
            ((ObjectFactory)of).initialize((Session)this, this.parameters);
            return (ObjectFactory)of;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create object factory: " + e, e);
        }
    }

    private Cache createCache() {
        try {
            String classname = this.parameters.get("org.apache.chemistry.opencmis.cache.classname");
            Class cacheClass = classname == null ? CacheImpl.class : ClassLoaderUtil.loadClass((String)classname);
            Object of = cacheClass.newInstance();
            if (!(of instanceof Cache)) {
                throw new InstantiationException("Class does not implement Cache!");
            }
            ((Cache)of).initialize(this, this.parameters);
            return (Cache)of;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create cache: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache = this.createCache();
            this.objectTypeCache = null;
            this.getBinding().clearAllCaches();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ObjectFactory getObjectFactory() {
        assert (this.objectFactory != null);
        return this.objectFactory;
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        return this.getCheckedOutDocs(this.getDefaultContext());
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final NavigationService navigationService = this.getBinding().getNavigationService();
        final ObjectFactory of = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<Document>(new AbstractPageFetcher<Document>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<Document> fetchPage(long skipCount) {
                ObjectList checkedOutDocs = navigationService.getCheckedOutDocs(SessionImpl.this.getRepositoryId(), null, ctxt.getFilterString(), ctxt.getOrderBy(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<Document> page = new ArrayList<Document>();
                if (checkedOutDocs.getObjects() != null) {
                    for (ObjectData objectData : checkedOutDocs.getObjects()) {
                        CmisObject doc = of.convertObject(objectData, ctxt);
                        if (!(doc instanceof Document)) continue;
                        page.add((Document)doc);
                    }
                }
                return new AbstractPageFetcher.Page<Document>(page, checkedOutDocs.getNumItems(), checkedOutDocs.hasMoreItems());
            }
        });
    }

    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems) {
        return this.getContentChanges(changeLogToken, includeProperties, maxNumItems, this.getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems, OperationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        Holder changeLogTokenHolder = new Holder((Object)changeLogToken);
        ObjectList objectList = null;
        this.lock.readLock().lock();
        try {
            objectList = this.getBinding().getDiscoveryService().getContentChanges(this.getRepositoryInfo().getId(), changeLogTokenHolder, Boolean.valueOf(includeProperties), context.getFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), BigInteger.valueOf(maxNumItems), null);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return this.objectFactory.convertChangeEvents((String)changeLogTokenHolder.getValue(), objectList);
    }

    public ItemIterable<ChangeEvent> getContentChanges(String changeLogToken, boolean includeProperties) {
        return this.getContentChanges(changeLogToken, includeProperties, this.getDefaultContext());
    }

    public ItemIterable<ChangeEvent> getContentChanges(final String changeLogToken, final boolean includeProperties, OperationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final DiscoveryService discoveryService = this.getBinding().getDiscoveryService();
        final ObjectFactory of = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<ChangeEvent>((AbstractPageFetcher)new AbstractPageFetcher<ChangeEvent>(Integer.MAX_VALUE){
            private String token;
            private String nextLink;
            private boolean firstPage;
            {
                super(x0);
                this.token = changeLogToken;
                this.nextLink = null;
                this.firstPage = true;
            }

            @Override
            protected AbstractPageFetcher.Page<ChangeEvent> fetchPage(long skipCount) {
                assert (!this.firstPage && this.token == null || this.nextLink == null);
                ExtendedHolder changeLogTokenHolder = new ExtendedHolder((Object)this.token);
                if (this.nextLink != null) {
                    changeLogTokenHolder.setExtraValue("http://docs.oasis-open.org/ns/cmis/link/200908/changes", (Object)this.nextLink);
                }
                ObjectList objectList = discoveryService.getContentChanges(SessionImpl.this.getRepositoryInfo().getId(), (Holder)changeLogTokenHolder, Boolean.valueOf(includeProperties), ctxt.getFilterString(), Boolean.valueOf(ctxt.isIncludePolicies()), Boolean.valueOf(ctxt.isIncludeAcls()), BigInteger.valueOf(this.maxNumItems), null);
                ArrayList<ChangeEvent> page = new ArrayList<ChangeEvent>();
                for (ObjectData objectData : objectList.getObjects()) {
                    page.add(of.convertChangeEvent(objectData));
                }
                if (!this.firstPage) {
                    page.remove(0);
                }
                this.firstPage = false;
                if (changeLogTokenHolder.getValue() != null) {
                    this.token = (String)changeLogTokenHolder.getValue();
                } else {
                    this.token = null;
                    this.nextLink = (String)changeLogTokenHolder.getExtraValue("http://docs.oasis-open.org/ns/cmis/link/200908/changes");
                }
                return new AbstractPageFetcher.Page<ChangeEvent>(page, objectList.getNumItems(), objectList.hasMoreItems()){};
            }
        }){

            @Override
            public ItemIterable<ChangeEvent> skipTo(long position) {
                throw new CmisNotSupportedException("Skipping not supported!");
            }

            @Override
            public ItemIterable<ChangeEvent> getPage() {
                throw new CmisNotSupportedException("Paging not supported!");
            }

            @Override
            public ItemIterable<ChangeEvent> getPage(int maxNumItems) {
                throw new CmisNotSupportedException("Paging not supported!");
            }
        };
    }

    public String getLatestChangeLogToken() {
        return this.getBinding().getRepositoryService().getRepositoryInfo(this.getRepositoryId(), null).getLatestChangeLogToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContext getDefaultContext() {
        this.lock.readLock().lock();
        try {
            OperationContext operationContext = this.defaultContext;
            return operationContext;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultContext(OperationContext context) {
        this.lock.writeLock().lock();
        try {
            this.defaultContext = context == null ? DEFAULT_CONTEXT : context;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public OperationContext createOperationContext(Set<String> filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        return OperationContextUtils.createOperationContext(filter, includeAcls, includeAllowableActions, includePolicies, includeRelationships, renditionFilter, includePathSegments, orderBy, cacheEnabled, maxItemsPerPage);
    }

    public OperationContext createOperationContext() {
        return OperationContextUtils.createOperationContext();
    }

    public ObjectId createObjectId(String id) {
        return new ObjectIdImpl(id);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public CmisObject getObject(ObjectId objectId) {
        return this.getObject(objectId, this.getDefaultContext());
    }

    public CmisObject getObject(ObjectId objectId, OperationContext context) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Object ID must be set!");
        }
        return this.getObject(objectId.getId(), context);
    }

    public CmisObject getObject(String objectId) {
        return this.getObject(objectId, this.getDefaultContext());
    }

    public CmisObject getObject(String objectId, OperationContext context) {
        if (objectId == null) {
            throw new IllegalArgumentException("Object ID must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        CmisObject result = null;
        if (context.isCacheEnabled() && (result = this.cache.getById(objectId, context.getCacheKey())) != null) {
            return result;
        }
        ObjectData objectData = this.binding.getObjectService().getObject(this.getRepositoryId(), objectId, context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        result = this.getObjectFactory().convertObject(objectData, context);
        if (context.isCacheEnabled()) {
            this.cache.put(result, context.getCacheKey());
        }
        return result;
    }

    public CmisObject getObjectByPath(String path) {
        return this.getObjectByPath(path, this.getDefaultContext());
    }

    public CmisObject getObjectByPath(String path, OperationContext context) {
        if (path == null) {
            throw new IllegalArgumentException("Path must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        CmisObject result = null;
        if (context.isCacheEnabled() && !this.cachePathOmit && (result = this.cache.getByPath(path, context.getCacheKey())) != null) {
            return result;
        }
        ObjectData objectData = this.binding.getObjectService().getObjectByPath(this.getRepositoryId(), path, context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        result = this.getObjectFactory().convertObject(objectData, context);
        if (context.isCacheEnabled()) {
            this.cache.putPath(path, result, context.getCacheKey());
        }
        return result;
    }

    public CmisObject getObjectByPath(String parentPath, String name) {
        return this.getObjectByPath(parentPath, name, this.getDefaultContext());
    }

    public CmisObject getObjectByPath(String parentPath, String name, OperationContext context) {
        if (parentPath == null || parentPath.length() < 1) {
            throw new IllegalArgumentException("Parent path must be set!");
        }
        if (parentPath.charAt(0) != '/') {
            throw new IllegalArgumentException("Parent path must start with a '/'!");
        }
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("Name must be set!");
        }
        StringBuilder path = new StringBuilder();
        path.append(parentPath);
        if (!parentPath.endsWith("/")) {
            path.append('/');
        }
        path.append(name);
        return this.getObjectByPath(path.toString(), context);
    }

    public Document getLatestDocumentVersion(ObjectId objectId) {
        return this.getLatestDocumentVersion(objectId, false, this.getDefaultContext());
    }

    public Document getLatestDocumentVersion(String objectId, OperationContext context) {
        if (objectId == null) {
            throw new IllegalArgumentException("Object ID must be set!");
        }
        return this.getLatestDocumentVersion(this.createObjectId(objectId), false, context);
    }

    public Document getLatestDocumentVersion(String objectId, boolean major, OperationContext context) {
        if (objectId == null) {
            throw new IllegalArgumentException("Object ID must be set!");
        }
        return this.getLatestDocumentVersion(this.createObjectId(objectId), major, context);
    }

    public Document getLatestDocumentVersion(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Object ID must be set!");
        }
        return this.getLatestDocumentVersion(this.createObjectId(objectId), false, this.getDefaultContext());
    }

    public Document getLatestDocumentVersion(ObjectId objectId, OperationContext context) {
        return this.getLatestDocumentVersion(objectId, false, context);
    }

    public Document getLatestDocumentVersion(ObjectId objectId, boolean major, OperationContext context) {
        BindingType bindingType;
        CmisObject sourceDoc;
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Object ID must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        CmisObject result = null;
        String versionSeriesId = null;
        if (objectId instanceof Document) {
            versionSeriesId = ((Document)objectId).getVersionSeriesId();
        }
        if (versionSeriesId == null && context.isCacheEnabled() && (sourceDoc = this.cache.getById(objectId.getId(), context.getCacheKey())) instanceof Document) {
            versionSeriesId = ((Document)sourceDoc).getVersionSeriesId();
        }
        if (versionSeriesId == null && ((bindingType = this.getBinding().getBindingType()) == BindingType.WEBSERVICES || bindingType == BindingType.CUSTOM)) {
            PropertyData verionsSeriesIdProp;
            ObjectData sourceObjectData = this.binding.getObjectService().getObject(this.getRepositoryId(), objectId.getId(), "cmis:objectId,cmis:versionSeriesId", Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
            if (sourceObjectData.getProperties() != null && sourceObjectData.getProperties().getProperties() != null && (verionsSeriesIdProp = (PropertyData)sourceObjectData.getProperties().getProperties().get("cmis:versionSeriesId")) != null && verionsSeriesIdProp.getFirstValue() instanceof String) {
                versionSeriesId = (String)verionsSeriesIdProp.getFirstValue();
            }
            if (versionSeriesId == null) {
                throw new IllegalArgumentException("Object is not a document or not versionable!");
            }
        }
        ObjectData objectData = this.binding.getVersioningService().getObjectOfLatestVersion(this.getRepositoryId(), objectId.getId(), versionSeriesId, Boolean.valueOf(major), context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        result = this.getObjectFactory().convertObject(objectData, context);
        if (context.isCacheEnabled()) {
            this.cache.put(result, context.getCacheKey());
        }
        if (!(result instanceof Document)) {
            throw new IllegalArgumentException("Latest version is not a document!");
        }
        return (Document)result;
    }

    public void removeObjectFromCache(ObjectId objectId) {
        if (objectId == null || objectId.getId() == null) {
            return;
        }
        this.removeObjectFromCache(objectId.getId());
    }

    public void removeObjectFromCache(String objectId) {
        this.cache.remove(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryInfo getRepositoryInfo() {
        this.lock.readLock().lock();
        try {
            RepositoryInfo repositoryInfo = this.repositoryInfo;
            return repositoryInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Folder getRootFolder() {
        return this.getRootFolder(this.getDefaultContext());
    }

    public Folder getRootFolder(OperationContext context) {
        String rootFolderId = this.getRepositoryInfo().getRootFolderId();
        CmisObject rootFolder = this.getObject(rootFolderId, context);
        if (!(rootFolder instanceof Folder)) {
            throw new CmisRuntimeException("Root folder object is not a folder!");
        }
        return (Folder)rootFolder;
    }

    public ItemIterable<ObjectType> getTypeChildren(final String typeId, final boolean includePropertyDefinitions) {
        final RepositoryService repositoryService = this.getBinding().getRepositoryService();
        return new CollectionIterable<ObjectType>(new AbstractPageFetcher<ObjectType>((long)this.getDefaultContext().getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<ObjectType> fetchPage(long skipCount) {
                TypeDefinitionList tdl = repositoryService.getTypeChildren(SessionImpl.this.getRepositoryId(), typeId, Boolean.valueOf(includePropertyDefinitions), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<ObjectType> page = new ArrayList<ObjectType>(tdl.getList().size());
                for (TypeDefinition typeDefinition : tdl.getList()) {
                    page.add(SessionImpl.this.convertTypeDefinition(typeDefinition));
                }
                return new AbstractPageFetcher.Page<ObjectType>(page, tdl.getNumItems(), tdl.hasMoreItems()){};
            }
        });
    }

    public ObjectType getTypeDefinition(String typeId) {
        TypeDefinition typeDefinition = this.getBinding().getRepositoryService().getTypeDefinition(this.getRepositoryId(), typeId, null);
        return this.convertAndCacheTypeDefinition(typeDefinition, true);
    }

    public ObjectType getTypeDefinition(String typeId, boolean useCache) {
        RepositoryService service = this.getBinding().getRepositoryService();
        if (!(service instanceof ExtendedRepositoryService)) {
            throw new CmisRuntimeException("Internal error: Repository Service does not implement ExtendedRepositoryService!");
        }
        ExtendedRepositoryService extRepSrv = (ExtendedRepositoryService)service;
        TypeDefinition typeDefinition = extRepSrv.getTypeDefinition(this.getRepositoryId(), typeId, null, useCache);
        return this.convertAndCacheTypeDefinition(typeDefinition, useCache);
    }

    public List<Tree<ObjectType>> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
        List descendants = this.getBinding().getRepositoryService().getTypeDescendants(this.getRepositoryId(), typeId, BigInteger.valueOf(depth), Boolean.valueOf(includePropertyDefinitions), null);
        return this.convertTypeDescendants(descendants);
    }

    private List<Tree<ObjectType>> convertTypeDescendants(List<TypeDefinitionContainer> descendantsList) {
        ArrayList<Tree<ObjectType>> result = new ArrayList<Tree<ObjectType>>();
        for (TypeDefinitionContainer container : descendantsList) {
            ObjectType objectType = this.convertTypeDefinition(container.getTypeDefinition());
            List children = this.convertTypeDescendants(container.getChildren());
            result.add(new TreeImpl<ObjectType>(objectType, children));
        }
        return result;
    }

    private ObjectType convertTypeDefinition(TypeDefinition typeDefinition) {
        return this.objectFactory.convertTypeDefinition(typeDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectType convertAndCacheTypeDefinition(TypeDefinition typeDefinition, boolean useCache) {
        ObjectType result = null;
        this.lock.writeLock().lock();
        try {
            if (this.objectTypeCache == null) {
                int cacheSize;
                try {
                    cacheSize = Integer.valueOf(this.parameters.get("org.apache.chemistry.opencmis.binding.cache.types.size"));
                    if (cacheSize < 0) {
                        cacheSize = 100;
                    }
                }
                catch (NumberFormatException nfe) {
                    cacheSize = 100;
                }
                final int maxEntries = cacheSize;
                this.objectTypeCache = new LinkedHashMap<String, ObjectType>(maxEntries + 1, 0.7f, true){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public boolean removeEldestEntry(Map.Entry<String, ObjectType> eldest) {
                        return this.size() > maxEntries;
                    }
                };
            }
            if (!useCache) {
                result = this.objectFactory.convertTypeDefinition(typeDefinition);
                this.objectTypeCache.put(result.getId(), result);
            } else {
                result = this.objectTypeCache.get(typeDefinition.getId());
                if (result == null) {
                    result = this.objectFactory.convertTypeDefinition(typeDefinition);
                    this.objectTypeCache.put(result.getId(), result);
                }
            }
            ObjectType objectType = result;
            return objectType;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromObjectTypeCache(String typeId) {
        this.lock.writeLock().lock();
        try {
            if (this.objectTypeCache != null) {
                this.objectTypeCache.remove(typeId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ObjectType createType(TypeDefinition type) {
        if (this.repositoryInfo.getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        TypeDefinition newType = this.getBinding().getRepositoryService().createType(this.getRepositoryId(), type, null);
        return this.convertTypeDefinition(newType);
    }

    public ObjectType updateType(TypeDefinition type) {
        if (this.repositoryInfo.getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        TypeDefinition updatedType = this.getBinding().getRepositoryService().updateType(this.getRepositoryId(), type, null);
        this.removeFromObjectTypeCache(updatedType.getId());
        return this.convertTypeDefinition(updatedType);
    }

    public void deleteType(String typeId) {
        if (this.repositoryInfo.getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        this.getBinding().getRepositoryService().deleteType(this.getRepositoryId(), typeId, null);
        this.removeFromObjectTypeCache(typeId);
    }

    public ItemIterable<QueryResult> query(String statement, boolean searchAllVersions) {
        return this.query(statement, searchAllVersions, this.getDefaultContext());
    }

    public ItemIterable<QueryResult> query(final String statement, final boolean searchAllVersions, OperationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final DiscoveryService discoveryService = this.getBinding().getDiscoveryService();
        final ObjectFactory of = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<QueryResult>(new AbstractPageFetcher<QueryResult>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<QueryResult> fetchPage(long skipCount) {
                ObjectList resultList = discoveryService.query(SessionImpl.this.getRepositoryId(), statement, Boolean.valueOf(searchAllVersions), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<QueryResult> page = new ArrayList<QueryResult>();
                if (resultList.getObjects() != null) {
                    for (ObjectData objectData : resultList.getObjects()) {
                        if (objectData == null) continue;
                        page.add(of.convertQueryResult(objectData));
                    }
                }
                return new AbstractPageFetcher.Page<QueryResult>(page, resultList.getNumItems(), resultList.hasMoreItems());
            }
        });
    }

    public ItemIterable<CmisObject> queryObjects(String typeId, String where, final boolean searchAllVersions, OperationContext context) {
        String orderBy;
        if (typeId == null || typeId.trim().length() == 0) {
            throw new IllegalArgumentException("Type ID must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final DiscoveryService discoveryService = this.getBinding().getDiscoveryService();
        final ObjectFactory of = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        final StringBuilder statement = new StringBuilder("SELECT ");
        String select = ctxt.getFilterString();
        if (select == null) {
            statement.append('*');
        } else {
            statement.append(select);
        }
        ObjectType type = this.getTypeDefinition(typeId);
        statement.append(" FROM ");
        statement.append(type.getQueryName());
        if (where != null && where.trim().length() > 0) {
            statement.append(" WHERE ");
            statement.append(where);
        }
        if ((orderBy = ctxt.getOrderBy()) != null && orderBy.trim().length() > 0) {
            statement.append(" ORDER BY ");
            statement.append(orderBy);
        }
        return new CollectionIterable<CmisObject>(new AbstractPageFetcher<CmisObject>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<CmisObject> fetchPage(long skipCount) {
                ObjectList resultList = discoveryService.query(SessionImpl.this.getRepositoryId(), statement.toString(), Boolean.valueOf(searchAllVersions), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<CmisObject> page = new ArrayList<CmisObject>();
                if (resultList.getObjects() != null) {
                    for (ObjectData objectData : resultList.getObjects()) {
                        if (objectData == null) continue;
                        page.add(of.convertObject(objectData, ctxt));
                    }
                }
                return new AbstractPageFetcher.Page<CmisObject>(page, resultList.getNumItems(), resultList.hasMoreItems());
            }
        });
    }

    public QueryStatement createQueryStatement(String statement) {
        return new QueryStatementImpl(this, statement);
    }

    public QueryStatement createQueryStatement(Collection<String> selectPropertyIds, Map<String, String> fromTypes, String whereClause, List<String> orderByPropertyIds) {
        return new QueryStatementImpl(this, selectPropertyIds, fromTypes, whereClause, orderByPropertyIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        this.lock.writeLock().lock();
        try {
            this.binding = CmisBindingHelper.createBinding(this.parameters, this.authenticationProvider, this.typeDefCache);
            String repositoryId = this.parameters.get("org.apache.chemistry.opencmis.session.repository.id");
            if (repositoryId == null) {
                throw new IllegalStateException("Repository ID is not set!");
            }
            this.repositoryInfo = this.objectFactory.convertRepositoryInfo(this.getBinding().getRepositoryService().getRepositoryInfo(repositoryId, null));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisBinding getBinding() {
        this.lock.readLock().lock();
        try {
            CmisBinding cmisBinding = this.binding;
            return cmisBinding;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache() {
        this.lock.readLock().lock();
        try {
            Cache cache = this.cache;
            return cache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getRepositoryId() {
        return this.getRepositoryInfo().getId();
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (CollectionsHelper.isNullOrEmpty(properties)) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createDocument(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, null, CREATE_AND_CHECKOUT_UPDATABILITY), folderId == null ? null : folderId.getId(), this.objectFactory.convertContentStream(contentStream), versioningState, this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (source == null || source.getId() == null) {
            throw new IllegalArgumentException("Source must be set!");
        }
        ObjectType type = null;
        List secondaryTypes = null;
        if (source instanceof CmisObject) {
            type = ((CmisObject)source).getType();
            secondaryTypes = ((CmisObject)source).getSecondaryTypes();
        } else {
            CmisObject sourceObj = this.getObject(source);
            type = sourceObj.getType();
            secondaryTypes = sourceObj.getSecondaryTypes();
        }
        if (type.getBaseTypeId() != BaseTypeId.CMIS_DOCUMENT) {
            throw new IllegalArgumentException("Source object must be a document!");
        }
        String newId = this.getBinding().getObjectService().createDocumentFromSource(this.getRepositoryId(), source.getId(), this.objectFactory.convertProperties(properties, type, (Collection)secondaryTypes, CREATE_AND_CHECKOUT_UPDATABILITY), folderId == null ? null : folderId.getId(), versioningState, this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (folderId == null || folderId.getId() == null) {
            throw new IllegalArgumentException("Folder ID must be set!");
        }
        if (CollectionsHelper.isNullOrEmpty(properties)) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createFolder(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, null, CREATE_UPDATABILITY), folderId.getId(), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (CollectionsHelper.isNullOrEmpty(properties)) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createPolicy(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, null, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createItem(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (CollectionsHelper.isNullOrEmpty(properties)) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createItem(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, null, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createRelationship(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (CollectionsHelper.isNullOrEmpty(properties)) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createRelationship(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, null, CREATE_UPDATABILITY), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, folderId, contentStream, versioningState, null, null, null);
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState) {
        return this.createDocumentFromSource(source, properties, folderId, versioningState, null, null, null);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId) {
        return this.createFolder(properties, folderId, null, null, null);
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId) {
        return this.createPolicy(properties, folderId, null, null, null);
    }

    public ObjectId createItem(Map<String, ?> properties, ObjectId folderId) {
        return this.createItem(properties, folderId, null, null, null);
    }

    public ObjectId createRelationship(Map<String, ?> properties) {
        return this.createRelationship(properties, null, null, null);
    }

    public ItemIterable<Relationship> getRelationships(ObjectId objectId, final boolean includeSubRelationshipTypes, final RelationshipDirection relationshipDirection, ObjectType type, OperationContext context) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object ID!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final String id = objectId.getId();
        final String typeId = type == null ? null : type.getId();
        final RelationshipService relationshipService = this.getBinding().getRelationshipService();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<Relationship>(new AbstractPageFetcher<Relationship>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<Relationship> fetchPage(long skipCount) {
                ObjectList relList = relationshipService.getObjectRelationships(SessionImpl.this.getRepositoryId(), id, Boolean.valueOf(includeSubRelationshipTypes), relationshipDirection, typeId, ctxt.getFilterString(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<Relationship> page = new ArrayList<Relationship>();
                if (relList.getObjects() != null) {
                    for (ObjectData rod : relList.getObjects()) {
                        CmisObject relationship = SessionImpl.this.getObject(rod.getId(), ctxt);
                        if (!(relationship instanceof Relationship)) {
                            throw new CmisRuntimeException("Repository returned an object that is not a relationship!");
                        }
                        page.add((Relationship)relationship);
                    }
                }
                return new AbstractPageFetcher.Page<Relationship>(page, relList.getNumItems(), relList.hasMoreItems());
            }
        });
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(List<CmisObject> objects, Map<String, ?> properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds) {
        if (this.repositoryInfo.getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        if (CollectionsHelper.isNullOrEmpty(properties)) {
            throw new IllegalArgumentException("Objects must be set!");
        }
        ObjectType objectType = null;
        HashMap<String, SecondaryType> secondaryTypes = new HashMap<String, SecondaryType>();
        if (addSecondaryTypeIds != null) {
            for (String stid : addSecondaryTypeIds) {
                ObjectType secondaryType = this.getTypeDefinition(stid);
                if (!(secondaryType instanceof SecondaryType)) {
                    throw new IllegalArgumentException("Secondary types contains a type that is not a secondary type: " + secondaryType.getId());
                }
                secondaryTypes.put(secondaryType.getId(), (SecondaryType)secondaryType);
            }
        }
        ArrayList<BulkUpdateObjectIdAndChangeTokenImpl> objectIdsAndChangeTokens = new ArrayList<BulkUpdateObjectIdAndChangeTokenImpl>();
        for (CmisObject object : objects) {
            if (object == null) continue;
            objectIdsAndChangeTokens.add(new BulkUpdateObjectIdAndChangeTokenImpl(object.getId(), object.getChangeToken()));
            if (objectType == null) {
                objectType = object.getType();
            }
            if (object.getSecondaryTypes() == null) continue;
            for (SecondaryType secondaryType : object.getSecondaryTypes()) {
                secondaryTypes.put(secondaryType.getId(), secondaryType);
            }
        }
        EnumSet<Updatability> updatebility = EnumSet.noneOf(Updatability.class);
        updatebility.add(Updatability.READWRITE);
        return this.getBinding().getObjectService().bulkUpdateProperties(this.getRepositoryId(), objectIdsAndChangeTokens, this.objectFactory.convertProperties(properties, objectType, secondaryTypes.values(), updatebility), addSecondaryTypeIds, removeSecondaryTypeIds, null);
    }

    public void delete(ObjectId objectId) {
        this.delete(objectId, true);
    }

    public void delete(ObjectId objectId, boolean allVersions) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object ID!");
        }
        this.getBinding().getObjectService().deleteObject(this.getRepositoryId(), objectId.getId(), Boolean.valueOf(allVersions), null);
        this.removeObjectFromCache(objectId);
    }

    public ContentStream getContentStream(ObjectId docId) {
        return this.getContentStream(docId, null, null, null);
    }

    public ContentStream getContentStream(ObjectId docId, String streamId, BigInteger offset, BigInteger length) {
        if (docId == null || docId.getId() == null) {
            throw new IllegalArgumentException("Invalid document ID!");
        }
        ContentStream contentStream = null;
        try {
            contentStream = this.getBinding().getObjectService().getContentStream(this.getRepositoryId(), docId.getId(), streamId, offset, length, null);
        }
        catch (CmisConstraintException e) {
            return null;
        }
        return contentStream;
    }

    public Acl getAcl(ObjectId objectId, boolean onlyBasicPermissions) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object ID!");
        }
        String id = objectId.getId();
        return this.getBinding().getAclService().getAcl(this.getRepositoryId(), id, Boolean.valueOf(onlyBasicPermissions), null);
    }

    public Acl applyAcl(ObjectId objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object ID!");
        }
        ObjectFactory of = this.getObjectFactory();
        return this.getBinding().getAclService().applyAcl(this.getRepositoryId(), objectId.getId(), of.convertAces(addAces), of.convertAces(removeAces), aclPropagation, null);
    }

    public Acl setAcl(ObjectId objectId, List<Ace> aces) {
        AclService aclService;
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object ID!");
        }
        if (aces == null) {
            aces = Collections.emptyList();
        }
        if (!((aclService = this.getBinding().getAclService()) instanceof ExtendedAclService)) {
            throw new CmisNotSupportedException("setAcl() is not supported by the binding implementation.");
        }
        ObjectFactory of = this.getObjectFactory();
        return ((ExtendedAclService)aclService).setAcl(this.getRepositoryId(), objectId.getId(), of.convertAces(aces));
    }

    public void applyPolicy(ObjectId objectId, ObjectId ... policyIds) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object ID!");
        }
        if (policyIds == null || policyIds.length == 0) {
            throw new IllegalArgumentException("No Policies provided!");
        }
        String[] ids = new String[policyIds.length];
        for (int i = 0; i < policyIds.length; ++i) {
            if (policyIds[i] == null || policyIds[i].getId() == null) {
                throw new IllegalArgumentException("A Policy ID is not set!");
            }
            ids[i] = policyIds[i].getId();
        }
        for (String id : ids) {
            this.getBinding().getPolicyService().applyPolicy(this.getRepositoryId(), id, objectId.getId(), null);
        }
    }

    public void removePolicy(ObjectId objectId, ObjectId ... policyIds) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object ID!");
        }
        if (policyIds == null || policyIds.length == 0) {
            throw new IllegalArgumentException("No Policies provided!");
        }
        String[] ids = new String[policyIds.length];
        for (int i = 0; i < policyIds.length; ++i) {
            if (policyIds[i] == null || policyIds[i].getId() == null) {
                throw new IllegalArgumentException("A Policy ID is not set!");
            }
            ids[i] = policyIds[i].getId();
        }
        for (String id : ids) {
            this.getBinding().getPolicyService().removePolicy(this.getRepositoryId(), id, objectId.getId(), null);
        }
    }

    public String toString() {
        return "Session " + this.getBinding().getSessionId();
    }

    static {
        CREATE_UPDATABILITY.add(Updatability.ONCREATE);
        CREATE_UPDATABILITY.add(Updatability.READWRITE);
        CREATE_AND_CHECKOUT_UPDATABILITY.add(Updatability.ONCREATE);
        CREATE_AND_CHECKOUT_UPDATABILITY.add(Updatability.READWRITE);
        CREATE_AND_CHECKOUT_UPDATABILITY.add(Updatability.WHENCHECKEDOUT);
    }
}

