/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.util;

import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractIterator;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionPageIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterable<T>
implements ItemIterable<T> {
    private AbstractPageFetcher<T> pageFetcher;
    private long skipCount;
    private AbstractIterator<T> iterator;

    protected AbstractIterable(AbstractPageFetcher<T> pageFetcher) {
        this(0L, pageFetcher);
    }

    protected AbstractIterable(long position, AbstractPageFetcher<T> pageFetcher) {
        this.pageFetcher = pageFetcher;
        this.skipCount = position;
    }

    protected long getSkipCount() {
        return this.skipCount;
    }

    protected AbstractPageFetcher<T> getPageFetcher() {
        return this.pageFetcher;
    }

    protected abstract AbstractIterator<T> createIterator();

    public AbstractIterator<T> iterator() {
        return this.getIterator();
    }

    public ItemIterable<T> skipTo(long position) {
        return new CollectionIterable<T>(position, this.pageFetcher);
    }

    public ItemIterable<T> getPage() {
        return new CollectionPageIterable<T>(this.skipCount, this.pageFetcher);
    }

    public ItemIterable<T> getPage(int maxNumItems) {
        this.pageFetcher.setMaxNumItems(maxNumItems);
        return new CollectionPageIterable<T>(this.skipCount, this.pageFetcher);
    }

    public long getPageNumItems() {
        return this.getIterator().getPageNumItems();
    }

    public boolean getHasMoreItems() {
        return this.getIterator().getHasMoreItems();
    }

    public long getTotalNumItems() {
        return this.getIterator().getTotalNumItems();
    }

    private AbstractIterator<T> getIterator() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator;
    }
}

