/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.apache.chemistry.opencmis.commons.data.MutableContentStream;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public final class ContentStreamUtils {
    private static final String OCTETSTREAM = "application/octet-stream";

    private ContentStreamUtils() {
    }

    public static MutableContentStream createContentStream(String filename, long length, String mimetype, InputStream stream) {
        return ContentStreamUtils.createContentStream(filename, length < 0L ? null : BigInteger.valueOf(length), mimetype, stream);
    }

    public static MutableContentStream createContentStream(String filename, BigInteger length, String mimetype, InputStream stream) {
        return new ContentStreamImpl(ContentStreamUtils.checkFilename(filename), length, ContentStreamUtils.checkMIMEType(mimetype), stream);
    }

    public static MutableContentStream createByteArrayContentStream(String filename, byte[] contentBytes) {
        return ContentStreamUtils.createByteArrayContentStream(filename, contentBytes, OCTETSTREAM);
    }

    public static MutableContentStream createByteArrayContentStream(String filename, byte[] contentBytes, String mimetype) {
        if (contentBytes == null) {
            return ContentStreamUtils.createContentStream(filename, null, mimetype, null);
        }
        return ContentStreamUtils.createByteArrayContentStream(filename, contentBytes, 0, contentBytes.length, mimetype);
    }

    public static MutableContentStream createByteArrayContentStream(String filename, byte[] contentBytes, int offset, int length, String mimetype) {
        if (contentBytes == null) {
            return ContentStreamUtils.createContentStream(filename, null, mimetype, null);
        }
        if (offset < 0 || offset > contentBytes.length) {
            throw new IndexOutOfBoundsException("Invalid offset!");
        }
        if (length < 0 || offset + length > contentBytes.length || offset + length < 0) {
            throw new IndexOutOfBoundsException("Invalid length!");
        }
        return ContentStreamUtils.createContentStream(filename, length, mimetype, (InputStream)new AutoCloseInputStream(new ByteArrayInputStream(contentBytes, offset, length)));
    }

    public static MutableContentStream createTextContentStream(String filename, String content) {
        return ContentStreamUtils.createTextContentStream(filename, content, "text/plain; charset=UTF-8");
    }

    public static MutableContentStream createTextContentStream(String filename, String content, String mimetype) {
        byte[] contentBytes = IOUtils.toUTF8Bytes((String)content);
        return ContentStreamUtils.createByteArrayContentStream(filename, contentBytes, ContentStreamUtils.checkMIMEType(mimetype));
    }

    public static MutableContentStream createFileContentStream(File file) throws FileNotFoundException {
        return ContentStreamUtils.createFileContentStream(file.getName(), file, MimeTypes.getMIMEType((File)file));
    }

    public static MutableContentStream createFileContentStream(String filename, File file) throws FileNotFoundException {
        return ContentStreamUtils.createFileContentStream(filename, file, MimeTypes.getMIMEType((File)file));
    }

    public static MutableContentStream createFileContentStream(File file, String mimetype) throws FileNotFoundException {
        return ContentStreamUtils.createFileContentStream(file.getName(), file, mimetype);
    }

    public static MutableContentStream createFileContentStream(String filename, File file, String mimetype) throws FileNotFoundException {
        return ContentStreamUtils.createContentStream(filename, file.length(), mimetype, (InputStream)new AutoCloseInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    private static String checkFilename(String filename) {
        if (filename == null || filename.length() == 0) {
            return "content";
        }
        return filename;
    }

    private static String checkMIMEType(String mimetype) {
        if (mimetype == null) {
            return OCTETSTREAM;
        }
        String result = mimetype.trim();
        if (result.length() < 3) {
            return OCTETSTREAM;
        }
        return result;
    }

    public static class AutoCloseInputStream
    extends InputStream {
        protected InputStream stream;

        public AutoCloseInputStream(InputStream in) {
            this.stream = in;
        }

        @Override
        public int read() throws IOException {
            if (this.stream != null) {
                int b = -1;
                try {
                    b = this.stream.read();
                }
                catch (IOException ioe) {
                    this.closeQuietly();
                    throw ioe;
                }
                if (b == -1) {
                    this.close();
                }
                return b;
            }
            throw new IOException("Stream is already closed!");
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.stream != null) {
                int l = -1;
                try {
                    l = this.stream.read(b);
                }
                catch (IOException ioe) {
                    this.closeQuietly();
                    throw ioe;
                }
                if (l == -1) {
                    this.close();
                }
                return l;
            }
            throw new IOException("Stream is already closed!");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.stream != null) {
                int l = -1;
                try {
                    l = this.stream.read(b, off, len);
                }
                catch (IOException ioe) {
                    this.closeQuietly();
                    throw ioe;
                }
                if (l == -1) {
                    this.close();
                }
                return l;
            }
            throw new IOException("Stream is already closed!");
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.stream != null) {
                try {
                    return this.stream.skip(n);
                }
                catch (IOException ioe) {
                    this.closeQuietly();
                    throw ioe;
                }
            }
            throw new IOException("Stream is already closed!");
        }

        @Override
        public int available() throws IOException {
            if (this.stream != null) {
                try {
                    return this.stream.available();
                }
                catch (IOException ioe) {
                    this.closeQuietly();
                    throw ioe;
                }
            }
            throw new IOException("Stream is already closed!");
        }

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                finally {
                    this.stream = null;
                }
            }
        }

        public void closeQuietly() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.stream = null;
                }
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            if (this.stream != null) {
                this.stream.mark(readlimit);
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.stream != null) {
                try {
                    this.stream.reset();
                }
                catch (IOException ioe) {
                    this.closeQuietly();
                    throw ioe;
                }
            } else {
                throw new IOException("Stream is already closed!");
            }
        }

        @Override
        public boolean markSupported() {
            if (this.stream != null) {
                return this.stream.markSupported();
            }
            return false;
        }

        protected void finalize() throws Throwable {
            this.closeQuietly();
            super.finalize();
        }
    }
}

