/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl == null) {
            return ClassLoaderUtil.loadClass(className, null);
        }
        try {
            return ClassLoaderUtil.loadClass(className, ccl);
        }
        catch (ClassNotFoundException cnf) {
            return ClassLoaderUtil.loadClass(className, null);
        }
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, classLoader);
    }
}

