/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.commons.ExtensionFeatures;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.CreatablePropertyTypes;
import org.apache.chemistry.opencmis.commons.data.ExtensionFeature;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.NewTypeSettableAttributes;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDataWithDefinition;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.PropertyHtml;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.PropertyUri;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.definitions.TypeMutability;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityOrderBy;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.enums.DateTimeResolution;
import org.apache.chemistry.opencmis.commons.enums.DecimalPrecision;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CmisEnumHelper;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.JSONConstants;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CreatablePropertyTypesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ExtensionFeatureImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ItemTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.NewTypeSettableAttributesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoBrowserBindingImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.SecondaryTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeMutabilityImpl;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public final class JSONConverter {
    private JSONConverter() {
    }

    public static JSONObject convert(RepositoryInfo repositoryInfo, String repositoryUrl, String rootUrl, boolean addExtendedDatetimeExtensionFeature) {
        JSONArray extendedFeatures;
        if (repositoryInfo == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("repositoryId", (Object)repositoryInfo.getId());
        result.put("repositoryName", (Object)repositoryInfo.getName());
        result.put("repositoryDescription", (Object)repositoryInfo.getDescription());
        result.put("vendorName", (Object)repositoryInfo.getVendorName());
        result.put("productName", (Object)repositoryInfo.getProductName());
        result.put("productVersion", (Object)repositoryInfo.getProductVersion());
        result.put("rootFolderId", (Object)repositoryInfo.getRootFolderId());
        result.put("capabilities", (Object)JSONConverter.convert(repositoryInfo.getCapabilities()));
        JSONConverter.setIfNotNull("aclCapabilities", JSONConverter.convert(repositoryInfo.getAclCapabilities()), result);
        result.put("latestChangeLogToken", (Object)repositoryInfo.getLatestChangeLogToken());
        result.put("cmisVersionSupported", (Object)repositoryInfo.getCmisVersionSupported());
        JSONConverter.setIfNotNull("thinClientURI", repositoryInfo.getThinClientUri(), result);
        JSONConverter.setIfNotNull("changesIncomplete", repositoryInfo.getChangesIncomplete(), result);
        JSONArray changesOnType = new JSONArray();
        if (repositoryInfo.getChangesOnType() != null) {
            for (BaseTypeId type : repositoryInfo.getChangesOnType()) {
                if (type == null) continue;
                changesOnType.add(JSONConverter.getJSONStringValue(type.value()));
            }
        }
        result.put("changesOnType", (Object)changesOnType);
        JSONConverter.setIfNotNull("principalIdAnonymous", repositoryInfo.getPrincipalIdAnonymous(), result);
        JSONConverter.setIfNotNull("principalIdAnyone", repositoryInfo.getPrincipalIdAnyone(), result);
        if (CollectionsHelper.isNotEmpty(repositoryInfo.getExtensionFeatures())) {
            extendedFeatures = new JSONArray();
            for (ExtensionFeature feature : repositoryInfo.getExtensionFeatures()) {
                extendedFeatures.add(JSONConverter.convert(feature));
            }
            result.put("extendedFeatures", (Object)extendedFeatures);
        }
        if (addExtendedDatetimeExtensionFeature) {
            extendedFeatures = (JSONArray)result.get("extendedFeatures");
            boolean addFeature = true;
            if (extendedFeatures == null) {
                extendedFeatures = new JSONArray();
                result.put("extendedFeatures", (Object)extendedFeatures);
            } else {
                for (Object ef : extendedFeatures) {
                    if (!(ef instanceof ExtensionFeature) || !ExtensionFeatures.EXTENDED_DATETIME_FORMAT.getId().equals(((ExtensionFeature)ef).getId())) continue;
                    addFeature = false;
                    break;
                }
            }
            if (addFeature) {
                extendedFeatures.add(JSONConverter.convert(ExtensionFeatures.EXTENDED_DATETIME_FORMAT));
            }
        }
        result.put("repositoryUrl", (Object)repositoryUrl);
        result.put("rootFolderUrl", (Object)rootUrl);
        JSONConverter.convertExtension((ExtensionsData)repositoryInfo, result);
        return result;
    }

    private static JSONObject convert(ExtensionFeature feature) {
        if (feature == null) {
            return null;
        }
        JSONObject jsonFeature = new JSONObject();
        JSONConverter.setIfNotNull("id", feature.getId(), jsonFeature);
        JSONConverter.setIfNotNull("url", feature.getUrl(), jsonFeature);
        JSONConverter.setIfNotNull("commonName", feature.getCommonName(), jsonFeature);
        JSONConverter.setIfNotNull("versionLabel", feature.getVersionLabel(), jsonFeature);
        JSONConverter.setIfNotNull("description", feature.getDescription(), jsonFeature);
        if (CollectionsHelper.isNotEmpty(feature.getFeatureData())) {
            JSONObject data = new JSONObject();
            data.putAll(feature.getFeatureData());
            jsonFeature.put("featureData", (Object)data);
        }
        JSONConverter.convertExtension((ExtensionsData)feature, jsonFeature);
        return jsonFeature;
    }

    public static JSONObject convert(RepositoryCapabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("capabilityContentStreamUpdatability", (Object)JSONConverter.getJSONEnumValue(capabilities.getContentStreamUpdatesCapability()));
        result.put("capabilityChanges", (Object)JSONConverter.getJSONEnumValue(capabilities.getChangesCapability()));
        result.put("capabilityRenditions", (Object)JSONConverter.getJSONEnumValue(capabilities.getRenditionsCapability()));
        result.put("capabilityGetDescendants", (Object)capabilities.isGetDescendantsSupported());
        result.put("capabilityGetFolderTree", (Object)capabilities.isGetFolderTreeSupported());
        result.put("capabilityMultifiling", (Object)capabilities.isMultifilingSupported());
        result.put("capabilityUnfiling", (Object)capabilities.isUnfilingSupported());
        result.put("capabilityVersionSpecificFiling", (Object)capabilities.isVersionSpecificFilingSupported());
        result.put("capabilityPWCSearchable", (Object)capabilities.isPwcSearchableSupported());
        result.put("capabilityPWCUpdatable", (Object)capabilities.isPwcUpdatableSupported());
        result.put("capabilityAllVersionsSearchable", (Object)capabilities.isAllVersionsSearchableSupported());
        result.put("capabilityOrderBy", (Object)JSONConverter.getJSONEnumValue(capabilities.getOrderByCapability()));
        result.put("capabilityQuery", (Object)JSONConverter.getJSONEnumValue(capabilities.getQueryCapability()));
        result.put("capabilityJoin", (Object)JSONConverter.getJSONEnumValue(capabilities.getJoinCapability()));
        result.put("capabilityACL", (Object)JSONConverter.getJSONEnumValue(capabilities.getAclCapability()));
        if (capabilities.getCreatablePropertyTypes() != null) {
            CreatablePropertyTypes creatablePropertyTypes = capabilities.getCreatablePropertyTypes();
            JSONObject creatablePropertyTypesJson = new JSONObject();
            if (creatablePropertyTypes.canCreate() != null) {
                JSONArray canCreate = new JSONArray();
                for (PropertyType propType : creatablePropertyTypes.canCreate()) {
                    if (propType == null) continue;
                    canCreate.add(propType.value());
                }
                creatablePropertyTypesJson.put("canCreate", (Object)canCreate);
            }
            JSONConverter.convertExtension((ExtensionsData)creatablePropertyTypes, creatablePropertyTypesJson);
            result.put("capabilityCreatablePropertyTypes", (Object)creatablePropertyTypesJson);
        }
        if (capabilities.getNewTypeSettableAttributes() != null) {
            NewTypeSettableAttributes newTypeSettableAttributes = capabilities.getNewTypeSettableAttributes();
            JSONObject newTypeSettableAttributesJson = new JSONObject();
            newTypeSettableAttributesJson.put("id", (Object)newTypeSettableAttributes.canSetId());
            newTypeSettableAttributesJson.put("localName", (Object)newTypeSettableAttributes.canSetLocalName());
            newTypeSettableAttributesJson.put("localNamespace", (Object)newTypeSettableAttributes.canSetLocalNamespace());
            newTypeSettableAttributesJson.put("displayName", (Object)newTypeSettableAttributes.canSetDisplayName());
            newTypeSettableAttributesJson.put("queryName", (Object)newTypeSettableAttributes.canSetQueryName());
            newTypeSettableAttributesJson.put("description", (Object)newTypeSettableAttributes.canSetDescription());
            newTypeSettableAttributesJson.put("creatable", (Object)newTypeSettableAttributes.canSetCreatable());
            newTypeSettableAttributesJson.put("fileable", (Object)newTypeSettableAttributes.canSetFileable());
            newTypeSettableAttributesJson.put("queryable", (Object)newTypeSettableAttributes.canSetQueryable());
            newTypeSettableAttributesJson.put("fulltextIndexed", (Object)newTypeSettableAttributes.canSetFulltextIndexed());
            newTypeSettableAttributesJson.put("includedInSupertypeQuery", (Object)newTypeSettableAttributes.canSetIncludedInSupertypeQuery());
            newTypeSettableAttributesJson.put("controllablePolicy", (Object)newTypeSettableAttributes.canSetControllablePolicy());
            newTypeSettableAttributesJson.put("controllableACL", (Object)newTypeSettableAttributes.canSetControllableAcl());
            JSONConverter.convertExtension((ExtensionsData)newTypeSettableAttributes, newTypeSettableAttributesJson);
            result.put("capabilityNewTypeSettableAttributes", (Object)newTypeSettableAttributesJson);
        }
        JSONConverter.convertExtension((ExtensionsData)capabilities, result);
        return result;
    }

    public static JSONObject convert(AclCapabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("supportedPermissions", (Object)JSONConverter.getJSONEnumValue(capabilities.getSupportedPermissions()));
        result.put("propagation", (Object)JSONConverter.getJSONEnumValue(capabilities.getAclPropagation()));
        if (capabilities.getPermissions() != null) {
            JSONArray permissions = new JSONArray();
            for (PermissionDefinition permDef : capabilities.getPermissions()) {
                JSONObject permission = new JSONObject();
                permission.put("permission", (Object)permDef.getId());
                permission.put("description", (Object)permDef.getDescription());
                permissions.add(permission);
            }
            result.put("permissions", (Object)permissions);
        }
        if (capabilities.getPermissionMapping() != null) {
            JSONArray permissionMapping = new JSONArray();
            for (PermissionMapping permMap : capabilities.getPermissionMapping().values()) {
                JSONArray mappingPermissions = new JSONArray();
                if (permMap.getPermissions() != null) {
                    for (String p : permMap.getPermissions()) {
                        mappingPermissions.add(p);
                    }
                }
                JSONObject mapping = new JSONObject();
                mapping.put("key", (Object)permMap.getKey());
                mapping.put("permission", (Object)mappingPermissions);
                permissionMapping.add(mapping);
            }
            result.put("permissionMapping", (Object)permissionMapping);
        }
        JSONConverter.convertExtension((ExtensionsData)capabilities, result);
        return result;
    }

    public static RepositoryInfo convertRepositoryInfo(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        RepositoryInfoBrowserBindingImpl result = new RepositoryInfoBrowserBindingImpl();
        result.setId(JSONConverter.getString(json, "repositoryId"));
        result.setName(JSONConverter.getString(json, "repositoryName"));
        result.setDescription(JSONConverter.getString(json, "repositoryDescription"));
        result.setVendorName(JSONConverter.getString(json, "vendorName"));
        result.setProductName(JSONConverter.getString(json, "productName"));
        result.setProductVersion(JSONConverter.getString(json, "productVersion"));
        result.setRootFolder(JSONConverter.getString(json, "rootFolderId"));
        result.setRepositoryUrl(JSONConverter.getString(json, "repositoryUrl"));
        result.setRootUrl(JSONConverter.getString(json, "rootFolderUrl"));
        result.setCapabilities(JSONConverter.convertRepositoryCapabilities(JSONConverter.getMap(json.get("capabilities"))));
        result.setAclCapabilities(JSONConverter.convertAclCapabilities(JSONConverter.getMap(json.get("aclCapabilities"))));
        result.setLatestChangeLogToken(JSONConverter.getString(json, "latestChangeLogToken"));
        result.setCmisVersionSupported(JSONConverter.getString(json, "cmisVersionSupported"));
        result.setThinClientUri(JSONConverter.getString(json, "thinClientURI"));
        result.setChangesIncomplete(JSONConverter.getBoolean(json, "changesIncomplete"));
        List<Object> changesOnType = JSONConverter.getList(json.get("changesOnType"));
        if (changesOnType != null) {
            ArrayList<BaseTypeId> types = new ArrayList<BaseTypeId>();
            for (Object type : changesOnType) {
                if (type == null) continue;
                types.add(BaseTypeId.fromValue((String)type.toString()));
            }
            result.setChangesOnType(types);
        }
        result.setPrincipalAnonymous(JSONConverter.getString(json, "principalIdAnonymous"));
        result.setPrincipalAnyone(JSONConverter.getString(json, "principalIdAnyone"));
        List<Object> extendedFeatures = JSONConverter.getList(json.get("extendedFeatures"));
        if (extendedFeatures != null) {
            ArrayList<ExtensionFeature> features = new ArrayList<ExtensionFeature>();
            for (Object extendedFeature : extendedFeatures) {
                Map<String, Object> jsonFeature = JSONConverter.getMap(extendedFeature);
                ExtensionFeatureImpl feature = new ExtensionFeatureImpl();
                feature.setId(JSONConverter.getString(jsonFeature, "id"));
                feature.setUrl(JSONConverter.getString(jsonFeature, "url"));
                feature.setCommonName(JSONConverter.getString(jsonFeature, "commonName"));
                feature.setVersionLabel(JSONConverter.getString(jsonFeature, "versionLabel"));
                feature.setDescription(JSONConverter.getString(jsonFeature, "description"));
                Map<String, Object> data = JSONConverter.getMap(jsonFeature.get("featureData"));
                if (data != null) {
                    LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
                    for (Map.Entry<String, Object> e : data.entrySet()) {
                        dataMap.put(e.getKey(), e.getValue() == null ? null : e.getValue().toString());
                    }
                    if (!dataMap.isEmpty()) {
                        feature.setFeatureData(dataMap);
                    }
                }
                JSONConverter.convertExtension(jsonFeature, feature, JSONConstants.FEATURE_KEYS);
                features.add(feature);
            }
            if (!features.isEmpty()) {
                result.setExtensionFeature(features);
            }
        }
        JSONConverter.convertExtension(json, result, JSONConstants.REPINFO_KEYS);
        return result;
    }

    public static RepositoryCapabilities convertRepositoryCapabilities(Map<String, Object> json) {
        Map<String, Object> newTypeSettableAttributesJson;
        if (json == null) {
            return null;
        }
        RepositoryCapabilitiesImpl result = new RepositoryCapabilitiesImpl();
        result.setCapabilityContentStreamUpdates(JSONConverter.getEnum(json, "capabilityContentStreamUpdatability", CapabilityContentStreamUpdates.class));
        result.setCapabilityChanges(JSONConverter.getEnum(json, "capabilityChanges", CapabilityChanges.class));
        result.setCapabilityRendition(JSONConverter.getEnum(json, "capabilityRenditions", CapabilityRenditions.class));
        result.setSupportsGetDescendants(JSONConverter.getBoolean(json, "capabilityGetDescendants"));
        result.setSupportsGetFolderTree(JSONConverter.getBoolean(json, "capabilityGetFolderTree"));
        result.setSupportsMultifiling(JSONConverter.getBoolean(json, "capabilityMultifiling"));
        result.setSupportsUnfiling(JSONConverter.getBoolean(json, "capabilityUnfiling"));
        result.setSupportsVersionSpecificFiling(JSONConverter.getBoolean(json, "capabilityVersionSpecificFiling"));
        result.setIsPwcSearchable(JSONConverter.getBoolean(json, "capabilityPWCSearchable"));
        result.setIsPwcUpdatable(JSONConverter.getBoolean(json, "capabilityPWCUpdatable"));
        result.setAllVersionsSearchable(JSONConverter.getBoolean(json, "capabilityAllVersionsSearchable"));
        result.setCapabilityOrderBy(JSONConverter.getEnum(json, "capabilityOrderBy", CapabilityOrderBy.class));
        result.setCapabilityQuery(JSONConverter.getEnum(json, "capabilityQuery", CapabilityQuery.class));
        result.setCapabilityJoin(JSONConverter.getEnum(json, "capabilityJoin", CapabilityJoin.class));
        result.setCapabilityAcl(JSONConverter.getEnum(json, "capabilityACL", CapabilityAcl.class));
        Map<String, Object> creatablePropertyTypesJson = JSONConverter.getMap(json.get("capabilityCreatablePropertyTypes"));
        if (creatablePropertyTypesJson != null) {
            CreatablePropertyTypesImpl creatablePropertyTypes = new CreatablePropertyTypesImpl();
            List<Object> canCreateJson = JSONConverter.getList(creatablePropertyTypesJson.get("canCreate"));
            if (canCreateJson != null) {
                EnumSet<PropertyType> canCreate = EnumSet.noneOf(PropertyType.class);
                for (Object o : canCreateJson) {
                    try {
                        if (o == null) continue;
                        canCreate.add(PropertyType.fromValue((String)o.toString()));
                    }
                    catch (Exception e) {}
                }
                creatablePropertyTypes.setCanCreate(canCreate);
            }
            JSONConverter.convertExtension(creatablePropertyTypesJson, creatablePropertyTypes, JSONConstants.CAP_CREATABLE_PROPERTY_TYPES_KEYS);
            result.setCreatablePropertyTypes(creatablePropertyTypes);
        }
        if ((newTypeSettableAttributesJson = JSONConverter.getMap(json.get("capabilityNewTypeSettableAttributes"))) != null) {
            NewTypeSettableAttributesImpl newTypeSettableAttributes = new NewTypeSettableAttributesImpl();
            newTypeSettableAttributes.setCanSetId(JSONConverter.getBoolean(newTypeSettableAttributesJson, "id"));
            newTypeSettableAttributes.setCanSetLocalName(JSONConverter.getBoolean(newTypeSettableAttributesJson, "localName"));
            newTypeSettableAttributes.setCanSetLocalNamespace(JSONConverter.getBoolean(newTypeSettableAttributesJson, "localNamespace"));
            newTypeSettableAttributes.setCanSetDisplayName(JSONConverter.getBoolean(newTypeSettableAttributesJson, "displayName"));
            newTypeSettableAttributes.setCanSetQueryName(JSONConverter.getBoolean(newTypeSettableAttributesJson, "queryName"));
            newTypeSettableAttributes.setCanSetDescription(JSONConverter.getBoolean(newTypeSettableAttributesJson, "description"));
            newTypeSettableAttributes.setCanSetCreatable(JSONConverter.getBoolean(newTypeSettableAttributesJson, "creatable"));
            newTypeSettableAttributes.setCanSetFileable(JSONConverter.getBoolean(newTypeSettableAttributesJson, "fileable"));
            newTypeSettableAttributes.setCanSetQueryable(JSONConverter.getBoolean(newTypeSettableAttributesJson, "queryable"));
            newTypeSettableAttributes.setCanSetFulltextIndexed(JSONConverter.getBoolean(newTypeSettableAttributesJson, "fulltextIndexed"));
            newTypeSettableAttributes.setCanSetIncludedInSupertypeQuery(JSONConverter.getBoolean(newTypeSettableAttributesJson, "includedInSupertypeQuery"));
            newTypeSettableAttributes.setCanSetControllablePolicy(JSONConverter.getBoolean(newTypeSettableAttributesJson, "controllablePolicy"));
            newTypeSettableAttributes.setCanSetControllableAcl(JSONConverter.getBoolean(newTypeSettableAttributesJson, "controllableACL"));
            JSONConverter.convertExtension(newTypeSettableAttributesJson, newTypeSettableAttributes, JSONConstants.CAP_NEW_TYPE_SETTABLE_ATTRIBUTES_KEYS);
            result.setNewTypeSettableAttributes(newTypeSettableAttributes);
        }
        JSONConverter.convertExtension(json, result, JSONConstants.CAP_KEYS);
        return result;
    }

    public static AclCapabilities convertAclCapabilities(Map<String, Object> json) {
        List<Object> permissionMapping;
        if (json == null) {
            return null;
        }
        AclCapabilitiesDataImpl result = new AclCapabilitiesDataImpl();
        result.setSupportedPermissions(JSONConverter.getEnum(json, "supportedPermissions", SupportedPermissions.class));
        result.setAclPropagation(JSONConverter.getEnum(json, "propagation", AclPropagation.class));
        List<Object> permissions = JSONConverter.getList(json.get("permissions"));
        if (permissions != null) {
            ArrayList<PermissionDefinition> permissionDefinitionList = new ArrayList<PermissionDefinition>();
            for (Object permission : permissions) {
                Map<String, Object> permissionMap = JSONConverter.getMap(permission);
                if (permissionMap == null) continue;
                PermissionDefinitionDataImpl permDef = new PermissionDefinitionDataImpl();
                permDef.setId(JSONConverter.getString(permissionMap, "permission"));
                permDef.setDescription(JSONConverter.getString(permissionMap, "description"));
                JSONConverter.convertExtension(permissionMap, permDef, JSONConstants.ACLCAP_PERMISSION_KEYS);
                permissionDefinitionList.add(permDef);
            }
            result.setPermissionDefinitionData(permissionDefinitionList);
        }
        if ((permissionMapping = JSONConverter.getList(json.get("permissionMapping"))) != null) {
            HashMap<String, PermissionMapping> permMap = new HashMap<String, PermissionMapping>();
            for (Object permission : permissionMapping) {
                Map<String, Object> permissionMap = JSONConverter.getMap(permission);
                if (permissionMap == null) continue;
                PermissionMappingDataImpl mapping = new PermissionMappingDataImpl();
                String key = JSONConverter.getString(permissionMap, "key");
                mapping.setKey(key);
                Object perms = permissionMap.get("permission");
                if (perms instanceof List) {
                    ArrayList<String> permList = new ArrayList<String>();
                    for (Object perm : (List)perms) {
                        if (perm == null) continue;
                        permList.add(perm.toString());
                    }
                    mapping.setPermissions(permList);
                }
                JSONConverter.convertExtension(permissionMap, mapping, JSONConstants.ACLCAP_MAPPING_KEYS);
                permMap.put(key, mapping);
            }
            result.setPermissionMappingData(permMap);
        }
        JSONConverter.convertExtension(json, result, JSONConstants.ACLCAP_KEYS);
        return result;
    }

    public static TypeDefinition convertTypeDefinition(Map<String, Object> json) {
        Map<String, Object> propertyDefinitions;
        if (json == null) {
            return null;
        }
        AbstractTypeDefinition result = null;
        String id = JSONConverter.getString(json, "id");
        BaseTypeId baseType = JSONConverter.getEnum(json, "baseId", BaseTypeId.class);
        if (baseType == null) {
            throw new CmisInvalidArgumentException("Invalid base type: " + id);
        }
        switch (baseType) {
            case CMIS_FOLDER: {
                result = new FolderTypeDefinitionImpl();
                break;
            }
            case CMIS_DOCUMENT: {
                result = new DocumentTypeDefinitionImpl();
                ((DocumentTypeDefinitionImpl)result).setContentStreamAllowed(JSONConverter.getEnum(json, "contentStreamAllowed", ContentStreamAllowed.class));
                ((DocumentTypeDefinitionImpl)result).setIsVersionable(JSONConverter.getBoolean(json, "versionable"));
                break;
            }
            case CMIS_RELATIONSHIP: {
                Object allowedTargetTypes;
                result = new RelationshipTypeDefinitionImpl();
                Object allowedSourceTypes = json.get("allowedSourceTypes");
                if (allowedSourceTypes instanceof List) {
                    ArrayList<String> types = new ArrayList<String>();
                    for (Object type : (List)allowedSourceTypes) {
                        if (type == null) continue;
                        types.add(type.toString());
                    }
                    ((RelationshipTypeDefinitionImpl)result).setAllowedSourceTypes(types);
                }
                if (!((allowedTargetTypes = json.get("allowedTargetTypes")) instanceof List)) break;
                ArrayList<String> types = new ArrayList<String>();
                for (Object type : (List)allowedTargetTypes) {
                    if (type == null) continue;
                    types.add(type.toString());
                }
                ((RelationshipTypeDefinitionImpl)result).setAllowedTargetTypes(types);
                break;
            }
            case CMIS_POLICY: {
                result = new PolicyTypeDefinitionImpl();
                break;
            }
            case CMIS_ITEM: {
                result = new ItemTypeDefinitionImpl();
                break;
            }
            case CMIS_SECONDARY: {
                result = new SecondaryTypeDefinitionImpl();
                break;
            }
            default: {
                throw new CmisRuntimeException("Type '" + id + "' does not match a base type!");
            }
        }
        result.setBaseTypeId(baseType);
        result.setDescription(JSONConverter.getString(json, "description"));
        result.setDisplayName(JSONConverter.getString(json, "displayName"));
        result.setId(id);
        result.setIsControllableAcl(JSONConverter.getBoolean(json, "controllableACL"));
        result.setIsControllablePolicy(JSONConverter.getBoolean(json, "controllablePolicy"));
        result.setIsCreatable(JSONConverter.getBoolean(json, "creatable"));
        result.setIsFileable(JSONConverter.getBoolean(json, "fileable"));
        result.setIsFulltextIndexed(JSONConverter.getBoolean(json, "fulltextIndexed"));
        result.setIsIncludedInSupertypeQuery(JSONConverter.getBoolean(json, "includedInSupertypeQuery"));
        result.setIsQueryable(JSONConverter.getBoolean(json, "queryable"));
        result.setLocalName(JSONConverter.getString(json, "localName"));
        result.setLocalNamespace(JSONConverter.getString(json, "localNamespace"));
        result.setParentTypeId(JSONConverter.getString(json, "parentId"));
        result.setQueryName(JSONConverter.getString(json, "queryName"));
        Map<String, Object> typeMutabilityJson = JSONConverter.getMap(json.get("typeMutability"));
        if (typeMutabilityJson != null) {
            TypeMutabilityImpl typeMutability = new TypeMutabilityImpl();
            typeMutability.setCanCreate(JSONConverter.getBoolean(typeMutabilityJson, "create"));
            typeMutability.setCanUpdate(JSONConverter.getBoolean(typeMutabilityJson, "update"));
            typeMutability.setCanDelete(JSONConverter.getBoolean(typeMutabilityJson, "delete"));
            JSONConverter.convertExtension(typeMutabilityJson, typeMutability, JSONConstants.JSON_TYPE_TYPE_MUTABILITY_KEYS);
            result.setTypeMutability(typeMutability);
        }
        if ((propertyDefinitions = JSONConverter.getMap(json.get("propertyDefinitions"))) != null) {
            for (Object propDef : propertyDefinitions.values()) {
                result.addPropertyDefinition(JSONConverter.convertPropertyDefinition(JSONConverter.getMap(propDef)));
            }
        }
        JSONConverter.convertExtension(json, result, JSONConstants.TYPE_KEYS);
        return result;
    }

    public static PropertyDefinition<?> convertPropertyDefinition(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        AbstractPropertyDefinition result = null;
        String id = JSONConverter.getString(json, "id");
        PropertyType propertyType = JSONConverter.getEnum(json, "propertyType", PropertyType.class);
        if (propertyType == null) {
            throw new CmisRuntimeException("Invalid property type '" + id + "'! Data type not set!");
        }
        Cardinality cardinality = JSONConverter.getEnum(json, "cardinality", Cardinality.class);
        if (cardinality == null) {
            throw new CmisRuntimeException("Invalid property type '" + id + "'! Cardinality not set!");
        }
        switch (propertyType) {
            case STRING: {
                result = new PropertyStringDefinitionImpl();
                ((PropertyStringDefinitionImpl)result).setMaxLength(JSONConverter.getInteger(json, "maxLength"));
                ((PropertyStringDefinitionImpl)result).setChoices(JSONConverter.convertChoicesString(json.get("choice")));
                break;
            }
            case ID: {
                result = new PropertyIdDefinitionImpl();
                ((PropertyIdDefinitionImpl)result).setChoices(JSONConverter.convertChoicesString(json.get("choice")));
                break;
            }
            case BOOLEAN: {
                result = new PropertyBooleanDefinitionImpl();
                ((PropertyBooleanDefinitionImpl)result).setChoices(JSONConverter.convertChoicesBoolean(json.get("choice")));
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerDefinitionImpl();
                ((PropertyIntegerDefinitionImpl)result).setMinValue(JSONConverter.getInteger(json, "minValue"));
                ((PropertyIntegerDefinitionImpl)result).setMaxValue(JSONConverter.getInteger(json, "maxValue"));
                ((PropertyIntegerDefinitionImpl)result).setChoices(JSONConverter.convertChoicesInteger(json.get("choice")));
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeDefinitionImpl();
                ((PropertyDateTimeDefinitionImpl)result).setDateTimeResolution(JSONConverter.getEnum(json, "resolution", DateTimeResolution.class));
                ((PropertyDateTimeDefinitionImpl)result).setChoices(JSONConverter.convertChoicesDateTime(json.get("choice")));
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalDefinitionImpl();
                ((PropertyDecimalDefinitionImpl)result).setMinValue(JSONConverter.getDecimal(json, "minValue"));
                ((PropertyDecimalDefinitionImpl)result).setMaxValue(JSONConverter.getDecimal(json, "maxValue"));
                ((PropertyDecimalDefinitionImpl)result).setPrecision(JSONConverter.getIntEnum(json, "precision", DecimalPrecision.class));
                ((PropertyDecimalDefinitionImpl)result).setChoices(JSONConverter.convertChoicesDecimal(json.get("choice")));
                break;
            }
            case HTML: {
                result = new PropertyHtmlDefinitionImpl();
                ((PropertyHtmlDefinitionImpl)result).setChoices(JSONConverter.convertChoicesString(json.get("choice")));
                break;
            }
            case URI: {
                result = new PropertyUriDefinitionImpl();
                ((PropertyUriDefinitionImpl)result).setChoices(JSONConverter.convertChoicesString(json.get("choice")));
                break;
            }
            default: {
                throw new CmisRuntimeException("Property type '" + id + "' does not match a data type!");
            }
        }
        Object defaultValue = json.get("defaultValue");
        if (defaultValue != null) {
            if (defaultValue instanceof List) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object value : (List)defaultValue) {
                    values.add(JSONConverter.getCMISValue(value, propertyType));
                }
                result.setDefaultValue(values);
            } else {
                result.setDefaultValue(Collections.singletonList(JSONConverter.getCMISValue(defaultValue, propertyType)));
            }
        }
        result.setId(id);
        result.setPropertyType(propertyType);
        result.setCardinality(cardinality);
        result.setLocalName(JSONConverter.getString(json, "localName"));
        result.setLocalNamespace(JSONConverter.getString(json, "localNamespace"));
        result.setQueryName(JSONConverter.getString(json, "queryName"));
        result.setDescription(JSONConverter.getString(json, "description"));
        result.setDisplayName(JSONConverter.getString(json, "displayName"));
        result.setIsInherited(JSONConverter.getBoolean(json, "inherited"));
        result.setIsOpenChoice(JSONConverter.getBoolean(json, "openChoice"));
        result.setIsOrderable(JSONConverter.getBoolean(json, "orderable"));
        result.setIsQueryable(JSONConverter.getBoolean(json, "queryable"));
        result.setIsRequired(JSONConverter.getBoolean(json, "required"));
        result.setUpdatability(JSONConverter.getEnum(json, "updatability", Updatability.class));
        JSONConverter.convertExtension(json, result, JSONConstants.PROPERTY_TYPE_KEYS);
        return result;
    }

    private static List<Choice<String>> convertChoicesString(Object choices) {
        if (!(choices instanceof List)) {
            return null;
        }
        ArrayList<Choice<String>> result = new ArrayList<Choice<String>>();
        for (Object obj : (List)choices) {
            Map<String, Object> choiceMap = JSONConverter.getMap(obj);
            if (choiceMap == null) continue;
            ChoiceImpl<ArrayList<Object>> choice = new ChoiceImpl<ArrayList<Object>>();
            choice.setDisplayName(JSONConverter.getString(choiceMap, "displayName"));
            Object choiceValue = choiceMap.get("value");
            ArrayList<String> values = new ArrayList<String>();
            if (choiceValue instanceof List) {
                for (Object value : (List)choiceValue) {
                    values.add((String)JSONConverter.getCMISValue(value, PropertyType.STRING));
                }
            } else {
                values.add((String)JSONConverter.getCMISValue(choiceValue, PropertyType.STRING));
            }
            choice.setValue(values);
            choice.setChoice(JSONConverter.convertChoicesString(choiceMap.get("choice")));
            result.add(choice);
        }
        return result;
    }

    private static List<Choice<Boolean>> convertChoicesBoolean(Object choices) {
        if (!(choices instanceof List)) {
            return null;
        }
        ArrayList<Choice<Boolean>> result = new ArrayList<Choice<Boolean>>();
        for (Object obj : (List)choices) {
            Map<String, Object> choiceMap = JSONConverter.getMap(obj);
            if (choiceMap == null) continue;
            ChoiceImpl<ArrayList<Object>> choice = new ChoiceImpl<ArrayList<Object>>();
            choice.setDisplayName(JSONConverter.getString(choiceMap, "displayName"));
            Object choiceValue = choiceMap.get("value");
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            if (choiceValue instanceof List) {
                for (Object value : (List)choiceValue) {
                    values.add((Boolean)JSONConverter.getCMISValue(value, PropertyType.BOOLEAN));
                }
            } else {
                values.add((Boolean)JSONConverter.getCMISValue(choiceValue, PropertyType.BOOLEAN));
            }
            choice.setValue(values);
            choice.setChoice(JSONConverter.convertChoicesBoolean(choiceMap.get("choice")));
            result.add(choice);
        }
        return result;
    }

    private static List<Choice<BigInteger>> convertChoicesInteger(Object choices) {
        if (!(choices instanceof List)) {
            return null;
        }
        ArrayList<Choice<BigInteger>> result = new ArrayList<Choice<BigInteger>>();
        for (Object obj : (List)choices) {
            Map<String, Object> choiceMap = JSONConverter.getMap(obj);
            if (choiceMap == null) continue;
            ChoiceImpl<ArrayList<Object>> choice = new ChoiceImpl<ArrayList<Object>>();
            choice.setDisplayName(JSONConverter.getString(choiceMap, "displayName"));
            Object choiceValue = choiceMap.get("value");
            ArrayList<BigInteger> values = new ArrayList<BigInteger>();
            if (choiceValue instanceof List) {
                for (Object value : (List)choiceValue) {
                    values.add((BigInteger)JSONConverter.getCMISValue(value, PropertyType.INTEGER));
                }
            } else {
                values.add((BigInteger)JSONConverter.getCMISValue(choiceValue, PropertyType.INTEGER));
            }
            choice.setValue(values);
            choice.setChoice(JSONConverter.convertChoicesInteger(choiceMap.get("choice")));
            result.add(choice);
        }
        return result;
    }

    private static List<Choice<BigDecimal>> convertChoicesDecimal(Object choices) {
        if (!(choices instanceof List)) {
            return null;
        }
        ArrayList<Choice<BigDecimal>> result = new ArrayList<Choice<BigDecimal>>();
        for (Object obj : (List)choices) {
            Map<String, Object> choiceMap = JSONConverter.getMap(obj);
            if (choiceMap == null) continue;
            ChoiceImpl<ArrayList<Object>> choice = new ChoiceImpl<ArrayList<Object>>();
            choice.setDisplayName(JSONConverter.getString(choiceMap, "displayName"));
            Object choiceValue = choiceMap.get("value");
            ArrayList<BigDecimal> values = new ArrayList<BigDecimal>();
            if (choiceValue instanceof List) {
                for (Object value : (List)choiceValue) {
                    values.add((BigDecimal)JSONConverter.getCMISValue(value, PropertyType.DECIMAL));
                }
            } else {
                values.add((BigDecimal)JSONConverter.getCMISValue(choiceValue, PropertyType.DECIMAL));
            }
            choice.setValue(values);
            choice.setChoice(JSONConverter.convertChoicesDecimal(choiceMap.get("choice")));
            result.add(choice);
        }
        return result;
    }

    private static List<Choice<GregorianCalendar>> convertChoicesDateTime(Object choices) {
        if (!(choices instanceof List)) {
            return null;
        }
        ArrayList<Choice<GregorianCalendar>> result = new ArrayList<Choice<GregorianCalendar>>();
        for (Object obj : (List)choices) {
            Map<String, Object> choiceMap = JSONConverter.getMap(obj);
            if (choiceMap == null) continue;
            ChoiceImpl<ArrayList<Object>> choice = new ChoiceImpl<ArrayList<Object>>();
            choice.setDisplayName(JSONConverter.getString(choiceMap, "displayName"));
            Object choiceValue = choiceMap.get("value");
            ArrayList<GregorianCalendar> values = new ArrayList<GregorianCalendar>();
            if (choiceValue instanceof List) {
                for (Object value : (List)choiceValue) {
                    values.add((GregorianCalendar)JSONConverter.getCMISValue(value, PropertyType.DATETIME));
                }
            } else {
                values.add((GregorianCalendar)JSONConverter.getCMISValue(choiceValue, PropertyType.DATETIME));
            }
            choice.setValue(values);
            choice.setChoice(JSONConverter.convertChoicesDateTime(choiceMap.get("choice")));
            result.add(choice);
        }
        return result;
    }

    public static JSONObject convert(ObjectData object, TypeCache typeCache, PropertyMode propertyMode, boolean succinct, DateTimeFormat dateTimeFormat) {
        if (object == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        if (object.getProperties() != null) {
            JSONObject properties;
            if (succinct) {
                properties = JSONConverter.convert(object.getProperties(), object.getId(), typeCache, propertyMode, true, dateTimeFormat);
                if (properties != null) {
                    result.put("succinctProperties", (Object)properties);
                }
            } else {
                properties = JSONConverter.convert(object.getProperties(), object.getId(), typeCache, propertyMode, false, dateTimeFormat);
                if (properties != null) {
                    result.put("properties", (Object)properties);
                }
            }
            JSONObject propertiesExtension = new JSONObject();
            JSONConverter.convertExtension((ExtensionsData)object.getProperties(), propertiesExtension);
            if (!propertiesExtension.isEmpty()) {
                result.put("propertiesExtension", (Object)propertiesExtension);
            }
        }
        if (object.getAllowableActions() != null) {
            result.put("allowableActions", (Object)JSONConverter.convert(object.getAllowableActions()));
        }
        if (CollectionsHelper.isNotEmpty(object.getRelationships())) {
            JSONArray relationships = new JSONArray();
            for (ObjectData relationship : object.getRelationships()) {
                relationships.add(JSONConverter.convert(relationship, typeCache, propertyMode, succinct, dateTimeFormat));
            }
            result.put("relationships", (Object)relationships);
        }
        if (object.getChangeEventInfo() != null && propertyMode == PropertyMode.CHANGE) {
            JSONObject changeEventInfo = new JSONObject();
            ChangeEventInfo cei = object.getChangeEventInfo();
            changeEventInfo.put("changeType", (Object)JSONConverter.getJSONEnumValue(cei.getChangeType()));
            changeEventInfo.put("changeTime", JSONConverter.getJSONValue(cei.getChangeTime(), dateTimeFormat));
            JSONConverter.convertExtension((ExtensionsData)object.getChangeEventInfo(), changeEventInfo);
            result.put("changeEventInfo", (Object)changeEventInfo);
        }
        if (object.getAcl() != null && object.getAcl().getAces() != null && propertyMode != PropertyMode.QUERY) {
            result.put("acl", (Object)JSONConverter.convert(object.getAcl()));
        }
        JSONConverter.setIfNotNull("exactACL", object.isExactAcl(), result);
        if (object.getPolicyIds() != null && object.getPolicyIds().getPolicyIds() != null && propertyMode != PropertyMode.QUERY) {
            JSONObject policyIds = new JSONObject();
            JSONArray ids = new JSONArray();
            policyIds.put("ids", (Object)ids);
            for (String pi : object.getPolicyIds().getPolicyIds()) {
                ids.add(pi);
            }
            JSONConverter.convertExtension((ExtensionsData)object.getPolicyIds(), policyIds);
            result.put("policyIds", (Object)policyIds);
        }
        if (CollectionsHelper.isNotEmpty(object.getRenditions())) {
            JSONArray renditions = new JSONArray();
            for (RenditionData rendition : object.getRenditions()) {
                renditions.add(JSONConverter.convert(rendition));
            }
            result.put("renditions", (Object)renditions);
        }
        JSONConverter.convertExtension((ExtensionsData)object, result);
        return result;
    }

    public static JSONObject convert(Properties properties, String objectId, TypeCache typeCache, PropertyMode propertyMode, boolean succinct, DateTimeFormat dateTimeFormat) {
        String typeId;
        PropertyData typeProp;
        if (properties == null) {
            return null;
        }
        TypeDefinition type = null;
        if (typeCache != null && (typeProp = (PropertyData)properties.getProperties().get("cmis:objectTypeId")) instanceof PropertyId && (typeId = (String)((PropertyId)typeProp).getFirstValue()) != null) {
            type = typeCache.getTypeDefinition(typeId);
        }
        JSONObject result = new JSONObject();
        for (PropertyData property : properties.getPropertyList()) {
            String propId;
            assert (property != null);
            assert (property.getId() != null);
            PropertyDefinition<?> propDef = null;
            if (property instanceof PropertyDataWithDefinition) {
                propDef = ((PropertyDataWithDefinition)property).getPropertyDefinition();
            }
            if (propDef == null && typeCache != null) {
                propDef = typeCache.getPropertyDefinition(property.getId());
            }
            if (propDef == null && type != null) {
                propDef = (PropertyDefinition<?>)type.getPropertyDefinitions().get(property.getId());
            }
            if (propDef == null && typeCache != null && objectId != null && propertyMode != PropertyMode.CHANGE) {
                typeCache.getTypeDefinitionForObject(objectId);
                propDef = typeCache.getPropertyDefinition(property.getId());
            }
            String string = propId = propertyMode == PropertyMode.QUERY ? property.getQueryName() : property.getId();
            if (propId == null) {
                throw new CmisRuntimeException("No query name or alias for property '" + property.getId() + "'!");
            }
            result.put(propId, JSONConverter.convert(property, propDef, succinct, dateTimeFormat));
        }
        return result;
    }

    public static Object convert(PropertyData<?> property, PropertyDefinition<?> propDef, boolean succinct, DateTimeFormat dateTimeFormat) {
        if (property == null) {
            return null;
        }
        if (succinct) {
            Object result = null;
            if (propDef != null) {
                if (CollectionsHelper.isNullOrEmpty(property.getValues())) {
                    result = null;
                } else if (propDef.getCardinality() == Cardinality.SINGLE) {
                    result = JSONConverter.getJSONValue(property.getValues().get(0), dateTimeFormat);
                } else {
                    JSONArray values = new JSONArray();
                    for (Object value : property.getValues()) {
                        values.add(JSONConverter.getJSONValue(value, dateTimeFormat));
                    }
                    result = values;
                }
            } else if (CollectionsHelper.isNullOrEmpty(property.getValues())) {
                result = null;
            } else {
                JSONArray values = new JSONArray();
                for (Object value : property.getValues()) {
                    values.add(JSONConverter.getJSONValue(value, dateTimeFormat));
                }
                result = values;
            }
            return result;
        }
        JSONObject result = new JSONObject();
        result.put("id", (Object)property.getId());
        JSONConverter.setIfNotNull("localName", property.getLocalName(), result);
        JSONConverter.setIfNotNull("displayName", property.getDisplayName(), result);
        JSONConverter.setIfNotNull("queryName", property.getQueryName(), result);
        if (propDef != null) {
            result.put("type", (Object)JSONConverter.getJSONEnumValue(propDef.getPropertyType()));
            result.put("cardinality", (Object)JSONConverter.getJSONEnumValue(propDef.getCardinality()));
            if (CollectionsHelper.isNullOrEmpty(property.getValues())) {
                result.put("value", (Object)null);
            } else if (propDef.getCardinality() == Cardinality.SINGLE) {
                result.put("value", JSONConverter.getJSONValue(property.getValues().get(0), dateTimeFormat));
            } else {
                JSONArray values = new JSONArray();
                for (Object value : property.getValues()) {
                    values.add(JSONConverter.getJSONValue(value, dateTimeFormat));
                }
                result.put("value", (Object)values);
            }
        } else {
            result.put("type", (Object)JSONConverter.getJSONPropertyDataType(property));
            if (CollectionsHelper.isNullOrEmpty(property.getValues())) {
                result.put("value", (Object)null);
            } else {
                JSONArray values = new JSONArray();
                for (Object value : property.getValues()) {
                    values.add(JSONConverter.getJSONValue(value, dateTimeFormat));
                }
                result.put("value", (Object)values);
            }
        }
        JSONConverter.convertExtension(property, result);
        return result;
    }

    public static JSONObject convert(AllowableActions allowableActions) {
        if (allowableActions == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        Set actionSet = allowableActions.getAllowableActions();
        for (Action action : Action.values()) {
            result.put(action.value(), (Object)actionSet.contains(action));
        }
        JSONConverter.convertExtension((ExtensionsData)allowableActions, result);
        return result;
    }

    public static JSONObject convert(Acl acl) {
        if (acl == null || acl.getAces() == null) {
            return null;
        }
        JSONArray aceObjects = new JSONArray();
        for (Ace ace : acl.getAces()) {
            JSONArray permissions = new JSONArray();
            if (ace.getPermissions() != null) {
                for (String p : ace.getPermissions()) {
                    permissions.add(p);
                }
            }
            JSONObject aceObject = new JSONObject();
            JSONObject principalObject = new JSONObject();
            principalObject.put("principalId", (Object)ace.getPrincipalId());
            JSONConverter.convertExtension((ExtensionsData)ace.getPrincipal(), principalObject);
            aceObject.put("principal", (Object)principalObject);
            aceObject.put("permissions", (Object)permissions);
            aceObject.put("isDirect", (Object)ace.isDirect());
            JSONConverter.convertExtension((ExtensionsData)ace, aceObject);
            aceObjects.add(aceObject);
        }
        JSONObject result = new JSONObject();
        result.put("aces", (Object)aceObjects);
        JSONConverter.setIfNotNull("isExact", acl.isExact(), result);
        JSONConverter.convertExtension((ExtensionsData)acl, result);
        return result;
    }

    public static JSONObject convert(RenditionData rendition) {
        if (rendition == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("streamId", (Object)rendition.getStreamId());
        result.put("mimeType", (Object)rendition.getMimeType());
        result.put("length", (Object)rendition.getBigLength());
        result.put("kind", (Object)rendition.getKind());
        JSONConverter.setIfNotNull("title", rendition.getTitle(), result);
        JSONConverter.setIfNotNull("height", rendition.getBigHeight(), result);
        JSONConverter.setIfNotNull("width", rendition.getBigWidth(), result);
        JSONConverter.setIfNotNull("renditionDocumentId", rendition.getRenditionDocumentId(), result);
        JSONConverter.convertExtension((ExtensionsData)rendition, result);
        return result;
    }

    public static JSONObject convert(ObjectList list, TypeCache typeCache, PropertyMode propertyMode, boolean succinct, DateTimeFormat dateTimeFormat) {
        if (list == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        JSONArray objects = new JSONArray();
        if (list.getObjects() != null) {
            for (ObjectData object : list.getObjects()) {
                objects.add(JSONConverter.convert(object, typeCache, propertyMode, succinct, dateTimeFormat));
            }
        }
        if (propertyMode == PropertyMode.QUERY) {
            result.put("results", (Object)objects);
            JSONConverter.setIfNotNull("hasMoreItems", list.hasMoreItems(), result);
            JSONConverter.setIfNotNull("numItems", list.getNumItems(), result);
        } else {
            result.put("objects", (Object)objects);
            JSONConverter.setIfNotNull("hasMoreItems", list.hasMoreItems(), result);
            JSONConverter.setIfNotNull("numItems", list.getNumItems(), result);
        }
        JSONConverter.convertExtension((ExtensionsData)list, result);
        return result;
    }

    public static JSONObject convert(ObjectInFolderData objectInFolder, TypeCache typeCache, boolean succinct, DateTimeFormat dateTimeFormat) {
        if (objectInFolder == null || objectInFolder.getObject() == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("object", (Object)JSONConverter.convert(objectInFolder.getObject(), typeCache, PropertyMode.OBJECT, succinct, dateTimeFormat));
        JSONConverter.setIfNotNull("pathSegment", objectInFolder.getPathSegment(), result);
        JSONConverter.convertExtension((ExtensionsData)objectInFolder, result);
        return result;
    }

    public static JSONObject convert(ObjectInFolderList objectInFolderList, TypeCache typeCache, boolean succinct, DateTimeFormat dateTimeFormat) {
        if (objectInFolderList == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        if (objectInFolderList.getObjects() != null) {
            JSONArray objects = new JSONArray();
            for (ObjectInFolderData object : objectInFolderList.getObjects()) {
                objects.add(JSONConverter.convert(object, typeCache, succinct, dateTimeFormat));
            }
            result.put("objects", (Object)objects);
        }
        JSONConverter.setIfNotNull("hasMoreItems", objectInFolderList.hasMoreItems(), result);
        JSONConverter.setIfNotNull("numItems", objectInFolderList.getNumItems(), result);
        JSONConverter.convertExtension((ExtensionsData)objectInFolderList, result);
        return result;
    }

    public static JSONObject convert(ObjectInFolderContainer container, TypeCache typeCache, boolean succinct, DateTimeFormat dateTimeFormat) {
        if (container == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("object", (Object)JSONConverter.convert(container.getObject(), typeCache, succinct, dateTimeFormat));
        if (CollectionsHelper.isNotEmpty(container.getChildren())) {
            JSONArray children = new JSONArray();
            for (ObjectInFolderContainer descendant : container.getChildren()) {
                children.add(JSONConverter.convert(descendant, typeCache, succinct, dateTimeFormat));
            }
            result.put("children", (Object)children);
        }
        JSONConverter.convertExtension((ExtensionsData)container, result);
        return result;
    }

    public static JSONObject convert(ObjectParentData parent, TypeCache typeCache, boolean succinct, DateTimeFormat dateTimeFormat) {
        if (parent == null || parent.getObject() == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("object", (Object)JSONConverter.convert(parent.getObject(), typeCache, PropertyMode.OBJECT, succinct, dateTimeFormat));
        if (parent.getRelativePathSegment() != null) {
            result.put("relativePathSegment", (Object)parent.getRelativePathSegment());
        }
        JSONConverter.convertExtension((ExtensionsData)parent, result);
        return result;
    }

    public static JSONObject convert(TypeDefinition type, DateTimeFormat dateTimeFormat) {
        if (type == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("id", (Object)type.getId());
        result.put("localName", (Object)type.getLocalName());
        result.put("localNamespace", (Object)type.getLocalNamespace());
        JSONConverter.setIfNotNull("displayName", type.getDisplayName(), result);
        JSONConverter.setIfNotNull("queryName", type.getQueryName(), result);
        JSONConverter.setIfNotNull("description", type.getDescription(), result);
        result.put("baseId", (Object)JSONConverter.getJSONEnumValue(type.getBaseTypeId()));
        JSONConverter.setIfNotNull("parentId", type.getParentTypeId(), result);
        result.put("creatable", (Object)type.isCreatable());
        result.put("fileable", (Object)type.isFileable());
        result.put("queryable", (Object)type.isQueryable());
        result.put("fulltextIndexed", (Object)type.isFulltextIndexed());
        result.put("includedInSupertypeQuery", (Object)type.isIncludedInSupertypeQuery());
        result.put("controllablePolicy", (Object)type.isControllablePolicy());
        result.put("controllableACL", (Object)type.isControllableAcl());
        if (type.getTypeMutability() != null) {
            TypeMutability typeMutability = type.getTypeMutability();
            JSONObject typeMutabilityJson = new JSONObject();
            typeMutabilityJson.put("create", (Object)typeMutability.canCreate());
            typeMutabilityJson.put("update", (Object)typeMutability.canUpdate());
            typeMutabilityJson.put("delete", (Object)typeMutability.canDelete());
            JSONConverter.convertExtension((ExtensionsData)typeMutability, typeMutabilityJson);
            result.put("typeMutability", (Object)typeMutabilityJson);
        }
        if (type instanceof DocumentTypeDefinition) {
            result.put("versionable", (Object)((DocumentTypeDefinition)type).isVersionable());
            result.put("contentStreamAllowed", (Object)JSONConverter.getJSONEnumValue(((DocumentTypeDefinition)type).getContentStreamAllowed()));
        }
        if (type instanceof RelationshipTypeDefinition) {
            result.put("allowedSourceTypes", (Object)JSONConverter.getJSONArrayFromList(((RelationshipTypeDefinition)type).getAllowedSourceTypeIds()));
            result.put("allowedTargetTypes", (Object)JSONConverter.getJSONArrayFromList(((RelationshipTypeDefinition)type).getAllowedTargetTypeIds()));
        }
        if (CollectionsHelper.isNotEmpty(type.getPropertyDefinitions())) {
            JSONObject propertyDefs = new JSONObject();
            for (PropertyDefinition pd : type.getPropertyDefinitions().values()) {
                propertyDefs.put(pd.getId(), (Object)JSONConverter.convert(pd, dateTimeFormat));
            }
            result.put("propertyDefinitions", (Object)propertyDefs);
        }
        JSONConverter.convertExtension((ExtensionsData)type, result);
        return result;
    }

    public static JSONObject convert(PropertyDefinition<?> propertyDefinition, DateTimeFormat dateTimeFormat) {
        if (propertyDefinition == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        if (propertyDefinition instanceof PropertyStringDefinition) {
            JSONConverter.setIfNotNull("maxLength", ((PropertyStringDefinition)propertyDefinition).getMaxLength(), result);
        } else if (!(propertyDefinition instanceof PropertyIdDefinition)) {
            if (propertyDefinition instanceof PropertyIntegerDefinition) {
                JSONConverter.setIfNotNull("minValue", ((PropertyIntegerDefinition)propertyDefinition).getMinValue(), result);
                JSONConverter.setIfNotNull("maxValue", ((PropertyIntegerDefinition)propertyDefinition).getMaxValue(), result);
            } else if (propertyDefinition instanceof PropertyDecimalDefinition) {
                JSONConverter.setIfNotNull("minValue", ((PropertyDecimalDefinition)propertyDefinition).getMinValue(), result);
                JSONConverter.setIfNotNull("maxValue", ((PropertyDecimalDefinition)propertyDefinition).getMaxValue(), result);
                DecimalPrecision precision = ((PropertyDecimalDefinition)propertyDefinition).getPrecision();
                if (precision != null) {
                    result.put("precision", (Object)precision.value());
                }
            } else if (!(propertyDefinition instanceof PropertyBooleanDefinition)) {
                if (propertyDefinition instanceof PropertyDateTimeDefinition) {
                    DateTimeResolution resolution = ((PropertyDateTimeDefinition)propertyDefinition).getDateTimeResolution();
                    if (resolution != null) {
                        result.put("resolution", (Object)resolution.value());
                    }
                } else if (!(propertyDefinition instanceof PropertyHtmlDefinition) && !(propertyDefinition instanceof PropertyUriDefinition)) assert (false);
            }
        }
        if (propertyDefinition.getDefaultValue() != null) {
            if (propertyDefinition.getCardinality() == Cardinality.SINGLE) {
                if (!propertyDefinition.getDefaultValue().isEmpty()) {
                    result.put("defaultValue", JSONConverter.getJSONValue(propertyDefinition.getDefaultValue().get(0), dateTimeFormat));
                }
            } else {
                JSONArray values = new JSONArray();
                for (Object value : propertyDefinition.getDefaultValue()) {
                    values.add(JSONConverter.getJSONValue(value, dateTimeFormat));
                }
                result.put("defaultValue", (Object)values);
            }
        }
        if (CollectionsHelper.isNotEmpty(propertyDefinition.getChoices())) {
            result.put("choice", (Object)JSONConverter.convertChoices(propertyDefinition.getChoices(), propertyDefinition.getCardinality(), dateTimeFormat));
        }
        result.put("id", (Object)propertyDefinition.getId());
        result.put("localName", (Object)propertyDefinition.getLocalName());
        JSONConverter.setIfNotNull("localNamespace", propertyDefinition.getLocalNamespace(), result);
        JSONConverter.setIfNotNull("displayName", propertyDefinition.getDisplayName(), result);
        JSONConverter.setIfNotNull("queryName", propertyDefinition.getQueryName(), result);
        JSONConverter.setIfNotNull("description", propertyDefinition.getDescription(), result);
        result.put("propertyType", (Object)JSONConverter.getJSONEnumValue(propertyDefinition.getPropertyType()));
        result.put("cardinality", (Object)JSONConverter.getJSONEnumValue(propertyDefinition.getCardinality()));
        result.put("updatability", (Object)JSONConverter.getJSONEnumValue(propertyDefinition.getUpdatability()));
        JSONConverter.setIfNotNull("inherited", propertyDefinition.isInherited(), result);
        result.put("required", (Object)propertyDefinition.isRequired());
        result.put("queryable", (Object)propertyDefinition.isQueryable());
        result.put("orderable", (Object)propertyDefinition.isOrderable());
        JSONConverter.setIfNotNull("openChoice", propertyDefinition.isOpenChoice(), result);
        JSONConverter.convertExtension(propertyDefinition, result);
        return result;
    }

    private static <T> JSONArray convertChoices(List<Choice<T>> choices, Cardinality cardinality, DateTimeFormat dateTimeFormat) {
        assert (cardinality != null);
        if (choices == null) {
            return null;
        }
        JSONArray result = new JSONArray();
        for (Choice<T> choice : choices) {
            JSONObject jsonChoice = new JSONObject();
            jsonChoice.put("displayName", (Object)choice.getDisplayName());
            if (cardinality == Cardinality.SINGLE) {
                if (!choice.getValue().isEmpty()) {
                    jsonChoice.put("value", JSONConverter.getJSONValue(choice.getValue().get(0), dateTimeFormat));
                }
            } else {
                JSONArray values = new JSONArray();
                for (Object value : choice.getValue()) {
                    values.add(JSONConverter.getJSONValue(value, dateTimeFormat));
                }
                jsonChoice.put("value", (Object)values);
            }
            if (CollectionsHelper.isNotEmpty(choice.getChoice())) {
                jsonChoice.put("choice", (Object)JSONConverter.convertChoices(choice.getChoice(), cardinality, dateTimeFormat));
            }
            result.add(jsonChoice);
        }
        return result;
    }

    public static JSONObject convert(TypeDefinitionList list, DateTimeFormat dateTimeFormat) {
        if (list == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        if (list.getList() != null) {
            JSONArray objects = new JSONArray();
            for (TypeDefinition type : list.getList()) {
                objects.add(JSONConverter.convert(type, dateTimeFormat));
            }
            result.put("types", (Object)objects);
        }
        JSONConverter.setIfNotNull("hasMoreItems", list.hasMoreItems(), result);
        JSONConverter.setIfNotNull("numItems", list.getNumItems(), result);
        JSONConverter.convertExtension((ExtensionsData)list, result);
        return result;
    }

    public static TypeDefinitionList convertTypeChildren(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        TypeDefinitionListImpl result = new TypeDefinitionListImpl();
        Object typesList = json.get("types");
        ArrayList<TypeDefinition> types = new ArrayList<TypeDefinition>();
        if (typesList instanceof List) {
            for (Object type : (List)typesList) {
                if (!(type instanceof Map)) continue;
                types.add(JSONConverter.convertTypeDefinition((Map)type));
            }
        }
        result.setList(types);
        result.setHasMoreItems(JSONConverter.getBoolean(json, "hasMoreItems"));
        result.setNumItems(JSONConverter.getInteger(json, "numItems"));
        JSONConverter.convertExtension(json, result, JSONConstants.TYPESLIST_KEYS);
        return result;
    }

    public static JSONObject convert(TypeDefinitionContainer container, DateTimeFormat dateTimeFormat) {
        if (container == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("type", (Object)JSONConverter.convert(container.getTypeDefinition(), dateTimeFormat));
        if (CollectionsHelper.isNotEmpty(container.getChildren())) {
            JSONArray children = new JSONArray();
            for (TypeDefinitionContainer child : container.getChildren()) {
                children.add(JSONConverter.convert(child, dateTimeFormat));
            }
            result.put("children", (Object)children);
        }
        JSONConverter.convertExtension((ExtensionsData)container, result);
        return result;
    }

    public static List<TypeDefinitionContainer> convertTypeDescendants(List<Object> json) {
        if (json == null) {
            return null;
        }
        if (json.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>();
        for (Object obj : json) {
            if (!(obj instanceof Map)) continue;
            Map jsonContainer = (Map)obj;
            TypeDefinitionContainerImpl container = new TypeDefinitionContainerImpl();
            container.setTypeDefinition(JSONConverter.convertTypeDefinition(JSONConverter.getMap(jsonContainer.get("type"))));
            Object children = jsonContainer.get("children");
            if (children instanceof List) {
                container.setChildren(JSONConverter.convertTypeDescendants((List)children));
            } else {
                container.setChildren(Collections.<TypeDefinitionContainer>emptyList());
            }
            JSONConverter.convertExtension(jsonContainer, container, JSONConstants.TYPESCONTAINER_KEYS);
            result.add(container);
        }
        return result;
    }

    public static ObjectData convertObject(Map<String, Object> json, TypeCache typeCache) {
        List<Object> jsonRenditions;
        List<Object> jsonRelationships;
        if (json == null) {
            return null;
        }
        ObjectDataImpl result = new ObjectDataImpl();
        result.setAcl(JSONConverter.convertAcl(JSONConverter.getMap(json.get("acl"))));
        result.setAllowableActions(JSONConverter.convertAllowableActions(JSONConverter.getMap(json.get("allowableActions"))));
        Map<String, Object> jsonChangeEventInfo = JSONConverter.getMap(json.get("changeEventInfo"));
        if (jsonChangeEventInfo != null) {
            ChangeEventInfoDataImpl changeEventInfo = new ChangeEventInfoDataImpl();
            changeEventInfo.setChangeTime(JSONConverter.getDateTime(jsonChangeEventInfo, "changeTime"));
            changeEventInfo.setChangeType(JSONConverter.getEnum(jsonChangeEventInfo, "changeType", ChangeType.class));
            JSONConverter.convertExtension(json, result, JSONConstants.CHANGE_EVENT_KEYS);
            result.setChangeEventInfo(changeEventInfo);
        }
        result.setIsExactAcl(JSONConverter.getBoolean(json, "exactACL"));
        result.setPolicyIds(JSONConverter.convertPolicyIds(JSONConverter.getMap(json.get("policyIds"))));
        Map<String, Object> propMap = JSONConverter.getMap(json.get("succinctProperties"));
        if (propMap != null) {
            result.setProperties(JSONConverter.convertSuccinctProperties(propMap, JSONConverter.getMap(json.get("propertiesExtension")), typeCache));
        }
        if ((propMap = JSONConverter.getMap(json.get("properties"))) != null) {
            result.setProperties(JSONConverter.convertProperties(propMap, JSONConverter.getMap(json.get("propertiesExtension"))));
        }
        if ((jsonRelationships = JSONConverter.getList(json.get("relationships"))) != null) {
            result.setRelationships(JSONConverter.convertObjects(jsonRelationships, typeCache));
        }
        if ((jsonRenditions = JSONConverter.getList(json.get("renditions"))) != null) {
            result.setRenditions(JSONConverter.convertRenditions(jsonRenditions));
        }
        JSONConverter.convertExtension(json, result, JSONConstants.OBJECT_KEYS);
        return result;
    }

    public static List<ObjectData> convertObjects(List<Object> json, TypeCache typeCache) {
        if (json == null) {
            return null;
        }
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        for (Object obj : json) {
            ObjectData relationship = JSONConverter.convertObject(JSONConverter.getMap(obj), typeCache);
            if (relationship == null) continue;
            result.add(relationship);
        }
        return result;
    }

    public static Acl convertAcl(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        AccessControlListImpl result = new AccessControlListImpl();
        ArrayList<Ace> aces = new ArrayList<Ace>();
        List<Object> jsonAces = JSONConverter.getList(json.get("aces"));
        if (jsonAces != null) {
            for (Object obj : jsonAces) {
                Map<String, Object> jsonPrincipal;
                Map<String, Object> entry = JSONConverter.getMap(obj);
                if (entry == null) continue;
                AccessControlEntryImpl ace = new AccessControlEntryImpl();
                Boolean isDirect = JSONConverter.getBoolean(entry, "isDirect");
                ace.setDirect(isDirect != null ? isDirect : true);
                List<Object> jsonPermissions = JSONConverter.getList(entry.get("permissions"));
                if (jsonPermissions != null) {
                    ArrayList<String> permissions = new ArrayList<String>();
                    for (Object perm : jsonPermissions) {
                        if (perm == null) continue;
                        permissions.add(perm.toString());
                    }
                    ace.setPermissions(permissions);
                }
                if ((jsonPrincipal = JSONConverter.getMap(entry.get("principal"))) != null) {
                    AccessControlPrincipalDataImpl principal = new AccessControlPrincipalDataImpl();
                    principal.setId(JSONConverter.getString(jsonPrincipal, "principalId"));
                    JSONConverter.convertExtension(jsonPrincipal, principal, JSONConstants.PRINCIPAL_KEYS);
                    ace.setPrincipal((Principal)principal);
                }
                JSONConverter.convertExtension(entry, ace, JSONConstants.ACE_KEYS);
                aces.add((Ace)ace);
            }
        }
        result.setAces(aces);
        result.setExact(JSONConverter.getBoolean(json, "isExact"));
        JSONConverter.convertExtension(json, result, JSONConstants.ACL_KEYS);
        return result;
    }

    public static AllowableActions convertAllowableActions(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        AllowableActionsImpl result = new AllowableActionsImpl();
        EnumSet<Action> allowableActions = EnumSet.noneOf(Action.class);
        for (Action action : Action.values()) {
            Boolean value = JSONConverter.getBoolean(json, action.value());
            if (value == null || !value.booleanValue()) continue;
            allowableActions.add(action);
        }
        result.setAllowableActions(allowableActions);
        JSONConverter.convertExtension(json, result, JSONConstants.ALLOWABLE_ACTIONS_KEYS);
        return result;
    }

    public static PolicyIdList convertPolicyIds(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        PolicyIdListImpl result = new PolicyIdListImpl();
        ArrayList<String> policyIds = new ArrayList<String>();
        List<Object> ids = JSONConverter.getList(json.get("ids"));
        if (ids != null) {
            for (Object obj : ids) {
                if (!(obj instanceof String)) continue;
                policyIds.add((String)obj);
            }
        }
        JSONConverter.convertExtension(json, result, JSONConstants.POLICY_IDS_KEYS);
        result.setPolicyIds(policyIds);
        return result;
    }

    public static Properties convertProperties(Map<String, Object> json, Map<String, Object> extJson) {
        if (json == null) {
            return null;
        }
        PropertiesImpl result = new PropertiesImpl();
        for (Object jsonProperty : json.values()) {
            Map<String, Object> jsonPropertyMap = JSONConverter.getMap(jsonProperty);
            if (jsonPropertyMap == null) continue;
            AbstractPropertyData property = null;
            String id = JSONConverter.getString(jsonPropertyMap, "id");
            String queryName = JSONConverter.getString(jsonPropertyMap, "queryName");
            if (id == null && queryName == null) {
                throw new CmisRuntimeException("Invalid property! Neither a property ID nor a query name is provided!");
            }
            PropertyType propertyType = null;
            try {
                propertyType = PropertyType.fromValue((String)JSONConverter.getString(jsonPropertyMap, "type"));
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Invalid property datatype: " + id, (Throwable)e);
            }
            Object value = jsonPropertyMap.get("value");
            List<Object> values = null;
            if (value instanceof List) {
                values = (List<Object>)value;
            } else if (value != null) {
                values = Collections.singletonList(value);
            }
            switch (propertyType) {
                case STRING: {
                    property = new PropertyStringImpl();
                    property.setValues(JSONConverter.copyStringValues(values));
                    break;
                }
                case ID: {
                    property = new PropertyIdImpl();
                    ((PropertyIdImpl)property).setValues(JSONConverter.copyStringValues(values));
                    break;
                }
                case BOOLEAN: {
                    property = new PropertyBooleanImpl();
                    ((PropertyBooleanImpl)property).setValues(JSONConverter.copyBooleanValues(values));
                    break;
                }
                case INTEGER: {
                    property = new PropertyIntegerImpl();
                    ((PropertyIntegerImpl)property).setValues(JSONConverter.copyIntegerValues(values));
                    break;
                }
                case DECIMAL: {
                    property = new PropertyDecimalImpl();
                    ((PropertyDecimalImpl)property).setValues(JSONConverter.copyDecimalValues(values));
                    break;
                }
                case DATETIME: {
                    property = new PropertyDateTimeImpl();
                    ((PropertyDateTimeImpl)property).setValues(JSONConverter.copyDateTimeValues(values));
                    break;
                }
                case HTML: {
                    property = new PropertyHtmlImpl();
                    ((PropertyHtmlImpl)property).setValues(JSONConverter.copyStringValues(values));
                    break;
                }
                case URI: {
                    property = new PropertyUriImpl();
                    ((PropertyUriImpl)property).setValues(JSONConverter.copyStringValues(values));
                    break;
                }
                default: {
                    throw new CmisRuntimeException("Unknown property data type!");
                }
            }
            property.setId(id);
            property.setDisplayName(JSONConverter.getString(jsonPropertyMap, "displayName"));
            property.setQueryName(queryName);
            property.setLocalName(JSONConverter.getString(jsonPropertyMap, "localName"));
            JSONConverter.convertExtension(jsonPropertyMap, property, JSONConstants.PROPERTY_KEYS);
            result.addProperty((PropertyData<?>)property);
        }
        if (extJson != null) {
            JSONConverter.convertExtension(extJson, result, Collections.<String>emptySet());
        }
        return result;
    }

    public static Properties convertSuccinctProperties(Map<String, Object> json, Map<String, Object> extJson, TypeCache typeCache) {
        if (json == null) {
            return null;
        }
        TypeDefinition typeDef = null;
        if (json.get("cmis:objectTypeId") instanceof String) {
            typeDef = typeCache.getTypeDefinition((String)json.get("cmis:objectTypeId"));
        }
        List<Object> secTypeIds = JSONConverter.getList(json.get("cmis:secondaryObjectTypeIds"));
        ArrayList<TypeDefinition> secTypeDefs = null;
        if (CollectionsHelper.isNotEmpty(secTypeIds)) {
            secTypeDefs = new ArrayList<TypeDefinition>(secTypeIds.size());
            for (Object secTypeId : secTypeIds) {
                if (!(secTypeId instanceof String)) continue;
                secTypeDefs.add(typeCache.getTypeDefinition((String)secTypeId));
            }
        }
        PropertiesImpl result = new PropertiesImpl();
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            TypeDefinition reloadedTypeDef;
            TypeDefinition secTypeDef;
            Iterator i$;
            String id = entry.getKey();
            PropertyDefinition propDef = null;
            if (typeDef != null) {
                propDef = (PropertyDefinition)typeDef.getPropertyDefinitions().get(id);
            }
            if (propDef == null && secTypeDefs != null) {
                i$ = secTypeDefs.iterator();
                while (i$.hasNext() && ((secTypeDef = (TypeDefinition)i$.next()) == null || secTypeDef.getPropertyDefinitions() == null || (propDef = (PropertyDefinition)secTypeDef.getPropertyDefinitions().get(id)) == null)) {
                }
            }
            if (propDef == null) {
                propDef = (PropertyDefinition)typeCache.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value()).getPropertyDefinitions().get(id);
            }
            if (propDef == null) {
                propDef = (PropertyDefinition)typeCache.getTypeDefinition(BaseTypeId.CMIS_FOLDER.value()).getPropertyDefinitions().get(id);
            }
            if (propDef == null && typeDef != null && (reloadedTypeDef = typeCache.reloadTypeDefinition(typeDef.getId())) != null) {
                propDef = (PropertyDefinition)reloadedTypeDef.getPropertyDefinitions().get(id);
            }
            if (propDef == null && secTypeDefs != null) {
                TypeDefinition reloadedTypeDef2;
                i$ = secTypeDefs.iterator();
                while (i$.hasNext() && ((reloadedTypeDef2 = typeCache.reloadTypeDefinition((secTypeDef = (TypeDefinition)i$.next()).getId())) == null || reloadedTypeDef2.getPropertyDefinitions() == null || (propDef = (PropertyDefinition)reloadedTypeDef2.getPropertyDefinitions().get(id)) == null)) {
                }
            }
            List<Object> values = null;
            if (entry.getValue() instanceof List) {
                values = (List<Object>)entry.getValue();
            } else if (entry.getValue() != null) {
                values = Collections.singletonList(entry.getValue());
            }
            AbstractPropertyData property = null;
            if (propDef != null) {
                switch (propDef.getPropertyType()) {
                    case STRING: {
                        property = new PropertyStringImpl();
                        property.setValues(JSONConverter.copyStringValues(values));
                        break;
                    }
                    case ID: {
                        property = new PropertyIdImpl();
                        ((PropertyIdImpl)property).setValues(JSONConverter.copyStringValues(values));
                        break;
                    }
                    case BOOLEAN: {
                        property = new PropertyBooleanImpl();
                        ((PropertyBooleanImpl)property).setValues(JSONConverter.copyBooleanValues(values));
                        break;
                    }
                    case INTEGER: {
                        property = new PropertyIntegerImpl();
                        ((PropertyIntegerImpl)property).setValues(JSONConverter.copyIntegerValues(values));
                        break;
                    }
                    case DECIMAL: {
                        property = new PropertyDecimalImpl();
                        ((PropertyDecimalImpl)property).setValues(JSONConverter.copyDecimalValues(values));
                        break;
                    }
                    case DATETIME: {
                        property = new PropertyDateTimeImpl();
                        ((PropertyDateTimeImpl)property).setValues(JSONConverter.copyDateTimeValues(values));
                        break;
                    }
                    case HTML: {
                        property = new PropertyHtmlImpl();
                        ((PropertyHtmlImpl)property).setValues(JSONConverter.copyStringValues(values));
                        break;
                    }
                    case URI: {
                        property = new PropertyUriImpl();
                        ((PropertyUriImpl)property).setValues(JSONConverter.copyStringValues(values));
                        break;
                    }
                    default: {
                        throw new CmisRuntimeException("Unknown property type!");
                    }
                }
                property.setId(id);
                property.setDisplayName(propDef.getDisplayName());
                property.setQueryName(propDef.getQueryName());
                property.setLocalName(propDef.getLocalName());
            } else {
                if (values == null) {
                    property = new PropertyStringImpl();
                    property.setValues(null);
                } else {
                    Object firstValue = values.get(0);
                    if (firstValue instanceof Boolean) {
                        property = new PropertyBooleanImpl();
                        ((PropertyBooleanImpl)property).setValues(JSONConverter.copyBooleanValues(values));
                    } else if (firstValue instanceof BigInteger) {
                        property = new PropertyIntegerImpl();
                        ((PropertyIntegerImpl)property).setValues(JSONConverter.copyIntegerValues(values));
                    } else if (firstValue instanceof BigDecimal) {
                        property = new PropertyDecimalImpl();
                        ((PropertyDecimalImpl)property).setValues(JSONConverter.copyDecimalValues(values));
                    } else {
                        property = new PropertyStringImpl();
                        ((PropertyStringImpl)property).setValues(JSONConverter.copyStringValues(values));
                    }
                }
                property.setId(id);
                property.setDisplayName(id);
                property.setQueryName(null);
                property.setLocalName(null);
            }
            result.addProperty((PropertyData<?>)property);
        }
        if (extJson != null) {
            JSONConverter.convertExtension(extJson, result, Collections.<String>emptySet());
        }
        return result;
    }

    private static List<String> copyStringValues(List<Object> source) {
        ArrayList<String> result = null;
        if (source != null) {
            result = new ArrayList<String>(source.size());
            for (Object obj : source) {
                if (obj instanceof String) {
                    result.add(obj.toString());
                    continue;
                }
                throw new CmisRuntimeException("Invalid property value: " + obj);
            }
        }
        return result;
    }

    private static List<Boolean> copyBooleanValues(List<Object> source) {
        ArrayList<Boolean> result = null;
        if (source != null) {
            result = new ArrayList<Boolean>(source.size());
            for (Object obj : source) {
                if (obj instanceof Boolean) {
                    result.add((Boolean)obj);
                    continue;
                }
                throw new CmisRuntimeException("Invalid property value: " + obj);
            }
        }
        return result;
    }

    private static List<BigInteger> copyIntegerValues(List<Object> source) {
        ArrayList<BigInteger> result = null;
        if (source != null) {
            result = new ArrayList<BigInteger>(source.size());
            for (Object obj : source) {
                if (obj instanceof BigInteger) {
                    result.add((BigInteger)obj);
                    continue;
                }
                throw new CmisRuntimeException("Invalid property value: " + obj);
            }
        }
        return result;
    }

    private static List<BigDecimal> copyDecimalValues(List<Object> source) {
        ArrayList<BigDecimal> result = null;
        if (source != null) {
            result = new ArrayList<BigDecimal>(source.size());
            for (Object obj : source) {
                if (obj instanceof BigDecimal) {
                    result.add((BigDecimal)obj);
                    continue;
                }
                if (obj instanceof BigInteger) {
                    result.add(new BigDecimal((BigInteger)obj));
                    continue;
                }
                throw new CmisRuntimeException("Invalid property value: " + obj);
            }
        }
        return result;
    }

    private static List<GregorianCalendar> copyDateTimeValues(List<Object> source) {
        ArrayList<GregorianCalendar> result = null;
        if (source != null) {
            result = new ArrayList<GregorianCalendar>(source.size());
            for (Object obj : source) {
                GregorianCalendar cal;
                if (obj instanceof Number) {
                    cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    cal.setTimeInMillis(((Number)obj).longValue());
                    result.add(cal);
                    continue;
                }
                if (obj instanceof String) {
                    cal = DateTimeHelper.parseXmlDateTime((String)obj);
                    if (cal == null) {
                        throw new CmisRuntimeException("Invalid property value: " + obj);
                    }
                    result.add(cal);
                    continue;
                }
                throw new CmisRuntimeException("Invalid property value: " + obj);
            }
        }
        return result;
    }

    public static RenditionData convertRendition(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        RenditionDataImpl result = new RenditionDataImpl();
        result.setBigHeight(JSONConverter.getInteger(json, "height"));
        result.setKind(JSONConverter.getString(json, "kind"));
        result.setBigLength(JSONConverter.getInteger(json, "length"));
        result.setMimeType(JSONConverter.getString(json, "mimeType"));
        result.setRenditionDocumentId(JSONConverter.getString(json, "renditionDocumentId"));
        result.setStreamId(JSONConverter.getString(json, "streamId"));
        result.setTitle(JSONConverter.getString(json, "title"));
        result.setBigWidth(JSONConverter.getInteger(json, "width"));
        JSONConverter.convertExtension(json, result, JSONConstants.RENDITION_KEYS);
        return result;
    }

    public static List<RenditionData> convertRenditions(List<Object> json) {
        if (json == null) {
            return null;
        }
        ArrayList<RenditionData> result = new ArrayList<RenditionData>();
        for (Object obj : json) {
            RenditionData rendition = JSONConverter.convertRendition(JSONConverter.getMap(obj));
            if (rendition == null) continue;
            result.add(rendition);
        }
        return result;
    }

    public static ObjectInFolderList convertObjectInFolderList(Map<String, Object> json, TypeCache typeCache) {
        if (json == null) {
            return null;
        }
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        List<Object> jsonChildren = JSONConverter.getList(json.get("objects"));
        ArrayList<ObjectInFolderData> objects = new ArrayList<ObjectInFolderData>();
        if (jsonChildren != null) {
            for (Object obj : jsonChildren) {
                Map<String, Object> jsonObject = JSONConverter.getMap(obj);
                if (jsonObject == null) continue;
                objects.add(JSONConverter.convertObjectInFolder(jsonObject, typeCache));
            }
        }
        result.setObjects(objects);
        result.setHasMoreItems(JSONConverter.getBoolean(json, "hasMoreItems"));
        result.setNumItems(JSONConverter.getInteger(json, "numItems"));
        JSONConverter.convertExtension(json, result, JSONConstants.OBJECTINFOLDERLIST_KEYS);
        return result;
    }

    public static ObjectInFolderData convertObjectInFolder(Map<String, Object> json, TypeCache typeCache) {
        if (json == null) {
            return null;
        }
        ObjectInFolderDataImpl result = new ObjectInFolderDataImpl();
        result.setObject(JSONConverter.convertObject(JSONConverter.getMap(json.get("object")), typeCache));
        result.setPathSegment(JSONConverter.getString(json, "pathSegment"));
        JSONConverter.convertExtension(json, result, JSONConstants.OBJECTINFOLDER_KEYS);
        return result;
    }

    public static List<ObjectInFolderContainer> convertDescendants(List<Object> json, TypeCache typeCache) {
        if (json == null) {
            return null;
        }
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        for (Object obj : json) {
            Map<String, Object> desc = JSONConverter.getMap(obj);
            if (desc == null) continue;
            result.add(JSONConverter.convertDescendant(desc, typeCache));
        }
        return result;
    }

    public static ObjectInFolderContainer convertDescendant(Map<String, Object> json, TypeCache typeCache) {
        if (json == null) {
            return null;
        }
        ObjectInFolderContainerImpl result = new ObjectInFolderContainerImpl();
        result.setObject(JSONConverter.convertObjectInFolder(JSONConverter.getMap(json.get("object")), typeCache));
        ArrayList<ObjectInFolderContainer> containerList = new ArrayList<ObjectInFolderContainer>();
        List<Object> jsonContainerList = JSONConverter.getList(json.get("children"));
        if (jsonContainerList != null) {
            for (Object obj : jsonContainerList) {
                Map<String, Object> containerChild = JSONConverter.getMap(obj);
                if (containerChild == null) continue;
                containerList.add(JSONConverter.convertDescendant(containerChild, typeCache));
            }
        }
        result.setChildren(containerList);
        JSONConverter.convertExtension(json, result, JSONConstants.OBJECTINFOLDERCONTAINER_KEYS);
        return result;
    }

    public static List<ObjectParentData> convertObjectParents(List<Object> json, TypeCache typeCache) {
        if (json == null) {
            return null;
        }
        ArrayList<ObjectParentData> result = new ArrayList<ObjectParentData>();
        for (Object obj : json) {
            Map<String, Object> jsonParent = JSONConverter.getMap(obj);
            if (jsonParent == null) continue;
            ObjectParentDataImpl parent = new ObjectParentDataImpl();
            parent.setObject(JSONConverter.convertObject(JSONConverter.getMap(jsonParent.get("object")), typeCache));
            parent.setRelativePathSegment(JSONConverter.getString(jsonParent, "relativePathSegment"));
            JSONConverter.convertExtension(jsonParent, parent, JSONConstants.OBJECTPARENTS_KEYS);
            result.add(parent);
        }
        return result;
    }

    public static ObjectList convertObjectList(Map<String, Object> json, TypeCache typeCache, boolean isQueryResult) {
        if (json == null) {
            return null;
        }
        ObjectListImpl result = new ObjectListImpl();
        List<Object> jsonChildren = JSONConverter.getList(json.get(isQueryResult ? "results" : "objects"));
        ArrayList<ObjectData> objects = new ArrayList<ObjectData>();
        if (jsonChildren != null) {
            for (Object obj : jsonChildren) {
                Map<String, Object> jsonObject = JSONConverter.getMap(obj);
                if (jsonObject == null) continue;
                objects.add(JSONConverter.convertObject(jsonObject, typeCache));
            }
        }
        result.setObjects(objects);
        if (isQueryResult) {
            result.setHasMoreItems(JSONConverter.getBoolean(json, "hasMoreItems"));
            result.setNumItems(JSONConverter.getInteger(json, "numItems"));
            JSONConverter.convertExtension(json, result, JSONConstants.QUERYRESULTLIST_KEYS);
        } else {
            result.setHasMoreItems(JSONConverter.getBoolean(json, "hasMoreItems"));
            result.setNumItems(JSONConverter.getInteger(json, "numItems"));
            JSONConverter.convertExtension(json, result, JSONConstants.OBJECTLIST_KEYS);
        }
        return result;
    }

    public static JSONObject convert(FailedToDeleteData ftd) {
        if (ftd == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        JSONArray ids = new JSONArray();
        if (ftd.getIds() != null) {
            for (String id : ftd.getIds()) {
                ids.add(id);
            }
        }
        result.put("ids", (Object)ids);
        JSONConverter.convertExtension((ExtensionsData)ftd, result);
        return result;
    }

    public static FailedToDeleteData convertFailedToDelete(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        ArrayList<String> ids = new ArrayList<String>();
        List<Object> jsonIds = JSONConverter.getList(json.get("ids"));
        if (jsonIds != null) {
            for (Object obj : jsonIds) {
                if (obj == null) continue;
                ids.add(obj.toString());
            }
        }
        result.setIds(ids);
        JSONConverter.convertExtension(json, result, JSONConstants.FAILEDTODELETE_KEYS);
        return result;
    }

    public static JSONObject convert(BulkUpdateObjectIdAndChangeToken oc) {
        if (oc == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        JSONConverter.setIfNotNull("id", oc.getId(), result);
        JSONConverter.setIfNotNull("newId", oc.getNewId(), result);
        JSONConverter.setIfNotNull("changeToken", oc.getChangeToken(), result);
        JSONConverter.convertExtension((ExtensionsData)oc, result);
        return result;
    }

    public static List<BulkUpdateObjectIdAndChangeToken> convertBulkUpdate(List<Object> json) {
        if (json == null) {
            return null;
        }
        ArrayList<BulkUpdateObjectIdAndChangeToken> result = new ArrayList<BulkUpdateObjectIdAndChangeToken>();
        for (Object ocJson : json) {
            BulkUpdateObjectIdAndChangeToken oc = JSONConverter.convertBulkUpdate(JSONConverter.getMap(ocJson));
            if (oc == null) continue;
            result.add(oc);
        }
        return result;
    }

    public static BulkUpdateObjectIdAndChangeToken convertBulkUpdate(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        String id = JSONConverter.getString(json, "id");
        String newId = JSONConverter.getString(json, "newId");
        String changeToken = JSONConverter.getString(json, "changeToken");
        BulkUpdateObjectIdAndChangeTokenImpl result = new BulkUpdateObjectIdAndChangeTokenImpl(id, newId, changeToken);
        JSONConverter.convertExtension(json, result, JSONConstants.BULK_UPDATE_KEYS);
        return result;
    }

    public static void convertExtension(ExtensionsData source, JSONObject target) {
        if (source == null || source.getExtensions() == null) {
            return;
        }
        for (CmisExtensionElement ext : source.getExtensions()) {
            JSONConverter.addExtensionToTarget(ext, target);
        }
    }

    private static JSONObject convertExtensionList(List<CmisExtensionElement> extensionList) {
        if (extensionList == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        for (CmisExtensionElement ext : extensionList) {
            JSONConverter.addExtensionToTarget(ext, result);
        }
        return result;
    }

    private static void addExtensionToTarget(CmisExtensionElement ext, JSONObject target) {
        if (ext == null) {
            return;
        }
        Object value = null;
        value = CollectionsHelper.isNotEmpty(ext.getChildren()) ? JSONConverter.convertExtensionList(ext.getChildren()) : ext.getValue();
        if (!target.containsKey(ext.getName())) {
            target.put(ext.getName(), value);
        } else {
            JSONArray array;
            Object extValue = target.get(ext.getName());
            if (extValue instanceof JSONArray) {
                array = (JSONArray)extValue;
            } else {
                array = new JSONArray();
                array.add(extValue);
            }
            array.add(value);
            target.put(ext.getName(), (Object)array);
        }
    }

    public static void convertExtension(Map<String, Object> source, ExtensionsData target, Set<String> cmisKeys) {
        if (source == null) {
            return;
        }
        ArrayList<CmisExtensionElement> extensions = null;
        for (Map.Entry<String, Object> element : source.entrySet()) {
            if (cmisKeys.contains(element.getKey())) continue;
            if (extensions == null) {
                extensions = new ArrayList<CmisExtensionElement>();
            }
            if (element.getValue() instanceof Map) {
                extensions.add(new CmisExtensionElementImpl(null, element.getKey(), null, JSONConverter.convertExtension((Map)element.getValue())));
                continue;
            }
            if (element.getValue() instanceof List) {
                extensions.addAll(JSONConverter.convertExtension(element.getKey(), (List)element.getValue()));
                continue;
            }
            String value = element.getValue() == null ? null : element.getValue().toString();
            extensions.add(new CmisExtensionElementImpl(null, element.getKey(), null, value));
        }
        target.setExtensions(extensions);
    }

    public static List<CmisExtensionElement> convertExtension(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ArrayList<CmisExtensionElement> extensions = new ArrayList<CmisExtensionElement>();
        for (Map.Entry<String, Object> element : map.entrySet()) {
            if (element.getValue() instanceof Map) {
                extensions.add(new CmisExtensionElementImpl(null, element.getKey(), null, JSONConverter.convertExtension((Map)element.getValue())));
                continue;
            }
            if (element.getValue() instanceof List) {
                extensions.addAll(JSONConverter.convertExtension(element.getKey(), (List)element.getValue()));
                continue;
            }
            String value = element.getValue() == null ? null : element.getValue().toString();
            extensions.add(new CmisExtensionElementImpl(null, element.getKey(), null, value));
        }
        return extensions;
    }

    public static List<CmisExtensionElement> convertExtension(String name, List<Object> list) {
        if (list == null) {
            return null;
        }
        ArrayList<CmisExtensionElement> extensions = new ArrayList<CmisExtensionElement>();
        for (Object element : list) {
            if (element instanceof Map) {
                extensions.add(new CmisExtensionElementImpl(null, name, null, JSONConverter.convertExtension((Map)element)));
                continue;
            }
            if (element instanceof List) {
                extensions.addAll(JSONConverter.convertExtension(name, (List)element));
                continue;
            }
            String value = element == null ? null : element.toString();
            extensions.add(new CmisExtensionElementImpl(null, name, null, value));
        }
        return extensions;
    }

    public static String getJSONStringValue(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static Object getJSONValue(Object value, DateTimeFormat dateTimeFormat) {
        if (value instanceof GregorianCalendar) {
            if (dateTimeFormat == DateTimeFormat.EXTENDED) {
                return DateTimeHelper.formatXmlDateTime((GregorianCalendar)value);
            }
            return ((GregorianCalendar)value).getTimeInMillis();
        }
        return value;
    }

    public static String getJSONEnumValue(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            Method m = obj.getClass().getMethod("value", new Class[0]);
            return (String)m.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                return null;
            }
            throw new CmisRuntimeException("Could not get enum value!", (Throwable)e);
        }
    }

    public static Object getCMISValue(Object value, PropertyType propertyType) {
        if (value == null) {
            return null;
        }
        switch (propertyType) {
            case STRING: 
            case ID: 
            case HTML: 
            case URI: {
                if (value instanceof String) {
                    return value;
                }
                throw new CmisRuntimeException("Invalid String value!");
            }
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    return value;
                }
                throw new CmisRuntimeException("Invalid Boolean value!");
            }
            case INTEGER: {
                if (value instanceof BigInteger) {
                    return value;
                }
                throw new CmisRuntimeException("Invalid Integer value!");
            }
            case DECIMAL: {
                if (value instanceof BigDecimal) {
                    return value;
                }
                throw new CmisRuntimeException("Invalid Decimal value!");
            }
            case DATETIME: {
                if (value instanceof Number) {
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    cal.setTimeInMillis(((Number)value).longValue());
                    return cal;
                }
                if (value instanceof String) {
                    GregorianCalendar cal = DateTimeHelper.parseXmlDateTime((String)value);
                    if (cal == null) {
                        throw new CmisRuntimeException("Invalid DateTime value!");
                    }
                    return cal;
                }
                throw new CmisRuntimeException("Invalid DateTime value!");
            }
        }
        throw new CmisRuntimeException("Unkown property type!");
    }

    public static JSONArray getJSONArrayFromList(List<?> list) {
        if (list == null) {
            return null;
        }
        JSONArray result = new JSONArray();
        result.addAll(list);
        return result;
    }

    public static String getJSONPropertyDataType(PropertyData<?> property) {
        if (property instanceof PropertyBoolean) {
            return PropertyType.BOOLEAN.value();
        }
        if (property instanceof PropertyId) {
            return PropertyType.ID.value();
        }
        if (property instanceof PropertyInteger) {
            return PropertyType.INTEGER.value();
        }
        if (property instanceof PropertyDateTime) {
            return PropertyType.DATETIME.value();
        }
        if (property instanceof PropertyDecimal) {
            return PropertyType.DECIMAL.value();
        }
        if (property instanceof PropertyHtml) {
            return PropertyType.HTML.value();
        }
        if (property instanceof PropertyString) {
            return PropertyType.STRING.value();
        }
        if (property instanceof PropertyUri) {
            return PropertyType.URI.value();
        }
        return null;
    }

    public static void setIfNotNull(String name, Object obj, JSONObject json) {
        if (obj != null) {
            json.put(name, obj);
        }
    }

    public static Map<String, Object> getMap(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return (Map)o;
        }
        throw new CmisRuntimeException("Expected a JSON object but found a " + (o instanceof List ? "JSON array" : o.getClass().getSimpleName()) + ": " + o.toString());
    }

    public static List<Object> getList(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        throw new CmisRuntimeException("Expected a JSON array but found a " + (o instanceof List ? "JSON object" : o.getClass().getSimpleName()) + ": " + o.toString());
    }

    public static String getString(Map<String, Object> json, String key) {
        Object obj = json.get(key);
        return obj == null ? null : obj.toString();
    }

    public static Boolean getBoolean(Map<String, Object> json, String key) {
        Object obj = json.get(key);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return null;
    }

    public static BigInteger getInteger(Map<String, Object> json, String key) {
        Object obj = json.get(key);
        if (obj instanceof BigInteger) {
            return (BigInteger)obj;
        }
        return null;
    }

    public static BigDecimal getDecimal(Map<String, Object> json, String key) {
        Object obj = json.get(key);
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof BigInteger) {
            return new BigDecimal((BigInteger)obj);
        }
        return null;
    }

    public static GregorianCalendar getDateTime(Map<String, Object> json, String key) {
        Object obj = json.get(key);
        if (obj instanceof Number) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.setTimeInMillis(((Number)obj).longValue());
            return cal;
        }
        if (obj instanceof String) {
            return DateTimeHelper.parseXmlDateTime((String)obj);
        }
        return null;
    }

    public static <T extends Enum<T>> T getEnum(Map<String, Object> json, String key, Class<T> clazz) {
        return CmisEnumHelper.fromValue(JSONConverter.getString(json, key), clazz);
    }

    public static <T extends Enum<T>> T getIntEnum(Map<String, Object> json, String key, Class<T> clazz) {
        return CmisEnumHelper.fromValue(JSONConverter.getInteger(json, key), clazz);
    }

    public static enum PropertyMode {
        OBJECT,
        QUERY,
        CHANGE;

    }
}

