/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeHelper {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Pattern XML_DATETIME = Pattern.compile("(\\d{4,9})-([01]\\d)-([0-3]\\d)T([0-2]\\d):([0-5]\\d):([0-5]\\d)(\\.(\\d+))?(([+-][0-2]\\d:[0-5]\\d)|Z)?");
    private static final BigDecimal BD1000 = new BigDecimal(1000);
    private static final String[] WDAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final Map<String, Integer> MONTHS_MAP = new HashMap<String, Integer>();
    private static final Pattern HTTP_DATETIME1;
    private static final Pattern HTTP_DATETIME2;
    private static final Pattern HTTP_DATETIME3;

    public static GregorianCalendar parseXmlDateTime(String s) throws IllegalArgumentException {
        if (s == null) {
            return null;
        }
        Matcher m = XML_DATETIME.matcher(s);
        if (!m.matches()) {
            return null;
        }
        try {
            int year = Integer.parseInt(m.group(1));
            int month = Integer.parseInt(m.group(2));
            int day = Integer.parseInt(m.group(3));
            int hour = Integer.parseInt(m.group(4));
            int minute = Integer.parseInt(m.group(5));
            int second = Integer.parseInt(m.group(6));
            int millisecond = 0;
            if (m.group(8) != null) {
                millisecond = new BigDecimal("0." + m.group(8)).multiply(BD1000).intValue();
            }
            TimeZone tz = GMT;
            if (m.group(10) != null) {
                tz = TimeZone.getTimeZone("GMT" + m.group(10));
            }
            GregorianCalendar result = new GregorianCalendar();
            result.clear();
            result.setTimeZone(tz);
            result.set(year, month - 1, day, hour, minute, second);
            result.set(14, millisecond);
            return result;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String formatXmlDateTime(long millis) {
        GregorianCalendar cal = new GregorianCalendar(GMT);
        cal.setTimeInMillis(millis);
        return DateTimeHelper.formatXmlDateTime(cal);
    }

    public static String formatXmlDateTime(GregorianCalendar cal) {
        int tz;
        if (cal == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        DateTimeHelper.add4d(sb, cal.get(1));
        sb.append('-');
        DateTimeHelper.add2d(sb, cal.get(2) + 1);
        sb.append('-');
        DateTimeHelper.add2d(sb, cal.get(5));
        sb.append('T');
        DateTimeHelper.add2d(sb, cal.get(11));
        sb.append(':');
        DateTimeHelper.add2d(sb, cal.get(12));
        sb.append(':');
        DateTimeHelper.add2d(sb, cal.get(13));
        int ms = cal.get(14);
        if (ms > 0) {
            sb.append('.');
            DateTimeHelper.add3d(sb, ms);
            while (sb.charAt(sb.length() - 1) == '0') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        if ((tz = cal.getTimeZone().getOffset(cal.getTimeInMillis())) == 0) {
            sb.append("Z");
        } else {
            if (tz > 0) {
                sb.append("+");
            } else {
                sb.append("-");
                tz *= -1;
            }
            DateTimeHelper.add2d(sb, tz / 3600000);
            sb.append(":");
            int tzm = tz % 3600000;
            DateTimeHelper.add2d(sb, tzm == 0 ? 0 : tzm / 60000);
        }
        return sb.toString();
    }

    public static Date parseHttpDateTime(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() > 1 && s.startsWith("'") && s.endsWith("'")) {
            s = s.substring(1, s.length() - 1);
        }
        GregorianCalendar cal = new GregorianCalendar(GMT);
        cal.set(14, 0);
        Matcher m = null;
        m = HTTP_DATETIME1.matcher(s);
        if (m.matches()) {
            Integer month = MONTHS_MAP.get(m.group(2));
            if (month == null) {
                return null;
            }
            cal.set(5, Integer.parseInt(m.group(1)));
            cal.set(2, month);
            cal.set(1, Integer.parseInt(m.group(3)));
            cal.set(11, Integer.parseInt(m.group(4)));
            cal.set(12, Integer.parseInt(m.group(5)));
            cal.set(13, Integer.parseInt(m.group(6)));
            return cal.getTime();
        }
        m = HTTP_DATETIME2.matcher(s);
        if (m.matches()) {
            Integer month = MONTHS_MAP.get(m.group(2));
            if (month == null) {
                return null;
            }
            cal.set(5, Integer.parseInt(m.group(1)));
            cal.set(2, month);
            int year = Integer.parseInt(m.group(3));
            if (year < 100) {
                int thisYear = new GregorianCalendar(GMT).get(1);
                int testYear = year + thisYear - thisYear % 100;
                year = testYear < thisYear + 20 ? testYear : testYear - 100;
            }
            cal.set(1, year);
            cal.set(11, Integer.parseInt(m.group(4)));
            cal.set(12, Integer.parseInt(m.group(5)));
            cal.set(13, Integer.parseInt(m.group(6)));
            return cal.getTime();
        }
        m = HTTP_DATETIME3.matcher(s);
        if (m.matches()) {
            Integer month = MONTHS_MAP.get(m.group(1));
            if (month == null) {
                return null;
            }
            cal.set(5, Integer.parseInt(m.group(2).trim()));
            cal.set(2, month);
            cal.set(1, Integer.parseInt(m.group(6)));
            cal.set(11, Integer.parseInt(m.group(3)));
            cal.set(12, Integer.parseInt(m.group(4)));
            cal.set(13, Integer.parseInt(m.group(5)));
            return cal.getTime();
        }
        return null;
    }

    public static String formatHttpDateTime(long millis) {
        GregorianCalendar cal = new GregorianCalendar(GMT);
        cal.setTimeInMillis(millis);
        StringBuilder sb = new StringBuilder();
        sb.append(WDAYS[cal.get(7) - 1]);
        sb.append(", ");
        DateTimeHelper.add2d(sb, cal.get(5));
        sb.append(' ');
        sb.append(MONTHS[cal.get(2)]);
        sb.append(' ');
        DateTimeHelper.add4d(sb, cal.get(1));
        sb.append(' ');
        DateTimeHelper.add2d(sb, cal.get(11));
        sb.append(':');
        DateTimeHelper.add2d(sb, cal.get(12));
        sb.append(':');
        DateTimeHelper.add2d(sb, cal.get(13));
        sb.append(" GMT");
        return sb.toString();
    }

    public static String formatHttpDateTime(Date date) {
        return DateTimeHelper.formatHttpDateTime(date.getTime());
    }

    public static String formatHttpDateTime(GregorianCalendar cal) {
        return DateTimeHelper.formatHttpDateTime(cal.getTimeInMillis());
    }

    private static void add2d(StringBuilder sb, int value) {
        if (value < 10) {
            sb.append('0');
        }
        sb.append(value);
    }

    private static void add3d(StringBuilder sb, int value) {
        if (value < 10) {
            sb.append('0');
        }
        if (value < 100) {
            sb.append('0');
        }
        sb.append(value);
    }

    private static void add4d(StringBuilder sb, int value) {
        if (value < 10) {
            sb.append('0');
        }
        if (value < 100) {
            sb.append('0');
        }
        if (value < 1000) {
            sb.append('0');
        }
        sb.append(value);
    }

    static {
        for (int i = 0; i < MONTHS.length; ++i) {
            MONTHS_MAP.put(MONTHS[i], i);
        }
        HTTP_DATETIME1 = Pattern.compile("\\w{3}, ([0-3]\\d) (\\w{3}) (\\d{4}) ([0-2]\\d):([0-5]\\d):([0-5]\\d) GMT");
        HTTP_DATETIME2 = Pattern.compile("\\w{6,9}, ([0-3]\\d)-(\\w{3})-(\\d{2}) ([0-2]\\d):([0-5]\\d):([0-5]\\d) GMT");
        HTTP_DATETIME3 = Pattern.compile("\\w{3} (\\w{3}) ([0-3 ]\\d) ([0-2]\\d):([0-5]\\d):([0-5]\\d) (\\d{4})");
    }
}

