/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisServiceUnavailableException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisTooManyRequestsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.ServerVersion;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.AclService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.DiscoveryService;
import org.apache.chemistry.opencmis.server.impl.browser.MultiFilingService;
import org.apache.chemistry.opencmis.server.impl.browser.NavigationService;
import org.apache.chemistry.opencmis.server.impl.browser.ObjectService;
import org.apache.chemistry.opencmis.server.impl.browser.POSTHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.impl.browser.PolicyService;
import org.apache.chemistry.opencmis.server.impl.browser.RelationshipService;
import org.apache.chemistry.opencmis.server.impl.browser.RepositoryService;
import org.apache.chemistry.opencmis.server.impl.browser.VersioningService;
import org.apache.chemistry.opencmis.server.impl.browser.token.TokenHandler;
import org.apache.chemistry.opencmis.server.shared.AbstractCmisHttpServlet;
import org.apache.chemistry.opencmis.server.shared.Dispatcher;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.apache.chemistry.opencmis.server.shared.HEADHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.NoBodyHttpServletResponseWrapper;
import org.apache.chemistry.opencmis.server.shared.QueryStringHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.ServiceCall;
import org.apache.chemistry.opencmis.server.shared.TempStoreOutputStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisBrowserBindingServlet
extends AbstractCmisHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CmisBrowserBindingServlet.class);
    private final Dispatcher repositoryDispatcher = new Dispatcher(false);
    private final Dispatcher rootDispatcher = new Dispatcher(false);
    private static final ErrorServiceCall ERROR_SERTVICE_CALL = new ErrorServiceCall();

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setBinding("browser");
        this.setCmisVersion(CmisVersion.CMIS_1_1);
        this.addRepositoryResource("", "GET", new RepositoryService.GetRepositories());
        this.addRepositoryResource("repositoryInfo", "GET", new RepositoryService.GetRepositoryInfo());
        this.addRepositoryResource("lastResult", "GET", new RepositoryService.GetLastResult());
        this.addRepositoryResource("typeChildren", "GET", new RepositoryService.GetTypeChildren());
        this.addRepositoryResource("typeDescendants", "GET", new RepositoryService.GetTypeDescendants());
        this.addRepositoryResource("typeDefinition", "GET", new RepositoryService.GetTypeDefinition());
        this.addRepositoryResource("createType", "POST", new RepositoryService.CreateType());
        this.addRepositoryResource("updateType", "POST", new RepositoryService.UpdateType());
        this.addRepositoryResource("deleteType", "POST", new RepositoryService.DeleteType());
        this.addRepositoryResource("query", "GET", new DiscoveryService.Query());
        this.addRepositoryResource("checkedout", "GET", new NavigationService.GetCheckedOutDocs());
        this.addRepositoryResource("contentChanges", "GET", new DiscoveryService.GetContentChanges());
        this.addRepositoryResource("query", "POST", new DiscoveryService.Query());
        this.addRepositoryResource("createDocument", "POST", new ObjectService.CreateDocument());
        this.addRepositoryResource("createDocumentFromSource", "POST", new ObjectService.CreateDocumentFromSource());
        this.addRepositoryResource("createPolicy", "POST", new ObjectService.CreatePolicy());
        this.addRepositoryResource("createItem", "POST", new ObjectService.CreateItem());
        this.addRepositoryResource("createRelationship", "POST", new ObjectService.CreateRelationship());
        this.addRepositoryResource("bulkUpdate", "POST", new ObjectService.BulkUpdateProperties());
        this.addRootResource("object", "GET", new ObjectService.GetObject());
        this.addRootResource("properties", "GET", new ObjectService.GetProperties());
        this.addRootResource("allowableActions", "GET", new ObjectService.GetAllowableActions());
        this.addRootResource("renditions", "GET", new ObjectService.GetRenditions());
        this.addRootResource("content", "GET", new ObjectService.GetContentStream());
        this.addRootResource("children", "GET", new NavigationService.GetChildren());
        this.addRootResource("descendants", "GET", new NavigationService.GetDescendants());
        this.addRootResource("folderTree", "GET", new NavigationService.GetFolderTree());
        this.addRootResource("parent", "GET", new NavigationService.GetFolderParent());
        this.addRootResource("parents", "GET", new NavigationService.GetObjectParents());
        this.addRootResource("versions", "GET", new VersioningService.GetAllVersions());
        this.addRootResource("relationships", "GET", new RelationshipService.GetObjectRelationships());
        this.addRootResource("checkedout", "GET", new NavigationService.GetCheckedOutDocs());
        this.addRootResource("policies", "GET", new PolicyService.GetAppliedPolicies());
        this.addRootResource("acl", "GET", new AclService.GetACL());
        this.addRootResource("createDocument", "POST", new ObjectService.CreateDocument());
        this.addRootResource("createDocumentFromSource", "POST", new ObjectService.CreateDocumentFromSource());
        this.addRootResource("createFolder", "POST", new ObjectService.CreateFolder());
        this.addRootResource("createPolicy", "POST", new ObjectService.CreatePolicy());
        this.addRootResource("createItem", "POST", new ObjectService.CreateItem());
        this.addRootResource("update", "POST", new ObjectService.UpdateProperties());
        this.addRootResource("setContent", "POST", new ObjectService.SetContentStream());
        this.addRootResource("appendContent", "POST", new ObjectService.AppendContentStream());
        this.addRootResource("deleteContent", "POST", new ObjectService.DeleteContentStream());
        this.addRootResource("delete", "POST", new ObjectService.DeleteObject());
        this.addRootResource("deleteTree", "POST", new ObjectService.DeleteTree());
        this.addRootResource("move", "POST", new ObjectService.MoveObject());
        this.addRootResource("addObjectToFolder", "POST", new MultiFilingService.AddObjectToFolder());
        this.addRootResource("removeObjectFromFolder", "POST", new MultiFilingService.RemoveObjectFromFolder());
        this.addRootResource("checkOut", "POST", new VersioningService.CheckOut());
        this.addRootResource("cancelCheckOut", "POST", new VersioningService.CancelCheckOut());
        this.addRootResource("checkIn", "POST", new VersioningService.CheckIn());
        this.addRootResource("applyPolicy", "POST", new PolicyService.ApplyPolicy());
        this.addRootResource("removePolicy", "POST", new PolicyService.RemovePolicy());
        this.addRootResource("applyACL", "POST", new AclService.ApplyACL());
        this.addRootResource("folder", "GET", new NavigationService.GetFolderTree());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CallContext context = null;
        boolean flush = true;
        try {
            String method = request.getMethod();
            if (!"GET".equals(method) && !"HEAD".equals(method)) {
                this.checkCsrfToken((HttpServletRequest)request, (HttpServletResponse)response, false, false);
            }
            response.addHeader("Cache-Control", "private, max-age=0");
            response.addHeader("Server", ServerVersion.OPENCMIS_SERVER);
            String[] pathFragments = HttpUtils.splitPath(request);
            TempStoreOutputStreamFactory streamFactoy = TempStoreOutputStreamFactory.newInstance(this.getServiceFactory(), pathFragments.length > 0 ? pathFragments[0] : null, request);
            if ("GET".equals(method)) {
                request = new QueryStringHttpServletRequestWrapper((HttpServletRequest)request);
            } else if ("POST".equals(method)) {
                request = new POSTHttpServletRequestWrapper((HttpServletRequest)request, streamFactoy);
            } else if ("HEAD".equals(method)) {
                request = new HEADHttpServletRequestWrapper((HttpServletRequest)request);
                response = new NoBodyHttpServletResponseWrapper((HttpServletResponse)response);
            } else {
                throw new CmisNotSupportedException("Unsupported method");
            }
            if (request.getParameter("login") != null && this.getCallContextHandler() instanceof TokenHandler) {
                ((TokenHandler)((Object)this.getCallContextHandler())).service(this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            context = this.createContext(this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response, streamFactoy);
            this.dispatch(context, (HttpServletRequest)request, (HttpServletResponse)response, pathFragments);
        }
        catch (Exception e) {
            if (e instanceof CmisUnauthorizedException) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"CMIS\", charset=\"UTF-8\"");
                response.sendError(401, "Authorization Required");
            } else if (e instanceof CmisPermissionDeniedException) {
                if (context == null || context.getUsername() == null) {
                    response.setHeader("WWW-Authenticate", "Basic realm=\"CMIS\", charset=\"UTF-8\"");
                    response.sendError(401, "Authorization Required");
                } else {
                    this.printError(context, e, (HttpServletRequest)request, (HttpServletResponse)response);
                }
            } else {
                flush = !(e instanceof IOException);
                this.printError(context, e, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        catch (Throwable t) {
            LOG.error(CmisBrowserBindingServlet.createLogMessage(t, request), t);
            try {
                response.resetBuffer();
                response.setStatus(500);
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                PrintWriter pw = response.getWriter();
                pw.print("{\"exception\":\"runtime\",\"message\": \"An error occurred!\"}");
                pw.flush();
            }
            catch (Exception te) {
                flush = false;
            }
            throw t;
        }
        finally {
            InputStream stream;
            if (request instanceof POSTHttpServletRequestWrapper && (stream = ((POSTHttpServletRequestWrapper)((Object)request)).getStream()) != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error("Could not close POST stream: {}", (Object)e.toString(), (Object)e);
                }
            }
            if (flush) {
                try {
                    response.flushBuffer();
                }
                catch (IOException ioe) {
                    LOG.error("Could not flush resposne: {}", (Object)ioe.toString(), (Object)ioe);
                }
            }
        }
    }

    protected void addRepositoryResource(String resource, String httpMethod, ServiceCall serviceCall) {
        this.repositoryDispatcher.addResource(resource, httpMethod, serviceCall);
    }

    protected void addRootResource(String resource, String httpMethod, ServiceCall serviceCall) {
        this.rootDispatcher.addResource(resource, httpMethod, serviceCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(CallContext context, HttpServletRequest request, HttpServletResponse response, String[] pathFragments) throws Exception {
        BrowserCallContextImpl browserContext = (BrowserCallContextImpl)context;
        try (CmisService service = null;){
            service = this.getServiceFactory().getService(context);
            if (pathFragments.length < 1) {
                this.checkCsrfToken(request, response, true, false);
                this.repositoryDispatcher.dispatch("", "GET", context, service, null, request, response);
                return;
            }
            CallUrl callUrl = null;
            if (pathFragments.length == 1) {
                callUrl = CallUrl.REPOSITORY;
            } else if ("root".equals(pathFragments[1])) {
                callUrl = CallUrl.ROOT;
            }
            if (callUrl == null) {
                throw new CmisNotSupportedException("Unknown operation");
            }
            String method = request.getMethod();
            String repositoryId = pathFragments[0];
            boolean callServiceFound = false;
            if ("GET".equals(method)) {
                String selector = HttpUtils.getStringParameter(request, "cmisselector");
                String objectId = HttpUtils.getStringParameter(request, "objectId");
                if (callUrl == CallUrl.REPOSITORY) {
                    if (selector == null || selector.length() == 0) {
                        throw new CmisNotSupportedException("No selector");
                    }
                    this.checkCsrfToken(request, response, "repositoryInfo".equalsIgnoreCase(selector), false);
                    browserContext.setCallDetails(service, objectId, null, null);
                    callServiceFound = this.repositoryDispatcher.dispatch(selector, method, (CallContext)browserContext, service, repositoryId, request, response);
                } else if (callUrl == CallUrl.ROOT) {
                    browserContext.setCallDetails(service, objectId, pathFragments, null);
                    if (selector == null) {
                        try {
                            BaseTypeId basetype = browserContext.getBaseTypeId();
                            switch (basetype) {
                                case CMIS_DOCUMENT: {
                                    selector = "content";
                                    break;
                                }
                                case CMIS_FOLDER: {
                                    selector = "children";
                                    break;
                                }
                                default: {
                                    selector = "object";
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            selector = "object";
                        }
                    }
                    this.checkCsrfToken(request, response, false, "content".equalsIgnoreCase(selector));
                    callServiceFound = this.rootDispatcher.dispatch(selector, method, (CallContext)browserContext, service, repositoryId, request, response);
                }
            } else if ("POST".equals(method)) {
                String cmisaction = HttpUtils.getStringParameter(request, "cmisaction");
                String objectId = HttpUtils.getStringParameter(request, "objectId");
                String token = HttpUtils.getStringParameter(request, "token");
                if (cmisaction == null || cmisaction.length() == 0) {
                    throw new CmisNotSupportedException("Unknown action");
                }
                if (callUrl == CallUrl.REPOSITORY) {
                    browserContext.setCallDetails(service, objectId, null, token);
                    callServiceFound = this.repositoryDispatcher.dispatch(cmisaction, method, (CallContext)browserContext, service, repositoryId, request, response);
                } else if (callUrl == CallUrl.ROOT) {
                    browserContext.setCallDetails(service, objectId, pathFragments, token);
                    callServiceFound = this.rootDispatcher.dispatch(cmisaction, method, (CallContext)browserContext, service, repositoryId, request, response);
                }
            }
            if (!callServiceFound) {
                throw new CmisNotSupportedException("Unknown operation");
            }
        }
    }

    protected int getErrorCode(CmisBaseException ex) {
        return ERROR_SERTVICE_CALL.getErrorCode(ex);
    }

    protected void printError(CallContext context, Exception ex, HttpServletRequest request, HttpServletResponse response) {
        ERROR_SERTVICE_CALL.printError(context, ex, request, response);
    }

    static class ErrorServiceCall
    extends AbstractBrowserServiceCall {
        ErrorServiceCall() {
        }

        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        }

        public int getErrorCode(CmisBaseException ex) {
            if (ex instanceof CmisConstraintException) {
                return 409;
            }
            if (ex instanceof CmisContentAlreadyExistsException) {
                return 409;
            }
            if (ex instanceof CmisFilterNotValidException) {
                return 400;
            }
            if (ex instanceof CmisInvalidArgumentException) {
                return 400;
            }
            if (ex instanceof CmisNameConstraintViolationException) {
                return 409;
            }
            if (ex instanceof CmisNotSupportedException) {
                return 405;
            }
            if (ex instanceof CmisObjectNotFoundException) {
                return 404;
            }
            if (ex instanceof CmisPermissionDeniedException) {
                return 403;
            }
            if (ex instanceof CmisStorageException) {
                return 500;
            }
            if (ex instanceof CmisStreamNotSupportedException) {
                return 403;
            }
            if (ex instanceof CmisUpdateConflictException) {
                return 409;
            }
            if (ex instanceof CmisVersioningException) {
                return 409;
            }
            if (ex instanceof CmisTooManyRequestsException) {
                return 429;
            }
            if (ex instanceof CmisServiceUnavailableException) {
                return 503;
            }
            return 500;
        }

        public void printError(CallContext context, Exception ex, HttpServletRequest request, HttpServletResponse response) {
            int statusCode = 500;
            String exceptionName = "runtime";
            if (ex instanceof CmisRuntimeException) {
                LOG.error(CmisBrowserBindingServlet.createLogMessage(ex, request), (Throwable)ex);
                statusCode = this.getErrorCode((CmisBaseException)((CmisRuntimeException)ex));
            } else if (ex instanceof CmisStorageException) {
                LOG.error(CmisBrowserBindingServlet.createLogMessage(ex, request), (Throwable)ex);
                statusCode = this.getErrorCode((CmisBaseException)((CmisStorageException)ex));
                exceptionName = ((CmisStorageException)ex).getExceptionName();
            } else if (ex instanceof CmisBaseException) {
                statusCode = this.getErrorCode((CmisBaseException)ex);
                exceptionName = ((CmisBaseException)ex).getExceptionName();
                if (statusCode == 500) {
                    LOG.error(CmisBrowserBindingServlet.createLogMessage(ex, request), (Throwable)ex);
                }
            } else if (ex instanceof IOException) {
                LOG.warn(CmisBrowserBindingServlet.createLogMessage(ex, request), (Throwable)ex);
            } else {
                LOG.error(CmisBrowserBindingServlet.createLogMessage(ex, request), (Throwable)ex);
            }
            if (response.isCommitted()) {
                LOG.warn("Failed to send error message to client. Response is already committed.", (Throwable)ex);
                return;
            }
            String token = context instanceof BrowserCallContextImpl ? ((BrowserCallContextImpl)context).getToken() : null;
            String message = ex.getMessage();
            if (!(ex instanceof CmisBaseException)) {
                message = "An error occurred!";
            }
            if (token == null) {
                Map additionalData;
                response.resetBuffer();
                this.setStatus(request, response, statusCode);
                JSONObject jsonResponse = new JSONObject();
                jsonResponse.put("exception", (Object)exceptionName);
                jsonResponse.put("message", (Object)message);
                String st = ExceptionHelper.getStacktraceAsString(ex);
                if (st != null) {
                    jsonResponse.put("stacktrace", (Object)st);
                }
                if (ex instanceof CmisBaseException && (additionalData = ((CmisBaseException)ex).getAdditionalData()) != null && !additionalData.isEmpty()) {
                    for (Map.Entry e : additionalData.entrySet()) {
                        if ("exception".equalsIgnoreCase((String)e.getKey()) || "message".equalsIgnoreCase((String)e.getKey())) continue;
                        jsonResponse.put((String)e.getKey(), e.getValue());
                    }
                }
                try {
                    this.writeJSON((JSONStreamAware)jsonResponse, request, response);
                }
                catch (Exception e) {
                    LOG.error(CmisBrowserBindingServlet.createLogMessage(ex, request), (Throwable)e);
                    try {
                        response.sendError(statusCode, message);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.setStatus(request, response, 200);
                response.setContentType("text/html");
                response.setContentLength(0);
                if (context != null) {
                    this.setCookie(request, response, context.getRepositoryId(), token, this.createCookieValue(statusCode, null, exceptionName, message));
                }
            }
        }
    }

    public static enum CallUrl {
        SERVICE,
        REPOSITORY,
        ROOT;

    }
}

