/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.impl.AbstractCmisTest;
import org.apache.chemistry.opencmis.tck.impl.FatalTestException;
import org.apache.chemistry.opencmis.tck.impl.JUnitHelper;
import org.junit.Test;

public abstract class AbstractCmisTestGroup
implements CmisTestGroup {
    private Map<String, String> parameters;
    private String name;
    private String description;
    private final List<CmisTest> tests = new ArrayList<CmisTest>();
    private boolean isEnabled = true;
    private CmisTestProgressMonitor progressMonitor;

    @Override
    public void init(Map<String, String> parameters) throws Exception {
        this.parameters = parameters;
    }

    protected Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<CmisTest> getTests() {
        return this.tests;
    }

    public void addTest(CmisTest test) throws Exception {
        if (test != null) {
            this.tests.add(test);
            if (test instanceof AbstractCmisTest) {
                ((AbstractCmisTest)test).setGroup(this);
            }
            test.init(this.parameters);
        }
    }

    @Override
    public void setProgressMonitor(CmisTestProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    protected CmisTestProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        if (this.progressMonitor != null) {
            this.progressMonitor.startGroup(this);
        }
        try {
            this.preRun();
            for (CmisTest test : this.tests) {
                if (test == null || !test.isEnabled()) continue;
                try {
                    if (this.progressMonitor != null) {
                        this.progressMonitor.startTest(test);
                    }
                    this.preTest(test);
                    long start = System.currentTimeMillis();
                    test.run();
                    long end = System.currentTimeMillis();
                    if (!(test instanceof AbstractCmisTest)) continue;
                    ((AbstractCmisTest)test).setTime(end - start);
                }
                catch (Exception e) {
                    if (e instanceof FatalTestException) continue;
                    throw e;
                }
                finally {
                    this.postTest(test);
                    if (this.progressMonitor == null) continue;
                    this.progressMonitor.endTest(test);
                }
            }
        }
        finally {
            this.postRun();
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.endGroup(this);
        }
    }

    @Test
    public void junit() throws Exception {
        JUnitHelper.run(this);
    }

    protected void preRun() {
    }

    protected void postRun() {
    }

    protected void preTest(CmisTest test) {
    }

    protected void postTest(CmisTest test) {
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

