/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.report;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.report.AbstractCmisTestReport;

public class JsonReport
extends AbstractCmisTestReport {
    @Override
    public void createReport(Map<String, String> parameters, List<CmisTestGroup> groups, Writer writer) throws IOException {
        JSONObject jsonReport = new JSONObject();
        JSONObject jsonParameters = new JSONObject();
        jsonReport.put("parameters", (Object)jsonParameters);
        if (parameters != null) {
            for (Map.Entry<String, String> p : new TreeMap<String, String>(parameters).entrySet()) {
                jsonParameters.put(p.getKey(), (Object)p.getValue());
            }
        }
        if (groups != null) {
            JSONArray jsonGroups = new JSONArray();
            jsonReport.put("groups", (Object)jsonGroups);
            for (CmisTestGroup group : groups) {
                this.printGroupResults(group, jsonGroups);
            }
        }
        jsonReport.writeJSONString(writer);
        writer.flush();
    }

    private void printGroupResults(CmisTestGroup group, JSONArray jsonGroups) throws IOException {
        if (!group.isEnabled()) {
            return;
        }
        JSONObject jsonGroup = new JSONObject();
        jsonGroups.add((Object)jsonGroup);
        jsonGroup.put("name", (Object)group.getName());
        if (group.getTests() != null && !group.getTests().isEmpty()) {
            JSONArray jsonTests = new JSONArray();
            jsonGroup.put("tests", (Object)jsonTests);
            for (CmisTest test : group.getTests()) {
                this.printTestResults(test, jsonTests);
            }
        }
    }

    private void printTestResults(CmisTest test, JSONArray jsonTests) throws IOException {
        if (!test.isEnabled()) {
            return;
        }
        JSONObject jsonTest = new JSONObject();
        jsonTests.add((Object)jsonTest);
        jsonTest.put("name", (Object)test.getName());
        jsonTest.put("time", (Object)test.getTime());
        if (test.getResults() != null && !test.getResults().isEmpty()) {
            JSONArray jsonResults = new JSONArray();
            jsonTest.put("results", (Object)jsonResults);
            for (CmisTestResult result : test.getResults()) {
                this.printResult(result, jsonResults);
            }
        }
    }

    private void printResult(CmisTestResult result, JSONArray results) throws IOException {
        JSONObject jsonResult = new JSONObject();
        results.add((Object)jsonResult);
        jsonResult.put("status", (Object)result.getStatus().toString());
        jsonResult.put("message", (Object)result.getMessage());
        if (result.getStackTrace() != null && result.getStackTrace().length > 0) {
            jsonResult.put("file", (Object)(result.getStackTrace()[0].getFileName() + ":" + result.getStackTrace()[0].getLineNumber()));
        }
        if (result.getStatus() == CmisTestResultStatus.UNEXPECTED_EXCEPTION && result.getException() != null) {
            CmisBaseException cbe;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            result.getException().printStackTrace(pw);
            jsonResult.put("stacktrace", (Object)sw.toString());
            if (result.getException() instanceof CmisBaseException && (cbe = (CmisBaseException)result.getException()).getErrorContent() != null) {
                jsonResult.put("errorcontent", (Object)cbe.getErrorContent());
            }
        }
        if (result.getException() != null) {
            jsonResult.put("exception", (Object)result.getException().getMessage());
        }
        if (result.getRequest() != null) {
            jsonResult.put("request", (Object)result.getRequest());
        }
        if (result.getRequest() != null) {
            jsonResult.put("response", (Object)result.getResponse());
        }
        if (!result.getChildren().isEmpty()) {
            JSONArray nextLevel = new JSONArray();
            jsonResult.put("results", (Object)nextLevel);
            for (CmisTestResult child : result.getChildren()) {
                this.printResult(child, nextLevel);
            }
        }
    }
}

