/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.basics;

import java.util.Locale;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class SecurityTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Security Test");
        this.setDescription("Checks if HTTPS is used.");
    }

    @Override
    public void run(Session session) throws Exception {
        BindingType binding = this.getBinding();
        this.addResult(this.createInfoResult("Binding: " + binding));
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.WARNING, "HTTPS is not used. Credentials might be transferred as plain text!");
        switch (binding) {
            case ATOMPUB: {
                if (SecurityTest.isHttpsUrl(this.getParameters().get("org.apache.chemistry.opencmis.binding.atompub.url"))) break;
                this.addResult(f);
                break;
            }
            case WEBSERVICES: {
                if (SecurityTest.isHttpsUrl(this.getParameters().get("org.apache.chemistry.opencmis.binding.webservices.RepositoryService"))) break;
                this.addResult(f);
                break;
            }
            case BROWSER: {
                if (SecurityTest.isHttpsUrl(this.getParameters().get("org.apache.chemistry.opencmis.binding.browser.url"))) break;
                this.addResult(f);
                break;
            }
        }
    }

    private static boolean isHttpsUrl(String url) {
        if (url == null) {
            return false;
        }
        return url.trim().toLowerCase(Locale.ENGLISH).startsWith("https://");
    }
}

