/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class CreateBigDocument
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create Big Document Test");
        this.setDescription("Creates a 10 MiB document and deletes it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        Folder testFolder = this.createTestFolder(session);
        try {
            String name = "bigdoc";
            String objectTypeId = this.getDocumentTestTypeId();
            String mimetype = "application/octet-stream";
            long size = 0xA00000L;
            InputStream in = new InputStream(){
                private int counter = -1;

                @Override
                public int read() throws IOException {
                    ++this.counter;
                    if ((long)this.counter >= 0xA00000L) {
                        return -1;
                    }
                    return 48 + this.counter / 10;
                }
            };
            ContentStream contentStream = session.getObjectFactory().createContentStream(name, 0xA00000L, mimetype, in);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", name);
            properties.put("cmis:objectTypeId", objectTypeId);
            ObjectType type = session.getTypeDefinition(objectTypeId);
            if (!(type instanceof DocumentTypeDefinition)) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Type is not a document type! Type: " + objectTypeId, true));
                return;
            }
            DocumentTypeDefinition docType = (DocumentTypeDefinition)type;
            VersioningState versioningState = Boolean.TRUE.equals(docType.isVersionable()) ? VersioningState.MAJOR : VersioningState.NONE;
            ObjectId id = session.createDocument(properties, (ObjectId)testFolder, contentStream, versioningState);
            Document doc = (Document)session.getObject(id, SELECT_ALL_NO_CACHE_OC);
            this.addResult(this.checkObject(session, (CmisObject)doc, this.getAllProperties((CmisObject)doc), "New document object spec compliance"));
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Content stream length doesn't match the uploaded content!", true);
            this.assertEquals(0xA00000L, doc.getContentStreamLength(), null, (CmisTestResult)f);
            doc.delete(true);
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

