/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.InputStream;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class NameCharsetTest
extends AbstractSessionTest {
    private static final String[] NAMES = new String[]{"document", "Schriftst\u00fcck", "\u0648\u062b\u064a\u0642\u0629", "s\u0259n\u0259d", "\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442", "\u6587\u4ef6", "\u03ad\u03b3\u03b3\u03c1\u03b1\u03c6\u03bf", "\u0aa6\u0ab8\u0acd\u0aa4\u0abe\u0ab5\u0ac7\u0a9c", "\u0926\u0938\u094d\u0924\u093e\u0935\u0947\u091c\u093c", "doicim\u00e9ad", "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8", "\u05d3\u05d0\u05b8\u05e7\u05d5\u05de\u05e2\u05e0\u05d8", "\u0ca6\u0cbe\u0c96\u0cb2\u0cc6", "\ubb38\uc11c", "\u0633\u0646\u062f", "\u0b86\u0bb5\u0ba3\u0bae\u0bcd", "\u0c2a\u0c24\u0c4d\u0c30\u0c02", "\u0e40\u0e2d\u0e01\u0e2a\u0e32\u0e23", "\u062f\u0633\u062a\u0627\u0648\u06cc\u0632", "t\u00e0i li\u1ec7u", "a&b", "abc%_Pxyz"};

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Name Charset Test");
        this.setDescription("Creates and deletes documents with special characters in cmis:name.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        Folder testFolder = this.createTestFolder(session);
        try {
            for (int i = 0; i < NAMES.length; ++i) {
                Document doc = null;
                Document doc2 = null;
                try {
                    doc = null;
                    doc = this.createDocument(session, testFolder, NAMES[i], NAMES[i]);
                    String path = (String)doc.getPaths().get(0);
                    doc2 = (Document)session.getObjectByPath(path, SELECT_ALL_NO_CACHE_OC);
                    this.addResult(this.checkObject(session, (CmisObject)doc2, this.getAllProperties((CmisObject)doc2), "New document object spec compliance"));
                    CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Names of the created and the fetched document don't match!");
                    this.assertEquals(NAMES[i], doc2.getName(), null, (CmisTestResult)f);
                    ContentStream contentStream = doc.getContentStream();
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Document has no content!");
                    this.assertNotNull(contentStream, null, f);
                    IOUtils.consumeAndClose((InputStream)contentStream.getStream());
                    continue;
                }
                catch (Exception e) {
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "The name '" + NAMES[i] + "' raised this exception: " + e, e, false));
                    continue;
                }
                finally {
                    if (doc != null) {
                        try {
                            doc.delete(true);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.addResult(this.createInfoResult("Tested " + NAMES.length + " different names."));
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

