/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;

public class WhitespaceInNameTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Whitespace in Name Test");
        this.setDescription("Creates documents with spaces in cmis:name.");
    }

    @Override
    public void run(Session session) {
        Folder testFolder = this.createTestFolder(session);
        try {
            this.testCenterSpaceSpace(session, testFolder);
            this.testMultipleCenterSpaceSpace(session, testFolder);
            this.testLeadingSpace(session, testFolder);
            this.testTrailingSpace(session, testFolder);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    private void testLeadingSpace(Session session, Folder testFolder) {
        String name = "leading.txt";
        try {
            Document doc = this.createDocumentWithoutChecks(testFolder, " " + name);
            if (doc.getName().equals(" " + name)) {
                this.addResult(this.createInfoResult("Repository does supports document names with a leading space."));
            } else if (doc.getName().equals(name)) {
                this.addResult(this.createInfoResult("Repository removes leading space from document name."));
            } else {
                this.addResult(this.createInfoResult("Repository renames documents with a leading space."));
            }
        }
        catch (CmisBaseException e) {
            this.addResult(this.createInfoResult("Repository does not support document names with a leading space. Exception: " + e.toString()));
        }
    }

    private void testTrailingSpace(Session session, Folder testFolder) {
        String name = "trailing.txt";
        try {
            Document doc = this.createDocumentWithoutChecks(testFolder, name + " ");
            if (doc.getName().equals(name + " ")) {
                this.addResult(this.createInfoResult("Repository does supports document names with a trailing space."));
            } else if (doc.getName().equals(name)) {
                this.addResult(this.createInfoResult("Repository removes trailing space from document name."));
            } else {
                this.addResult(this.createInfoResult("Repository renames documents with a trailing space."));
            }
        }
        catch (CmisBaseException e) {
            this.addResult(this.createInfoResult("Repository does not support document names with a trailing space. Exception: " + e.toString()));
        }
    }

    private void testCenterSpaceSpace(Session session, Folder testFolder) {
        String name = "center space.txt";
        try {
            Document doc = this.createDocumentWithoutChecks(testFolder, name);
            if (doc.getName().equals(name)) {
                this.addResult(this.createInfoResult("Repository does supports document names with a space."));
            } else if (doc.getName().equals("centerspace.txt")) {
                this.addResult(this.createInfoResult("Repository removes spaces from document name."));
            } else {
                this.addResult(this.createInfoResult("Repository renames documents with a space."));
            }
        }
        catch (CmisBaseException e) {
            this.addResult(this.createInfoResult("Repository does not support document names with a space. Exception: " + e.toString()));
        }
    }

    private void testMultipleCenterSpaceSpace(Session session, Folder testFolder) {
        String name = "twocenter  spaces.txt";
        try {
            Document doc = this.createDocumentWithoutChecks(testFolder, name);
            if (doc.getName().equals(name)) {
                this.addResult(this.createInfoResult("Repository does supports document names with more than one successive spaces."));
            } else if (doc.getName().equals("twocenterspaces.txt")) {
                this.addResult(this.createInfoResult("Repository removes spaces from document name."));
            } else if (doc.getName().equals("twocenter spaces.txt")) {
                this.addResult(this.createInfoResult("Repository combines multiple spaces into one in document names."));
            } else {
                this.addResult(this.createInfoResult("Repository renames documents with a space."));
            }
        }
        catch (CmisBaseException e) {
            this.addResult(this.createInfoResult("Repository does not support document names with a space. Exception: " + e.toString()));
        }
    }

    private Document createDocumentWithoutChecks(Folder parent, String name) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", this.getDocumentTestTypeId());
        ContentStreamImpl contentStream = new ContentStreamImpl(name, BigInteger.ZERO, "text/plain", (InputStream)new ByteArrayInputStream(new byte[0]));
        return parent.createDocument(properties, (ContentStream)contentStream, null, null, null, null, SELECT_ALL_NO_CACHE_OC);
    }
}

