/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.filing;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class MultifilingTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Multifiling Test");
        this.setDescription("Creates two folders and a document in one of the folders, adds the document to the second folder and then removes it again for the second folder.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.supportsMultifiling(session)) {
            try {
                Folder testFolder = this.createTestFolder(session);
                Folder folder1 = this.createFolder(session, testFolder, "folder1");
                Folder folder2 = this.createFolder(session, testFolder, "folder2");
                Document doc1 = this.createDocument(session, folder1, "testdoc.txt", "multifiling test");
                this.addResult(this.checkChildren(session, folder1, "Folder 1 after createDocument()"));
                this.addResult(this.checkChildren(session, folder2, "Folder 2 after createDocument()"));
                int count1 = this.countFolderChildren(folder1);
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Folder 1 should have exactly one child but has " + count1 + " children!");
                this.addResult(this.assertEquals(1, count1, null, (CmisTestResult)f));
                int count2 = this.countFolderChildren(folder2);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder 2 should not have children but has " + count2 + " children!");
                this.addResult(this.assertEquals(0, count2, null, (CmisTestResult)f));
                int parents = doc1.getParents().size();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should have one parent but has " + parents + " parents!");
                this.addResult(this.assertEquals(1, parents, null, (CmisTestResult)f));
                doc1.addToFolder((ObjectId)folder2, true);
                this.addResult(this.checkChildren(session, folder1, "Folder 1 after addToFolder()"));
                this.addResult(this.checkChildren(session, folder2, "Folder 2 after addToFolder()"));
                count1 = this.countFolderChildren(folder1);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder 1 should have exactly one child but has " + count1 + " children!");
                this.addResult(this.assertEquals(1, count1, null, (CmisTestResult)f));
                count2 = this.countFolderChildren(folder2);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder 2 should have exactly one child but has " + count2 + " children!");
                this.addResult(this.assertEquals(1, count2, null, (CmisTestResult)f));
                parents = doc1.getParents().size();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should have two parents but has " + parents + " parents!");
                this.addResult(this.assertEquals(2, parents, null, (CmisTestResult)f));
                doc1.removeFromFolder((ObjectId)folder2);
                this.addResult(this.checkChildren(session, folder1, "Folder 1 after removeFromFolder()"));
                this.addResult(this.checkChildren(session, folder2, "Folder 2 after removeFromFolder()"));
                count1 = this.countFolderChildren(folder1);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder 1 should have exactly one child but has " + count1 + " children!");
                this.addResult(this.assertEquals(1, count1, null, (CmisTestResult)f));
                count2 = this.countFolderChildren(folder2);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder 2 should not have children but has " + count2 + " children!");
                this.addResult(this.assertEquals(0, count2, null, (CmisTestResult)f));
                parents = doc1.getParents().size();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should have one parent but has " + parents + " parents!");
                this.addResult(this.assertEquals(1, parents, null, (CmisTestResult)f));
                this.deleteObject((CmisObject)doc1);
                this.deleteObject((CmisObject)folder2);
                this.deleteObject((CmisObject)folder1);
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Multifling not supported. Test Skipped!"));
        }
    }

    protected boolean supportsMultifiling(Session session) {
        RepositoryInfo repository = session.getRepositoryInfo();
        if (repository.getCapabilities().isMultifilingSupported() == null) {
            return false;
        }
        return repository.getCapabilities().isMultifilingSupported();
    }
}

