/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.versioning;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class CheckedOutTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Checked out Test");
        this.setDescription("Calls getCheckedOutDocs() and checks the returned objects.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        boolean supportsOrderByName = this.isOrderByNameSupported(session);
        OperationContext orderContext = supportsOrderByName ? SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME : SELECT_ALL_NO_CACHE_OC;
        Document pwc = null;
        try {
            CmisTestResultImpl f;
            Folder testFolder = this.createTestFolder(session);
            Document doc = this.createDocument(session, testFolder, "checkedouttest.txt", "checked out");
            DocumentTypeDefinition docType = (DocumentTypeDefinition)doc.getType();
            if (!docType.isVersionable().booleanValue()) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Test type is not versionable. Check out skipped!"));
            } else {
                ObjectId pwcId = doc.checkOut();
                pwc = (Document)session.getObject(pwcId, SELECT_ALL_NO_CACHE_OC);
            }
            int sessionCheckedOut = this.checkPWCs(session, (ItemIterable<Document>)session.getCheckedOutDocs(orderContext), supportsOrderByName);
            this.addResult(this.createInfoResult(sessionCheckedOut + " checked out document(s) overall."));
            if (pwc != null) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "There should be at least one checked out document in the repository!");
                this.addResult(this.assertIsTrue(sessionCheckedOut >= 1, null, f));
            }
            int testFolderCheckedOut = this.checkPWCs(session, (ItemIterable<Document>)testFolder.getCheckedOutDocs(orderContext), supportsOrderByName);
            this.addResult(this.createInfoResult(testFolderCheckedOut + " checked out document(s) in the test folder."));
            if (pwc != null) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "There should be at least one checked out document in the test folder!");
                this.addResult(this.assertIsTrue(testFolderCheckedOut >= 1, null, f));
            }
            if (pwc != null) {
                pwc.cancelCheckOut();
                pwc = null;
            }
            this.deleteObject((CmisObject)doc);
        }
        finally {
            if (pwc != null) {
                pwc.cancelCheckOut();
            }
            this.deleteTestFolder();
        }
    }

    private int checkPWCs(Session session, ItemIterable<Document> pwcs, boolean checkOrder) {
        CmisTestResultImpl f;
        if (pwcs == null) {
            return 0;
        }
        int i = 0;
        int orderByNameIssues = 0;
        String lastName = null;
        for (Document pwc : pwcs) {
            if (pwc == null) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "The list of checked out documents contains a null entry!"));
                continue;
            }
            String[] propertiesToCheck = this.getAllProperties((CmisObject)pwc);
            this.addResult(this.checkObject(session, (CmisObject)pwc, propertiesToCheck, "PWC check: " + pwc.getId()));
            if (session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
                f = this.createResult(CmisTestResultStatus.WARNING, "PWC is not the latest version! Id: " + pwc.getId() + " (Note: The words of the CMIS specification define that the PWC is the latest version. But that is not the intention of the spec and will be changed in CMIS 1.1. Thus this a warning, not an error.)");
                this.addResult(this.assertIsTrue(pwc.isLatestVersion(), null, f));
            } else {
                f = this.createResult(CmisTestResultStatus.FAILURE, "The property value of 'cmis:isLatestVersion' is TRUE for a PWC! Id: " + pwc.getId());
                this.addResult(this.assertIsFalse(pwc.isLatestVersion(), null, f));
                f = this.createResult(CmisTestResultStatus.FAILURE, "The property value of 'cmis:isLatestMajorVersion' is TRUE for a PWC! Id: " + pwc.getId());
                this.addResult(this.assertIsFalse(pwc.isLatestMajorVersion(), null, f));
            }
            if (lastName != null && pwc.getName() != null && pwc.getName().compareToIgnoreCase(lastName) < 0) {
                ++orderByNameIssues;
            }
            lastName = pwc.getName();
            ++i;
        }
        if (checkOrder) {
            f = this.createResult(CmisTestResultStatus.WARNING, "Checked-out documents should be ordered by cmis:name, but they are not! (It might be a collation mismatch.)");
            this.addResult(this.assertEquals(0, orderByNameIssues, null, (CmisTestResult)f));
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.INFO, "Repository doesn't support Order By for getCheckedOutDocs()."));
        }
        return i;
    }
}

