/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.versioning;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class LatestAccessibleStateIdTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Latest Accessible State ID Test");
        this.setDescription("Creates a document and tries to get it with its Latest Accessible State ID.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        try {
            Folder testFolder = this.createTestFolder(session);
            Document doc = this.createDocument(session, testFolder, "lateststate.txt", "latest state");
            DocumentTypeDefinition docType = (DocumentTypeDefinition)doc.getType();
            if (!docType.getPropertyDefinitions().containsKey("cmis:latestAccessibleStateId")) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Repository does not support the Latest State Identifier feature extension. Test skipped!"));
                doc.delete(true);
                return;
            }
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Latest Accessible State ID is not set!");
            this.addResult(this.assertStringNotEmpty(doc.getLatestAccessibleStateId(), null, f));
            try {
                CmisObject latestStateObject = session.getObject(doc.getLatestAccessibleStateId(), SELECT_ALL_NO_CACHE_OC);
                if (latestStateObject instanceof Document) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Latest Accessible State IDs of the orignal and the retrieved document don't match!");
                    this.addResult(this.assertEquals(doc.getLatestAccessibleStateId(), ((Document)latestStateObject).getLatestAccessibleStateId(), null, (CmisTestResult)f));
                } else {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Object retrieved with the Latest Accessible State ID is not a document!"));
                }
            }
            catch (CmisObjectNotFoundException onf) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Document could not be retrieved with the Latest Accessible State ID!"));
            }
            doc.delete(true);
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

