/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.expression;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cocoon.el.Expression;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;

public class JXTExpression
implements Subst {
    private String raw;
    private Object compiledExpression;
    protected static final Iterator NULL_ITER = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
        }
    };

    public JXTExpression(String raw, Object expr) {
        this.raw = raw;
        this.compiledExpression = expr;
    }

    public Object getCompiledExpression() {
        return this.compiledExpression;
    }

    public void setCompiledExpression(Object compiledExpression) {
        this.compiledExpression = compiledExpression;
    }

    public String getRaw() {
        return this.raw;
    }

    public Object getNode(ObjectModel objectModel) throws Exception {
        Object compiled = this.getCompiledExpression();
        if (compiled instanceof Expression) {
            return ((Expression)compiled).getNode(objectModel);
        }
        return this.getRaw();
    }

    public Iterator getIterator(ObjectModel objectModel) throws Exception {
        Iterator iter = this.getCompiledExpression() != null || this.getRaw() != null ? (this.getCompiledExpression() instanceof Expression ? ((Expression)this.getCompiledExpression()).iterate(objectModel) : new Iterator(){
            Object val = this;

            public boolean hasNext() {
                return this.val != null;
            }

            public Object next() {
                Object res = this.val;
                if (res != null) {
                    this.val = null;
                    return res;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
            }
        }) : NULL_ITER;
        return iter;
    }

    public Object getValue(ObjectModel objectModel) throws Exception {
        Object compiled = this.getCompiledExpression();
        if (compiled != null) {
            if (compiled instanceof Expression) {
                return ((Expression)compiled).evaluate(objectModel);
            }
            return compiled;
        }
        return this.getRaw();
    }

    public Boolean getBooleanValue(ObjectModel objectModel) throws Exception {
        Object res = this.getValue(objectModel);
        return res instanceof Boolean ? (Boolean)res : null;
    }

    public String getStringValue(ObjectModel objectModel) throws Exception {
        Object res = this.getValue(objectModel);
        if (res != null) {
            return res.toString();
        }
        if (this.getCompiledExpression() == null) {
            return this.getRaw();
        }
        return null;
    }

    public Number getNumberValue(ObjectModel objectModel) throws Exception {
        Object res = this.getValue(objectModel);
        if (res instanceof Number) {
            return (Number)res;
        }
        if (res != null) {
            return Double.valueOf(res.toString());
        }
        return null;
    }

    public int getIntValue(ObjectModel objectModel) throws Exception {
        Object res = this.getValue(objectModel);
        return res instanceof Number ? ((Number)res).intValue() : 0;
    }

    public void setLenient(Boolean lenient) {
        if (this.compiledExpression instanceof Expression) {
            ((Expression)this.compiledExpression).setProperty("lenient", (Object)lenient);
        }
    }
}

